/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.sizes;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.naming.AccessModifierOption;
import com.puppycrawl.tools.checkstyle.utils.CheckUtil;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;

@StatelessCheck
public class RecordComponentNumberCheck
extends AbstractCheck {
    public static final String MSG_KEY = "too.many.components";
    private static final int DEFAULT_MAX_COMPONENTS = 8;
    private int max = 8;
    private AccessModifierOption[] accessModifiers = new AccessModifierOption[]{AccessModifierOption.PUBLIC, AccessModifierOption.PROTECTED, AccessModifierOption.PACKAGE, AccessModifierOption.PRIVATE};

    public void setMax(int value) {
        this.max = value;
    }

    public void setAccessModifiers(AccessModifierOption ... accessModifiers) {
        this.accessModifiers = Arrays.copyOf(accessModifiers, accessModifiers.length);
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{199};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST recordComponents;
        int componentCount;
        DetailAST modifiers = ast.findFirstToken(5);
        AccessModifierOption accessModifier = CheckUtil.getAccessModifierFromModifiersToken(modifiers);
        if (this.matchAccessModifiers(accessModifier) && (componentCount = RecordComponentNumberCheck.countComponents(recordComponents = ast.findFirstToken(201))) > this.max) {
            this.log(ast, MSG_KEY, componentCount, this.max);
        }
    }

    private static int countComponents(DetailAST recordComponents) {
        AtomicInteger count = new AtomicInteger(0);
        TokenUtil.forEachChild(recordComponents, 202, node -> count.getAndIncrement());
        return count.get();
    }

    private boolean matchAccessModifiers(AccessModifierOption accessModifier) {
        return Arrays.stream(this.accessModifiers).anyMatch(modifier -> modifier == accessModifier);
    }
}

