/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.auth;

import com.qcloud.cos.auth.BasicSessionCredentials;

public class InstanceProfileCredentials
extends BasicSessionCredentials {
    private static final long DEFAULT_EXPIRATION_DURATION_SECONDS = 1800L;
    private static final double DEFAULT_EXPIRED_FACTOR = 0.2;
    private final long expiredTime;
    private long expirationDurationSeconds = 1800L;
    private double expiredFactor = 0.2;

    @Deprecated
    public InstanceProfileCredentials(String appId, String accessKey, String secretKey, String sessionToken, long expiredTime) {
        super(appId, accessKey, secretKey, sessionToken);
        this.expiredTime = expiredTime;
        this.expirationDurationSeconds = this.expiredTime - System.currentTimeMillis() / 1000L;
    }

    public InstanceProfileCredentials(String accessKey, String secretKey, String sessionToken, long expiredTime) {
        super(accessKey, secretKey, sessionToken);
        this.expiredTime = expiredTime;
        this.expirationDurationSeconds = this.expiredTime - System.currentTimeMillis() / 1000L;
    }

    public InstanceProfileCredentials withExpiredFactor(double expiredFactor) {
        this.expiredFactor = expiredFactor;
        return this;
    }

    public long getExpiredTime() {
        return this.expiredTime;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() / 1000L >= this.expiredTime - 30L;
    }

    public boolean willSoonExpire() {
        return (double)this.expirationDurationSeconds * this.expiredFactor >= (double)this.expiredTime - (double)System.currentTimeMillis() / 1000.0;
    }
}

