/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.qiniu.util.StringMap;

public final class UploadOptions {
    public final StringMap params;
    public final StringMap metaDataParam;
    public final String mimeType;
    public final boolean checkCrc;

    public static UploadOptions defaultOptions() {
        return new Builder().build();
    }

    private UploadOptions(StringMap params, StringMap metaDataParam, String mimeType, boolean checkCrc) {
        this.params = params;
        this.metaDataParam = metaDataParam;
        this.mimeType = mimeType;
        this.checkCrc = checkCrc;
    }

    public static class Builder {
        private StringMap params;
        private StringMap metaDataParam;
        private String mimeType;
        private boolean checkCrc;

        public Builder params(StringMap params) {
            this.params = params;
            return this;
        }

        public Builder metaData(StringMap params) {
            this.metaDataParam = params;
            return this;
        }

        public Builder mimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public Builder checkCrc(boolean checkCrc) {
            this.checkCrc = checkCrc;
            return this;
        }

        public UploadOptions build() {
            this.mimeType = this.mime(this.mimeType);
            this.params = this.filterParam(this.params);
            this.metaDataParam = this.filterMetaData(this.metaDataParam);
            return new UploadOptions(this.params, this.metaDataParam, this.mimeType, this.checkCrc);
        }

        private String mime(String mimeType) {
            if (mimeType == null || mimeType.equals("")) {
                return "application/octet-stream";
            }
            return mimeType;
        }

        private StringMap filterParam(StringMap params) {
            final StringMap ret = new StringMap();
            if (params == null) {
                return ret;
            }
            params.forEach(new StringMap.Consumer(){

                @Override
                public void accept(String key, Object value) {
                    ret.putWhen(key, value, key != null && key.startsWith("x:") && value != null && !value.equals(""));
                }
            });
            return ret;
        }

        private StringMap filterMetaData(StringMap params) {
            final StringMap ret = new StringMap();
            if (params == null) {
                return ret;
            }
            params.forEach(new StringMap.Consumer(){

                @Override
                public void accept(String key, Object value) {
                    ret.putWhen(key, value, key != null && key.startsWith("x-qn-meta-") && value != null && !value.equals(""));
                }
            });
            return ret;
        }
    }
}

