/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import javax.xml.namespace.QName;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.impl.dv.xs.TypeValidator;
import org.apache.xerces.util.XML11Char;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.xs.datatypes.XSQName;

public class QNameDV
extends TypeValidator {
    private static final String EMPTY_STRING = "".intern();

    @Override
    public Object getActualValue(String content, ValidationContext context) throws InvalidDatatypeValueException {
        boolean isXML10;
        String localpart;
        String prefix;
        int colonptr = content.indexOf(":");
        if (colonptr > 0) {
            prefix = context.getSymbol(content.substring(0, colonptr));
            localpart = content.substring(colonptr + 1);
        } else {
            prefix = EMPTY_STRING;
            localpart = content;
        }
        boolean bl = isXML10 = context.getDatatypeXMLVersion() == 1;
        if (prefix.length() > 0 && (isXML10 ? !XMLChar.isValidNCName(prefix) : !XML11Char.isXML11ValidNCName(prefix))) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{content, "QName"});
        }
        if (isXML10 ? !XMLChar.isValidNCName(localpart) : !XML11Char.isXML11ValidNCName(localpart)) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{content, "QName"});
        }
        String uri = context.getURI(prefix);
        if (prefix.length() > 0 && uri == null) {
            throw new InvalidDatatypeValueException("UndeclaredPrefix", new Object[]{content, prefix});
        }
        return new XQName(prefix, context.getSymbol(localpart), context.getSymbol(content), uri);
    }

    @Override
    public int getDataLength(Object value) {
        return ((XQName)value).rawname.length();
    }

    private static final class XQName
    extends org.apache.xerces.xni.QName
    implements XSQName {
        public XQName(String prefix, String localpart, String rawname, String uri) {
            this.setValues(prefix, localpart, rawname, uri);
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof org.apache.xerces.xni.QName) {
                org.apache.xerces.xni.QName qname = (org.apache.xerces.xni.QName)object;
                return this.uri == qname.uri && this.localpart == qname.localpart;
            }
            return false;
        }

        @Override
        public String toString() {
            return this.rawname;
        }

        @Override
        public QName getJAXPQName() {
            return new QName(this.uri, this.localpart, this.prefix);
        }

        @Override
        public org.apache.xerces.xni.QName getXNIQName() {
            return this;
        }
    }
}

