/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.models;

import java.util.Vector;
import org.apache.xerces.impl.xs.SubstitutionGroupHandler;
import org.apache.xerces.impl.xs.XMLSchemaException;
import org.apache.xerces.impl.xs.XSConstraints;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSElementDeclHelper;
import org.apache.xerces.impl.xs.models.XSCMValidator;
import org.apache.xerces.xni.QName;

public class XSAllCM
implements XSCMValidator {
    private static final short STATE_START = 0;
    private static final short STATE_VALID = 1;
    private static final short STATE_CHILD = 1;
    private final XSElementDecl[] fAllElements;
    private final boolean[] fIsOptionalElement;
    private final boolean fHasOptionalContent;
    private int fNumElements = 0;
    private final short fSchemaVersion;

    public XSAllCM(boolean hasOptionalContent, int size, short schemaVersion) {
        this.fHasOptionalContent = hasOptionalContent;
        this.fAllElements = new XSElementDecl[size];
        this.fIsOptionalElement = new boolean[size];
        this.fSchemaVersion = schemaVersion;
    }

    public void addElement(XSElementDecl element, boolean isOptional) {
        this.fAllElements[this.fNumElements] = element;
        this.fIsOptionalElement[this.fNumElements] = isOptional;
        ++this.fNumElements;
    }

    @Override
    public int[] startContentModel() {
        int[] state = new int[this.fNumElements + 1];
        for (int i = 0; i <= this.fNumElements; ++i) {
            state[i] = 0;
        }
        return state;
    }

    Object findMatchingDecl(QName elementName, SubstitutionGroupHandler subGroupHandler) {
        XSElementDecl matchingDecl = null;
        for (int i = 0; i < this.fNumElements && (matchingDecl = subGroupHandler.getMatchingElemDecl(elementName, this.fAllElements[i], this.fSchemaVersion)) == null; ++i) {
        }
        return matchingDecl;
    }

    @Override
    public Object oneTransition(QName elementName, int[] currentState, SubstitutionGroupHandler subGroupHandler, XSElementDeclHelper eDeclHelper) {
        if (currentState[0] < 0) {
            currentState[0] = -2;
            return this.findMatchingDecl(elementName, subGroupHandler);
        }
        currentState[0] = 1;
        XSElementDecl matchingDecl = null;
        for (int i = 0; i < this.fNumElements; ++i) {
            if (currentState[i + 1] != 0 || (matchingDecl = subGroupHandler.getMatchingElemDecl(elementName, this.fAllElements[i], this.fSchemaVersion)) == null) continue;
            currentState[i + 1] = 1;
            return matchingDecl;
        }
        currentState[0] = -1;
        return this.findMatchingDecl(elementName, subGroupHandler);
    }

    @Override
    public boolean endContentModel(int[] currentState) {
        int state = currentState[0];
        if (state == -1 || state == -2) {
            return false;
        }
        if (this.fHasOptionalContent && state == 0) {
            return true;
        }
        for (int i = 0; i < this.fNumElements; ++i) {
            if (this.fIsOptionalElement[i] || currentState[i + 1] != 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean checkUniqueParticleAttribution(SubstitutionGroupHandler subGroupHandler, XSConstraints xsConstraints) throws XMLSchemaException {
        for (int i = 0; i < this.fNumElements; ++i) {
            for (int j = i + 1; j < this.fNumElements; ++j) {
                if (!xsConstraints.overlapUPA((Object)this.fAllElements[i], (Object)this.fAllElements[j], subGroupHandler)) continue;
                throw new XMLSchemaException("cos-nonambig", new Object[]{this.fAllElements[i].toString(), this.fAllElements[j].toString()});
            }
        }
        return false;
    }

    @Override
    public Vector whatCanGoHere(int[] state) {
        Vector<XSElementDecl> ret = new Vector<XSElementDecl>();
        for (int i = 0; i < this.fNumElements; ++i) {
            if (state[i + 1] != 0) continue;
            ret.addElement(this.fAllElements[i]);
        }
        return ret;
    }

    @Override
    public int[] occurenceInfo(int[] state) {
        return null;
    }

    @Override
    public String getTermName(int termId) {
        return null;
    }

    @Override
    public boolean isCompactedForUPA() {
        return false;
    }

    @Override
    public XSElementDecl findMatchingElemDecl(QName elementName, SubstitutionGroupHandler subGroupHandler) {
        for (int i = 1; i < this.fNumElements; ++i) {
            XSElementDecl matchingDecl = subGroupHandler.getMatchingElemDecl(elementName, this.fAllElements[i], (short)1);
            if (matchingDecl == null) continue;
            return matchingDecl;
        }
        return null;
    }
}

