/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.traversers;

import java.util.Vector;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.XSAnnotationImpl;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.impl.xs.XSWildcardDecl;
import org.apache.xerces.impl.xs.traversers.XSAttributeChecker;
import org.apache.xerces.impl.xs.traversers.XSDAbstractTraverser;
import org.apache.xerces.impl.xs.traversers.XSDHandler;
import org.apache.xerces.impl.xs.traversers.XSDocumentInfo;
import org.apache.xerces.impl.xs.util.XInt;
import org.apache.xerces.impl.xs.util.XSObjectListImpl;
import org.apache.xerces.util.DOMUtil;
import org.apache.xerces.xni.QName;
import org.w3c.dom.Element;

class XSDWildcardTraverser
extends XSDAbstractTraverser {
    XSDWildcardTraverser(XSDHandler handler, XSAttributeChecker gAttrCheck) {
        super(handler, gAttrCheck);
    }

    XSParticleDecl traverseAny(Element elmNode, XSDocumentInfo schemaDoc, SchemaGrammar grammar) {
        Object[] attrValues = this.fAttrChecker.checkAttributes(elmNode, false, schemaDoc);
        XSWildcardDecl wildcard = this.traverseWildcardDecl(elmNode, attrValues, schemaDoc, grammar);
        XSParticleDecl particle = null;
        if (wildcard != null) {
            int min = ((XInt)attrValues[XSAttributeChecker.ATTIDX_MINOCCURS]).intValue();
            int max = ((XInt)attrValues[XSAttributeChecker.ATTIDX_MAXOCCURS]).intValue();
            if (max != 0) {
                particle = this.fSchemaHandler.fDeclPool != null ? this.fSchemaHandler.fDeclPool.getParticleDecl() : new XSParticleDecl();
                particle.fType = (short)2;
                particle.fValue = wildcard;
                particle.fMinOccurs = min;
                particle.fMaxOccurs = max;
                particle.fAnnotations = wildcard.fAnnotations;
            }
        }
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        return particle;
    }

    XSWildcardDecl traverseAnyAttribute(Element elmNode, XSDocumentInfo schemaDoc, SchemaGrammar grammar) {
        Object[] attrValues = this.fAttrChecker.checkAttributes(elmNode, false, schemaDoc);
        XSWildcardDecl wildcard = this.traverseWildcardDecl(elmNode, attrValues, schemaDoc, grammar);
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        return wildcard;
    }

    XSWildcardDecl traverseWildcardDecl(Element elmNode, Object[] attrValues, XSDocumentInfo schemaDoc, SchemaGrammar grammar) {
        XSObjectListImpl annotations;
        String text;
        XSWildcardDecl wildcard = new XSWildcardDecl();
        XInt namespaceTypeAttr = (XInt)attrValues[XSAttributeChecker.ATTIDX_NAMESPACE];
        wildcard.fType = namespaceTypeAttr != null ? namespaceTypeAttr.shortValue() : (short)1;
        wildcard.fNamespaceList = (String[])attrValues[XSAttributeChecker.ATTIDX_NAMESPACE_LIST];
        XInt processContentsAttr = (XInt)attrValues[XSAttributeChecker.ATTIDX_PROCESSCONTENTS];
        wildcard.fProcessContents = processContentsAttr.shortValue();
        if (this.fSchemaHandler.fSchemaVersion == 4) {
            this.processExtraAttributes(elmNode, attrValues, wildcard);
        }
        Element child = DOMUtil.getFirstChildElement(elmNode);
        XSAnnotationImpl annotation = null;
        if (child != null) {
            if (DOMUtil.getLocalName(child).equals(SchemaSymbols.ELT_ANNOTATION)) {
                annotation = this.traverseAnnotationDecl(child, attrValues, false, schemaDoc);
                child = DOMUtil.getNextSiblingElement(child);
            } else {
                text = DOMUtil.getSyntheticAnnotation(elmNode);
                if (text != null) {
                    annotation = this.traverseSyntheticAnnotation(elmNode, text, attrValues, false, schemaDoc);
                }
            }
            if (child != null) {
                this.reportSchemaError("s4s-elt-must-match.1", new Object[]{"wildcard", "(annotation?)", DOMUtil.getLocalName(child)}, elmNode);
            }
        } else {
            text = DOMUtil.getSyntheticAnnotation(elmNode);
            if (text != null) {
                annotation = this.traverseSyntheticAnnotation(elmNode, text, attrValues, false, schemaDoc);
            }
        }
        if (annotation != null) {
            annotations = new XSObjectListImpl();
            annotations.addXSObject(annotation);
        } else {
            annotations = XSObjectListImpl.EMPTY_LIST;
        }
        wildcard.fAnnotations = annotations;
        return wildcard;
    }

    private void processExtraAttributes(Element elmNode, Object[] attrValues, XSWildcardDecl wildcard) {
        Vector notQNameAttr;
        String[] notNamespaceTypeAttr = (String[])attrValues[XSAttributeChecker.ATTIDX_NOTNAMESPACE];
        if (notNamespaceTypeAttr != null) {
            XInt namespaceTypeAttr = (XInt)attrValues[XSAttributeChecker.ATTIDX_NAMESPACE];
            if (namespaceTypeAttr != null) {
                this.reportSchemaError("src-wildcard.1", null, elmNode);
            } else {
                wildcard.fType = (short)2;
                wildcard.fNamespaceList = notNamespaceTypeAttr;
                if (notNamespaceTypeAttr.length == 0) {
                    this.reportSchemaError("wc-props-correct.2", null, elmNode);
                }
            }
        }
        if ((notQNameAttr = (Vector)attrValues[XSAttributeChecker.ATTIDX_NOTQNAME]) != null && notQNameAttr.size() > 0) {
            wildcard.fDisallowedNamesList = (QName[])notQNameAttr.get(0);
            wildcard.fDisallowedDefined = (Boolean)notQNameAttr.get(1);
            wildcard.fDisallowedSibling = (Boolean)notQNameAttr.get(2);
            for (int i = 0; i < wildcard.fDisallowedNamesList.length; ++i) {
                QName name = wildcard.fDisallowedNamesList[i];
                if (wildcard.allowNamespace(name.uri)) continue;
                this.reportSchemaError("wc-props-correct.4", new Object[]{name.uri, name.localpart}, elmNode);
            }
        }
    }
}

