/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.rxgrpc.stub;

import io.reactivex.SingleObserver;
import io.reactivex.SingleOperator;
import io.reactivex.disposables.Disposable;
import java.util.concurrent.atomic.AtomicBoolean;

public class SubscribeOnlyOnceSingleOperator<T>
implements SingleOperator<T, T> {
    private AtomicBoolean subscribedOnce = new AtomicBoolean(false);

    public SingleObserver<? super T> apply(final SingleObserver<? super T> observer) {
        return new SingleObserver<T>(){

            public void onSubscribe(Disposable d) {
                if (SubscribeOnlyOnceSingleOperator.this.subscribedOnce.getAndSet(true)) {
                    throw new NullPointerException("You cannot directly subscribe to a gRPC service multiple times concurrently. Use Flowable.share() instead.");
                }
                observer.onSubscribe(d);
            }

            public void onSuccess(T t) {
                observer.onSuccess(t);
            }

            public void onError(Throwable e) {
                observer.onError(e);
            }
        };
    }
}

