/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.jackson;

import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.JsonParser;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.JsonToken;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.util.Date;

public class UnixTimestampDeserializer
extends JsonDeserializer<Date> {
    @Override
    public Date deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken token = parser.getCurrentToken();
        if (token == JsonToken.VALUE_STRING) {
            String str = parser.getText().trim();
            return UnixTimestampDeserializer.toDate(Long.parseLong(str));
        }
        if (token == JsonToken.VALUE_NUMBER_INT) {
            return UnixTimestampDeserializer.toDate(parser.getLongValue());
        }
        throw ctxt.wrongTokenException(parser, JsonToken.VALUE_STRING, "Expected a string or numeric value");
    }

    private static Date toDate(long secondsSinceEpoch) {
        return new Date(secondsSinceEpoch * 1000L);
    }
}

