/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.logging;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import okhttp3.Call;
import okhttp3.Connection;
import okhttp3.EventListener;
import okhttp3.Handshake;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;

public final class LoggingEventListener
extends EventListener {
    private final HttpLoggingInterceptor.Logger logger;
    private long startNs;

    private LoggingEventListener(HttpLoggingInterceptor.Logger logger) {
        this.logger = logger;
    }

    public void callStart(Call call) {
        this.startNs = System.nanoTime();
        this.logWithTime("callStart: " + call.request());
    }

    public void dnsStart(Call call, String domainName) {
        this.logWithTime("dnsStart: " + domainName);
    }

    public void dnsEnd(Call call, String domainName, List<InetAddress> inetAddressList) {
        this.logWithTime("dnsEnd: " + inetAddressList);
    }

    public void connectStart(Call call, InetSocketAddress inetSocketAddress, Proxy proxy) {
        this.logWithTime("connectStart: " + inetSocketAddress + " " + proxy);
    }

    public void secureConnectStart(Call call) {
        this.logWithTime("secureConnectStart");
    }

    public void secureConnectEnd(Call call, @Nullable Handshake handshake) {
        this.logWithTime("secureConnectEnd: " + handshake);
    }

    public void connectEnd(Call call, InetSocketAddress inetSocketAddress, Proxy proxy, @Nullable Protocol protocol) {
        this.logWithTime("connectEnd: " + protocol);
    }

    public void connectFailed(Call call, InetSocketAddress inetSocketAddress, Proxy proxy, @Nullable Protocol protocol, IOException ioe) {
        this.logWithTime("connectFailed: " + protocol + " " + ioe);
    }

    public void connectionAcquired(Call call, Connection connection) {
        this.logWithTime("connectionAcquired: " + connection);
    }

    public void connectionReleased(Call call, Connection connection) {
        this.logWithTime("connectionReleased");
    }

    public void requestHeadersStart(Call call) {
        this.logWithTime("requestHeadersStart");
    }

    public void requestHeadersEnd(Call call, Request request) {
        this.logWithTime("requestHeadersEnd");
    }

    public void requestBodyStart(Call call) {
        this.logWithTime("requestBodyStart");
    }

    public void requestBodyEnd(Call call, long byteCount) {
        this.logWithTime("requestBodyEnd: byteCount=" + byteCount);
    }

    public void requestFailed(Call call, IOException ioe) {
        this.logWithTime("requestFailed: " + ioe);
    }

    public void responseHeadersStart(Call call) {
        this.logWithTime("responseHeadersStart");
    }

    public void responseHeadersEnd(Call call, Response response) {
        this.logWithTime("responseHeadersEnd: " + response);
    }

    public void responseBodyStart(Call call) {
        this.logWithTime("responseBodyStart");
    }

    public void responseBodyEnd(Call call, long byteCount) {
        this.logWithTime("responseBodyEnd: byteCount=" + byteCount);
    }

    public void responseFailed(Call call, IOException ioe) {
        this.logWithTime("responseFailed: " + ioe);
    }

    public void callEnd(Call call) {
        this.logWithTime("callEnd");
    }

    public void callFailed(Call call, IOException ioe) {
        this.logWithTime("callFailed: " + ioe);
    }

    private void logWithTime(String message) {
        long timeMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.startNs);
        this.logger.log("[" + timeMs + " ms] " + message);
    }

    public static class Factory
    implements EventListener.Factory {
        private final HttpLoggingInterceptor.Logger logger;

        public Factory() {
            this(HttpLoggingInterceptor.Logger.DEFAULT);
        }

        public Factory(HttpLoggingInterceptor.Logger logger) {
            this.logger = logger;
        }

        public EventListener create(Call call) {
            return new LoggingEventListener(this.logger);
        }
    }
}

