/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.compiler;

import com.sun.btrace.org.objectweb.asm.AnnotationVisitor;
import com.sun.btrace.org.objectweb.asm.Attribute;
import com.sun.btrace.org.objectweb.asm.ClassAdapter;
import com.sun.btrace.org.objectweb.asm.ClassVisitor;
import com.sun.btrace.org.objectweb.asm.FieldVisitor;
import com.sun.btrace.org.objectweb.asm.Label;
import com.sun.btrace.org.objectweb.asm.MethodAdapter;
import com.sun.btrace.org.objectweb.asm.MethodVisitor;
import com.sun.btrace.org.objectweb.asm.Type;
import com.sun.btrace.util.NullVisitor;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;

public class Postprocessor
extends ClassAdapter {
    private List<FieldDescriptor> fields = new ArrayList<FieldDescriptor>();
    private boolean shortSyntax = false;
    private String className = "";

    public Postprocessor(ClassVisitor cv) {
        super(cv);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if ((access & 1 | access & 4 | access & 2) == 0) {
            this.shortSyntax = true;
            access |= 1;
        }
        this.className = name;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (!this.shortSyntax) {
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
        if ((access & 3) == 0) {
            access &= 0xFFFFFFFB;
            access |= 1;
        }
        int localVarOffset = (access & 8) == 0 ? -1 : 0;
        access |= 8;
        boolean isconstructor = false;
        if ("<init>".equals(name)) {
            name = "<clinit>";
            isconstructor = true;
        }
        MethodConvertor mv = new MethodConvertor(localVarOffset, isconstructor, super.visitMethod(access, name, desc, signature, exceptions));
        return mv;
    }

    @Override
    public FieldVisitor visitField(final int access, final String name, final String desc, final String signature, final Object value) {
        if (!this.shortSyntax) {
            return super.visitField(access, name, desc, signature, value);
        }
        final ArrayList attrs = new ArrayList();
        return new FieldVisitor(){

            @Override
            public AnnotationVisitor visitAnnotation(String string, boolean bln) {
                return new NullVisitor();
            }

            @Override
            public void visitAttribute(Attribute atrbt) {
                attrs.add(atrbt);
            }

            @Override
            public void visitEnd() {
                FieldDescriptor fd = new FieldDescriptor(access, name, desc, signature, value, attrs);
                Postprocessor.this.fields.add(fd);
            }
        };
    }

    @Override
    public void visitEnd() {
        if (this.shortSyntax) {
            this.addFields();
        }
    }

    private void addFields() {
        for (FieldDescriptor fd : this.fields) {
            String fieldName = fd.name;
            int fieldAccess = fd.access;
            String fieldDesc = fd.desc;
            String fieldSignature = fd.signature;
            Object fieldValue = fd.value;
            fieldAccess &= 0xFFFFFFFD;
            fieldAccess &= 0xFFFFFFFB;
            FieldVisitor fv = super.visitField(fieldAccess |= 9, fieldName, fieldDesc, fieldSignature, fieldValue);
            for (Attribute attr : fd.attributes) {
                fv.visitAttribute(attr);
            }
            fv.visitEnd();
        }
    }

    private static class FieldDescriptor {
        int access;
        String name;
        String desc;
        String signature;
        Object value;
        List<Attribute> attributes;
        int var = -1;
        boolean initialized;

        FieldDescriptor(int acc, String n, String d, String sig, Object val, List<Attribute> attrs) {
            this.access = acc;
            this.name = n;
            this.desc = d;
            this.signature = sig;
            this.value = val;
            this.attributes = attrs;
        }
    }

    private class MethodConvertor
    extends MethodAdapter {
        private Deque<Boolean> simulatedStack;
        private int localVarOffset;
        private boolean isConstructor;
        private boolean copyEnabled;

        public MethodConvertor(int localVarOffset, boolean isConstructor, MethodVisitor mv) {
            super(mv);
            this.simulatedStack = new ArrayDeque<Boolean>();
            this.localVarOffset = 0;
            this.copyEnabled = false;
            this.localVarOffset = localVarOffset;
            this.isConstructor = isConstructor;
            this.copyEnabled = !isConstructor;
        }

        @Override
        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            if (index + this.localVarOffset < 0 || !this.copyEnabled) {
                return;
            }
            super.visitLocalVariable(name, desc, signature, start, end, index + this.localVarOffset);
        }

        @Override
        public void visitVarInsn(int opcode, int var) {
            boolean delegate = true;
            switch (opcode) {
                case 25: {
                    delegate = var + this.localVarOffset >= 0;
                    this.simulatedStack.push(!delegate);
                    break;
                }
                case 22: 
                case 24: {
                    this.simulatedStack.push(Boolean.FALSE);
                }
                case 21: 
                case 23: {
                    this.simulatedStack.push(Boolean.FALSE);
                    break;
                }
                case 55: 
                case 57: {
                    this.simulatedStack.poll();
                }
                case 54: 
                case 56: 
                case 58: {
                    this.simulatedStack.poll();
                }
            }
            if (delegate && this.copyEnabled) {
                super.visitVarInsn(opcode, var + this.localVarOffset);
            }
        }

        @Override
        public void visitInsn(int opcode) {
            switch (opcode) {
                case 87: {
                    if (!this.simulatedStack.pop().booleanValue()) break;
                    return;
                }
                case 88: {
                    Boolean[] vals = new Boolean[]{this.simulatedStack.poll(), this.simulatedStack.poll()};
                    if (vals[0].booleanValue() && vals[1].booleanValue()) {
                        return;
                    }
                    if (!vals[0].booleanValue() && !vals[1].booleanValue()) break;
                    opcode = 87;
                    break;
                }
                case 89: {
                    Boolean val = this.simulatedStack.peek();
                    val = val != null ? val : Boolean.FALSE;
                    this.simulatedStack.push(val);
                    if (!val.booleanValue()) break;
                    return;
                }
                case 90: {
                    if (this.simulatedStack.size() < 2) {
                        return;
                    }
                    Boolean[] vals = new Boolean[2];
                    int cntr = vals.length - 1;
                    while (cntr >= 0) {
                        vals[cntr--] = this.simulatedStack.pop();
                    }
                    this.simulatedStack.push(vals[vals.length - 1]);
                    this.simulatedStack.addAll(Arrays.asList(vals));
                    if (vals[1].booleanValue()) {
                        return;
                    }
                    if (!vals[0].booleanValue()) break;
                    opcode = 89;
                    break;
                }
                case 91: {
                    if (this.simulatedStack.size() < 3) {
                        return;
                    }
                    Boolean[] vals = new Boolean[3];
                    int cntr = vals.length - 1;
                    while (cntr >= 0) {
                        vals[cntr--] = this.simulatedStack.pop();
                    }
                    this.simulatedStack.push(vals[vals.length - 1]);
                    this.simulatedStack.addAll(Arrays.asList(vals));
                    if (vals[2].booleanValue()) {
                        return;
                    }
                    if (vals[0].booleanValue() && vals[1].booleanValue()) {
                        opcode = 89;
                        break;
                    }
                    opcode = 90;
                    break;
                }
                case 92: {
                    if (this.simulatedStack.size() < 2) {
                        return;
                    }
                    Boolean[] vals = new Boolean[2];
                    int cntr = vals.length - 1;
                    while (cntr >= 0) {
                        vals[cntr--] = this.simulatedStack.pop();
                    }
                    this.simulatedStack.addAll(Arrays.asList(vals));
                    if (vals[0].booleanValue() && vals[1].booleanValue()) {
                        return;
                    }
                    if (!vals[0].booleanValue() && !vals[1].booleanValue()) break;
                    opcode = 89;
                    break;
                }
                case 93: {
                    if (this.simulatedStack.size() < 3) {
                        return;
                    }
                    Boolean[] vals = new Boolean[3];
                    int cntr = vals.length - 1;
                    while (cntr >= 0) {
                        vals[cntr--] = this.simulatedStack.pop();
                    }
                    this.simulatedStack.push(vals[vals.length - 2]);
                    this.simulatedStack.push(vals[vals.length - 1]);
                    this.simulatedStack.addAll(Arrays.asList(vals));
                    if (vals[1].booleanValue() && vals[2].booleanValue()) {
                        return;
                    }
                    if (vals[0].booleanValue()) {
                        if (vals[1].booleanValue() || vals[2].booleanValue()) {
                            opcode = 89;
                            break;
                        }
                        opcode = 92;
                        break;
                    }
                    if (!vals[1].booleanValue() && !vals[2].booleanValue()) break;
                    opcode = 90;
                    break;
                }
                case 94: {
                    Boolean[] vals = new Boolean[]{Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE};
                    Iterator<Boolean> iter = this.simulatedStack.descendingIterator();
                    int cntr = 0;
                    while (cntr < vals.length && iter.hasNext()) {
                        vals[cntr++] = iter.next();
                    }
                    this.simulatedStack.push(vals[vals.length - 2]);
                    this.simulatedStack.push(vals[vals.length - 1]);
                    this.simulatedStack.addAll(Arrays.asList(vals));
                    break;
                }
                case 95: {
                    if (this.simulatedStack.size() < 2) {
                        return;
                    }
                    Boolean[] vals = new Boolean[2];
                    int cntr = vals.length - 1;
                    while (cntr >= 0) {
                        vals[cntr--] = this.simulatedStack.pop();
                    }
                    if (vals[0].booleanValue() || vals[1].booleanValue()) {
                        return;
                    }
                    this.simulatedStack.push(vals[1]);
                    this.simulatedStack.push(vals[0]);
                }
                case 9: 
                case 10: 
                case 14: 
                case 15: {
                    this.simulatedStack.push(Boolean.FALSE);
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 11: 
                case 12: 
                case 13: 
                case 194: 
                case 195: {
                    this.simulatedStack.push(Boolean.FALSE);
                    break;
                }
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 134: 
                case 138: 
                case 139: 
                case 143: 
                case 145: 
                case 146: 
                case 147: 
                case 190: 
                case 192: {
                    break;
                }
                case 133: 
                case 135: {
                    this.simulatedStack.push(Boolean.FALSE);
                    break;
                }
                case 47: 
                case 49: 
                case 97: 
                case 99: 
                case 101: 
                case 103: 
                case 105: 
                case 107: 
                case 109: 
                case 111: 
                case 113: 
                case 115: 
                case 121: 
                case 123: 
                case 125: 
                case 127: 
                case 129: 
                case 131: {
                    this.simulatedStack.pop();
                    this.simulatedStack.pop();
                    break;
                }
                case 148: 
                case 151: 
                case 152: {
                    this.simulatedStack.pop();
                    this.simulatedStack.pop();
                    this.simulatedStack.pop();
                    break;
                }
                case 46: 
                case 48: 
                case 51: 
                case 52: 
                case 53: 
                case 96: 
                case 98: 
                case 100: 
                case 102: 
                case 104: 
                case 108: 
                case 110: 
                case 112: 
                case 114: 
                case 120: 
                case 122: 
                case 124: 
                case 126: 
                case 128: 
                case 130: 
                case 149: 
                case 150: {
                    this.simulatedStack.poll();
                    break;
                }
                case 80: 
                case 82: {
                    this.simulatedStack.pop();
                }
                case 79: 
                case 81: 
                case 84: 
                case 85: 
                case 86: {
                    this.simulatedStack.pop();
                    this.simulatedStack.pop();
                    this.simulatedStack.pop();
                }
            }
            if (this.copyEnabled) {
                super.visitInsn(opcode);
            }
        }

        @Override
        public void visitIntInsn(int opcode, int index) {
            switch (opcode) {
                case 16: 
                case 17: {
                    this.simulatedStack.push(Boolean.FALSE);
                }
            }
            if (this.copyEnabled) {
                super.visitIntInsn(opcode, index);
            }
        }

        @Override
        public void visitJumpInsn(int opcode, Label label) {
            switch (opcode) {
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 198: 
                case 199: {
                    this.simulatedStack.poll();
                    break;
                }
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: {
                    this.simulatedStack.poll();
                    this.simulatedStack.poll();
                }
            }
            if (this.copyEnabled) {
                super.visitJumpInsn(opcode, label);
            }
        }

        @Override
        public void visitTableSwitchInsn(int i, int i1, Label label, Label[] labels) {
            this.simulatedStack.poll();
            if (this.copyEnabled) {
                super.visitTableSwitchInsn(i, i1, label, labels);
            }
        }

        @Override
        public void visitLookupSwitchInsn(Label label, int[] ints, Label[] labels) {
            this.simulatedStack.poll();
            if (this.copyEnabled) {
                super.visitLookupSwitchInsn(label, ints, labels);
            }
        }

        @Override
        public void visitLdcInsn(Object o) {
            this.simulatedStack.push(Boolean.FALSE);
            if (o instanceof Long || o instanceof Double) {
                this.simulatedStack.push(Boolean.FALSE);
            }
            if (this.copyEnabled) {
                super.visitLdcInsn(o);
            }
        }

        @Override
        public void visitMaxs(int maxStack, int maxLocals) {
            super.visitMaxs(maxStack, maxLocals + this.localVarOffset > 0 ? maxLocals + this.localVarOffset : 0);
        }

        @Override
        public void visitIincInsn(int var, int increment) {
            if (this.copyEnabled) {
                super.visitIincInsn(var + this.localVarOffset, increment);
            }
        }

        @Override
        public void visitFieldInsn(int i, String clazz, String name, String desc) {
            if (i == 180) {
                Boolean opTarget = this.simulatedStack.poll();
                Boolean bl = opTarget = opTarget != null ? opTarget : Boolean.FALSE;
                if (opTarget.booleanValue()) {
                    i = 178;
                }
            } else if (i == 181) {
                this.simulatedStack.pop();
                this.simulatedStack.pop();
                if (desc.equals("J") || desc.equals("D")) {
                    this.simulatedStack.pop();
                }
                if (clazz.equals(Postprocessor.this.className)) {
                    i = 179;
                }
            }
            switch (i) {
                case 178: 
                case 180: {
                    this.simulatedStack.push(Boolean.FALSE);
                    if (!desc.equals("J") && !desc.equals("D")) break;
                    this.simulatedStack.push(Boolean.FALSE);
                }
            }
            if (this.copyEnabled) {
                super.visitFieldInsn(i, clazz, name, desc);
            }
        }

        @Override
        public void visitMethodInsn(int opcode, String clazz, String method, String desc) {
            Boolean targetVal;
            Type[] args;
            int origOpcode = opcode;
            for (Type t : args = Type.getArgumentTypes(desc)) {
                for (int i = 0; i < t.getSize(); ++i) {
                    this.simulatedStack.poll();
                }
            }
            if (opcode != 184 && (targetVal = this.simulatedStack.poll()) != null && targetVal.booleanValue()) {
                opcode = 184;
            }
            if (!Type.getReturnType(desc).equals(Type.VOID_TYPE)) {
                this.simulatedStack.push(Boolean.FALSE);
            }
            if (!this.copyEnabled) {
                if (origOpcode == 183 && this.isConstructor) {
                    this.copyEnabled = true;
                }
            } else {
                super.visitMethodInsn(opcode, clazz, method, desc);
            }
        }

        @Override
        public AnnotationVisitor visitAnnotation(String string, boolean bln) {
            return this.copyEnabled ? super.visitAnnotation(string, bln) : new NullVisitor();
        }

        @Override
        public AnnotationVisitor visitAnnotationDefault() {
            return this.copyEnabled ? super.visitAnnotationDefault() : new NullVisitor();
        }

        @Override
        public void visitAttribute(Attribute atrbt) {
            if (this.copyEnabled) {
                super.visitAttribute(atrbt);
            }
        }

        @Override
        public void visitMultiANewArrayInsn(String string, int i) {
            for (int ind = 0; ind < i; ++ind) {
                this.simulatedStack.pop();
            }
            this.simulatedStack.push(Boolean.FALSE);
            if (this.copyEnabled) {
                super.visitMultiANewArrayInsn(string, i);
            }
        }

        @Override
        public AnnotationVisitor visitParameterAnnotation(int i, String string, boolean bln) {
            return this.copyEnabled ? super.visitParameterAnnotation(i, string, bln) : new NullVisitor();
        }

        @Override
        public void visitTypeInsn(int opcode, String typeName) {
            switch (opcode) {
                case 187: {
                    this.simulatedStack.push(Boolean.FALSE);
                }
            }
            if (this.copyEnabled) {
                super.visitTypeInsn(opcode, typeName);
            }
        }
    }
}

