/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.compiler;

import com.sun.btrace.compiler.VerifierVisitor;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.source.util.Trees;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

@SupportedAnnotationTypes(value={"*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class Verifier
extends AbstractProcessor
implements TaskListener {
    private boolean unsafe;
    private List<String> classNames = new ArrayList<String>();
    private Trees treeUtils;
    private List<CompilationUnitTree> compUnits = new ArrayList<CompilationUnitTree>();
    private ClassTree currentClass;
    private final AttributionTaskListener listener = new AttributionTaskListener();

    public Verifier(boolean unsafe) {
        this.unsafe = unsafe;
    }

    public Verifier() {
        this(false);
    }

    @Override
    public void init(ProcessingEnvironment pe) {
        super.init(pe);
        this.treeUtils = Trees.instance(pe);
        this.prepareContext(((JavacProcessingEnvironment)pe).getContext());
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        return true;
    }

    @Override
    public void started(TaskEvent e) {
    }

    @Override
    public void finished(TaskEvent e) {
        CompilationUnitTree ct = e.getCompilationUnit();
        if (ct != null) {
            this.compUnits.add(ct);
        }
    }

    List<String> getClassNames() {
        return this.classNames;
    }

    CompilationUnitTree getCompilationUnit() {
        for (CompilationUnitTree ct : this.compUnits) {
            for (Tree tree : ct.getTypeDecls()) {
                if (!tree.equals(this.currentClass)) continue;
                return ct;
            }
        }
        return null;
    }

    Trees getTreeUtils() {
        return this.treeUtils;
    }

    SourcePositions getSourcePositions() {
        return this.treeUtils.getSourcePositions();
    }

    ProcessingEnvironment getProcessingEnvironment() {
        return this.processingEnv;
    }

    Messager getMessager() {
        return this.processingEnv.getMessager();
    }

    Elements getElementUtils() {
        return this.processingEnv.getElementUtils();
    }

    Types getTypeUtils() {
        return this.processingEnv.getTypeUtils();
    }

    Locale getLocale() {
        return this.processingEnv.getLocale();
    }

    private boolean verify(ClassTree ct, Element topElement) {
        this.currentClass = ct;
        CompilationUnitTree cut = this.getCompilationUnit();
        String className = ct.getSimpleName().toString();
        ExpressionTree pkgName = cut.getPackageName();
        if (pkgName != null) {
            className = pkgName + "." + className;
        }
        this.classNames.add(className);
        Boolean value = this.unsafe ? Boolean.TRUE : ct.accept(new VerifierVisitor(this, topElement), null);
        return value == null ? true : value;
    }

    private void prepareContext(Context context) {
        TaskListener otherListener = context.get(TaskListener.class);
        if (otherListener == null) {
            context.put(TaskListener.class, this.listener);
        } else {
            context.put(TaskListener.class, (TaskListener)null);
            TaskListeners listeners = new TaskListeners();
            listeners.add(otherListener);
            listeners.add(this.listener);
            context.put(TaskListener.class, listeners);
        }
    }

    private static class TaskListeners
    implements TaskListener {
        private final List<TaskListener> listeners = new ArrayList<TaskListener>();

        private TaskListeners() {
        }

        public void add(TaskListener listener) {
            this.listeners.add(listener);
        }

        public void remove(TaskListener listener) {
            this.listeners.remove(listener);
        }

        @Override
        public void finished(TaskEvent e) {
            for (TaskListener listener : this.listeners) {
                listener.finished(e);
            }
        }

        @Override
        public void started(TaskEvent e) {
            for (TaskListener listener : this.listeners) {
                listener.started(e);
            }
        }
    }

    private final class AttributionTaskListener
    implements TaskListener {
        private AttributionTaskListener() {
        }

        @Override
        public void finished(TaskEvent e) {
            if (e.getKind() != TaskEvent.Kind.ANALYZE) {
                return;
            }
            TypeElement elem = e.getTypeElement();
            for (Tree tree : e.getCompilationUnit().getTypeDecls()) {
                if (tree.getKind() != Tree.Kind.CLASS || !((JCTree.JCClassDecl)tree).sym.equals(elem)) continue;
                Verifier.this.currentClass = (ClassTree)tree;
                break;
            }
            if (Verifier.this.currentClass != null) {
                Verifier.this.verify(Verifier.this.currentClass, elem);
            }
        }

        @Override
        public void started(TaskEvent e) {
        }
    }
}

