/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.spi.impl;

import com.sun.btrace.api.BTraceCompiler;
import com.sun.btrace.api.BTraceTask;
import com.sun.btrace.compiler.Compiler;
import com.sun.btrace.spi.BTraceCompilerFactory;
import java.io.File;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class BTraceCompilerFactoryImpl
implements BTraceCompilerFactory {
    private static final Logger LOGGER = Logger.getLogger(BTraceCompilerFactory.class.getName());
    private static final Pattern classNamePattern = Pattern.compile("@BTrace\\s*.+?\\s*class\\s*(.*?)\\s+\\{", 41);

    @Override
    public BTraceCompiler newCompiler(final BTraceTask task) {
        return new BTraceCompiler(){
            private final Compiler c;
            private final Object toolsJarLock;
            private String toolsJar;
            private final Object jarBaseDirLock;
            private String jarBaseDir;
            {
                this.c = new Compiler(null, task.isUnsafe());
                this.toolsJarLock = new Object();
                this.toolsJar = null;
                this.jarBaseDirLock = new Object();
                this.jarBaseDir = null;
            }

            @Override
            public byte[] compile(String source, String classPath, Writer errorWriter) {
                try {
                    Matcher matcher = classNamePattern.matcher(source);
                    if (matcher.find()) {
                        String completeCP;
                        String fileName;
                        Map<String, byte[]> compilationMap;
                        if (errorWriter == null) {
                            errorWriter = new PrintWriter(System.out);
                        }
                        if ((compilationMap = this.c.compile(fileName = matcher.group(1) + ".java", source, errorWriter, ".", completeCP = this.getToolsJarPath() + File.pathSeparator + this.getClientJarPath() + File.pathSeparator + classPath)) != null) {
                            return compilationMap.values().iterator().next();
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, null, e);
                }
                return new byte[0];
            }

            @Override
            public String getAgentJarPath() {
                return this.getJarBaseDir() + File.separatorChar + "btrace-agent.jar";
            }

            @Override
            public String getClientJarPath() {
                return this.getJarBaseDir() + File.separatorChar + "btrace-client.jar";
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getToolsJarPath() {
                Object object = this.toolsJarLock;
                synchronized (object) {
                    File toolsJarFile;
                    if (this.toolsJar == null && (toolsJarFile = this.getContainingJar("com/sun/tools/javac/Main.class")) != null) {
                        this.toolsJar = toolsJarFile.getAbsolutePath();
                    }
                    return this.toolsJar;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private String getJarBaseDir() {
                Object object = this.jarBaseDirLock;
                synchronized (object) {
                    if (this.jarBaseDir == null) {
                        File f;
                        for (f = this.getContainingJar("com/sun/btrace/BTraceRuntime.class"); !(f == null || f.exists() && f.isDirectory()); f = f.getParentFile()) {
                        }
                        if (f != null) {
                            this.jarBaseDir = f.getAbsolutePath();
                        }
                    }
                    return this.jarBaseDir;
                }
            }

            private File getContainingJar(String clz) {
                File jarFile;
                String path;
                int index;
                URL url = this.getClass().getClassLoader().getResource(clz);
                if ("jar".equals(url.getProtocol()) && (index = (path = url.getPath()).indexOf("!/")) >= 0) {
                    try {
                        String jarPath = path.substring(0, index);
                        if (jarPath.indexOf("file://") > -1 && jarPath.indexOf("file:////") == -1) {
                            jarPath = jarPath.replaceFirst("file://", "file:////");
                        }
                        url = new URL(jarPath);
                    }
                    catch (MalformedURLException mue) {
                        throw new RuntimeException(mue);
                    }
                }
                try {
                    jarFile = new File(url.toURI());
                }
                catch (URISyntaxException ex) {
                    throw new RuntimeException(ex);
                }
                assert (jarFile.exists());
                return jarFile;
            }
        };
    }
}

