/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.spi.impl;

import com.sun.btrace.api.BTraceTask;
import com.sun.btrace.spi.PortLocator;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PortLocatorImpl
implements PortLocator {
    private static final Logger LOGGER = Logger.getLogger(PortLocator.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTaskPort(BTraceTask task) {
        VirtualMachine vm = null;
        try {
            vm = VirtualMachine.attach(String.valueOf(task.getPid()));
            String portStr = vm.getSystemProperties().getProperty("btrace.port");
            int n = portStr != null ? Integer.parseInt(portStr) : PortLocatorImpl.findFreePort();
            return n;
        }
        catch (AttachNotSupportedException ex) {
            Logger.getLogger(PortLocatorImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(PortLocatorImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            if (vm != null) {
                try {
                    vm.detach();
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, null, e);
                }
            }
        }
        return PortLocatorImpl.findFreePort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int findFreePort() {
        ServerSocket server = null;
        int port = 0;
        try {
            server = new ServerSocket(0);
            port = server.getLocalPort();
        }
        catch (IOException e) {
            port = 2020;
        }
        finally {
            try {
                server.close();
            }
            catch (Exception exception) {}
        }
        return port;
    }
}

