/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.util;

import com.sun.btrace.org.objectweb.asm.Label;
import com.sun.btrace.org.objectweb.asm.MethodAdapter;
import com.sun.btrace.org.objectweb.asm.MethodVisitor;
import com.sun.btrace.org.objectweb.asm.Type;
import com.sun.btrace.runtime.MethodReturnInstrumentor;
import com.sun.btrace.util.LocalVariablesSorter;
import com.sun.btrace.util.TimeStampHelper;

public class TimeStampGenerator
extends MethodAdapter {
    public static final String TIME_STAMP_NAME = "$btrace$time$stamp";
    private static final String CONSTRUCTOR = "<init>";
    private int[] ts_index;
    private int[] exitOpcodes;
    private int capturingIndex = -1;
    private boolean capturing = false;
    private boolean generatingIndex = false;
    private boolean entryCalled = false;
    private String methodName;
    private String className;
    private String superName;
    private final LocalVariablesSorter lvs;

    public TimeStampGenerator(LocalVariablesSorter lvs, int[] tsindex, String className, String superName, int access, String name, String desc, MethodVisitor mv, int[] exitOpcodes) {
        super(mv);
        this.lvs = lvs;
        this.methodName = name;
        this.className = className;
        this.superName = superName;
        this.ts_index = tsindex;
        this.exitOpcodes = new int[exitOpcodes.length];
        System.arraycopy(exitOpcodes, 0, this.exitOpcodes, 0, exitOpcodes.length);
    }

    @Override
    public void visitCode() {
        this.ts_index[0] = -1;
        this.ts_index[1] = -1;
        this.capturing = false;
        this.capturingIndex = -1;
        this.entryCalled = false;
        super.visitCode();
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.check();
        super.visitFieldInsn(opcode, owner, name, desc);
    }

    @Override
    public void visitIincInsn(int var, int increment) {
        this.check();
        super.visitIincInsn(var, increment);
    }

    @Override
    public void visitInsn(int opcode) {
        this.check();
        if (this.ts_index[1] == -1) {
            for (int exitOpcode : this.exitOpcodes) {
                if (exitOpcode != opcode) continue;
                if (this.ts_index[0] == -1 || this.ts_index[1] != -1) break;
                this.generateTS(1);
                break;
            }
        }
        super.visitInsn(opcode);
        if (this.ts_index[1] != -1) {
            switch (opcode) {
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 191: {
                    this.ts_index[1] = -1;
                }
            }
        }
    }

    @Override
    public void visitIntInsn(int opcode, int var) {
        this.check();
        super.visitIntInsn(opcode, var);
    }

    @Override
    public void visitJumpInsn(int opcode, Label label) {
        this.check();
        super.visitJumpInsn(opcode, label);
    }

    @Override
    public void visitLabel(Label label) {
        this.check();
        super.visitLabel(label);
    }

    @Override
    public void visitLdcInsn(Object cst) {
        this.check();
        super.visitLdcInsn(cst);
    }

    @Override
    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.check();
        super.visitLookupSwitchInsn(dflt, keys, labels);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        if (this.generatingIndex) {
            super.visitMethodInsn(opcode, owner, name, desc);
            return;
        }
        if (!this.capturing && name.equals(TIME_STAMP_NAME) && desc.equals("()J")) {
            this.capturing = true;
            ++this.capturingIndex;
        }
        this.check();
        super.visitMethodInsn(opcode, owner, name, desc);
        if (!this.entryCalled && CONSTRUCTOR.equals(name) && (owner.equals(this.className) || this.superName != null && owner.equals(this.superName))) {
            this.entryCalled = true;
            if (this.capturingIndex == -1) {
                this.check();
            }
        }
    }

    @Override
    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.check();
        super.visitMultiANewArrayInsn(desc, dims);
    }

    @Override
    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        this.check();
        super.visitTableSwitchInsn(min, max, dflt, labels);
    }

    @Override
    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        this.check();
        super.visitTryCatchBlock(start, end, handler, type);
    }

    @Override
    public void visitTypeInsn(int opcode, String type) {
        this.check();
        super.visitTypeInsn(opcode, type);
    }

    @Override
    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        this.check();
        super.visitLocalVariable(name, desc, signature, start, end, index);
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        if (opcode == 55 && !this.generatingIndex) {
            if (this.capturing) {
                this.ts_index[this.capturingIndex] = var;
            }
            this.capturing = false;
        }
        super.visitVarInsn(opcode, var);
    }

    private void check() {
        if (!this.entryCalled && CONSTRUCTOR.equals(this.methodName)) {
            return;
        }
        this.capturing = false;
        this.generateTS(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateTS(int index) {
        if (this.mv instanceof MethodReturnInstrumentor && !((MethodReturnInstrumentor)this.mv).usesTimeStamp()) {
            return;
        }
        if (this.ts_index[index] > -1) {
            return;
        }
        try {
            this.generatingIndex = true;
            TimeStampHelper.generateTimeStampAccess(this, this.className);
            this.ts_index[index] = this.lvs.newLocal(Type.LONG_TYPE);
        }
        finally {
            this.generatingIndex = false;
        }
    }
}

