/*
 * Marketing API
 * Marketing API
 *
 * OpenAPI spec version: 1.3
 *
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package com.tencent.ads.api;

import com.google.gson.reflect.TypeToken;
import com.tencent.ads.ApiCallback;
import com.tencent.ads.ApiClient;
import com.tencent.ads.ApiException;
import com.tencent.ads.ApiResponse;
import com.tencent.ads.Configuration;
import com.tencent.ads.Pair;
import com.tencent.ads.ProgressRequestBody;
import com.tencent.ads.ProgressResponseBody;
import com.tencent.ads.model.DiagnosisGetResponse;
import com.tencent.ads.model.TimeRange;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DiagnosisApi {
  private ApiClient apiClient;

  public DiagnosisApi() {
    this(Configuration.getDefaultApiClient());
  }

  public DiagnosisApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Build call for diagnosisGet
   *
   * @param accountId (required)
   * @param adgroupIdList (required)
   * @param timeRange (optional)
   * @param fields 返回参数的字段列表 (optional)
   * @param progressListener Progress listener
   * @param progressRequestListener Progress request listener
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   */
  public com.squareup.okhttp.Call diagnosisGetCall(
      Long accountId,
      List<Long> adgroupIdList,
      TimeRange timeRange,
      List<String> fields,
      final ProgressResponseBody.ProgressListener progressListener,
      final ProgressRequestBody.ProgressRequestListener progressRequestListener)
      throws ApiException {
    Object localVarPostBody = null;

    // create path and map variables
    String localVarPath = "/diagnosis/get";

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    if (accountId != null)
      localVarQueryParams.addAll(apiClient.parameterToPair("account_id", accountId));
    if (adgroupIdList != null)
      localVarCollectionQueryParams.addAll(
          apiClient.parameterToPairs("multi", "adgroup_id_list", adgroupIdList));
    if (timeRange != null)
      localVarQueryParams.addAll(apiClient.parameterToPair("time_range", timeRange));
    if (fields != null)
      localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("multi", "fields", fields));

    Map<String, String> localVarHeaderParams = new HashMap<String, String>();

    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

    final String[] localVarContentTypes = {"text/plain"};
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
    localVarHeaderParams.put("Content-Type", localVarContentType);

    if (progressListener != null) {
      apiClient
          .getHttpClient()
          .networkInterceptors()
          .add(
              new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(
                    com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                  com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                  return originalResponse
                      .newBuilder()
                      .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                      .build();
                }
              });
    }

    String[] localVarAuthNames = new String[] {"accessToken", "nonce", "timestamp"};
    return apiClient.buildCall(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarFormParams,
        localVarAuthNames,
        progressRequestListener);
  }

  @SuppressWarnings("rawtypes")
  private com.squareup.okhttp.Call diagnosisGetValidateBeforeCall(
      Long accountId,
      List<Long> adgroupIdList,
      TimeRange timeRange,
      List<String> fields,
      final ProgressResponseBody.ProgressListener progressListener,
      final ProgressRequestBody.ProgressRequestListener progressRequestListener)
      throws ApiException {

    // verify the required parameter 'accountId' is set
    if (accountId == null) {
      throw new ApiException(
          "Missing the required parameter 'accountId' when calling diagnosisGet(Async)");
    }

    // verify the required parameter 'adgroupIdList' is set
    if (adgroupIdList == null) {
      throw new ApiException(
          "Missing the required parameter 'adgroupIdList' when calling diagnosisGet(Async)");
    }

    com.squareup.okhttp.Call call =
        diagnosisGetCall(
            accountId, adgroupIdList, timeRange, fields, progressListener, progressRequestListener);
    return call;
  }

  /**
   * 广告诊断分析工具
   *
   * @param accountId (required)
   * @param adgroupIdList (required)
   * @param timeRange (optional)
   * @param fields 返回参数的字段列表 (optional)
   * @return DiagnosisGetResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   */
  public DiagnosisGetResponse diagnosisGet(
      Long accountId, List<Long> adgroupIdList, TimeRange timeRange, List<String> fields)
      throws ApiException {
    ApiResponse<DiagnosisGetResponse> resp =
        diagnosisGetWithHttpInfo(accountId, adgroupIdList, timeRange, fields);
    return resp.getData();
  }

  /**
   * 广告诊断分析工具
   *
   * @param accountId (required)
   * @param adgroupIdList (required)
   * @param timeRange (optional)
   * @param fields 返回参数的字段列表 (optional)
   * @return ApiResponse&lt;DiagnosisGetResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   */
  public ApiResponse<DiagnosisGetResponse> diagnosisGetWithHttpInfo(
      Long accountId, List<Long> adgroupIdList, TimeRange timeRange, List<String> fields)
      throws ApiException {
    com.squareup.okhttp.Call call =
        diagnosisGetValidateBeforeCall(accountId, adgroupIdList, timeRange, fields, null, null);
    Type localVarReturnType = new TypeToken<DiagnosisGetResponse>() {}.getType();
    return apiClient.execute(call, localVarReturnType);
  }

  /**
   * 广告诊断分析工具 (asynchronously)
   *
   * @param accountId (required)
   * @param adgroupIdList (required)
   * @param timeRange (optional)
   * @param fields 返回参数的字段列表 (optional)
   * @param callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   */
  public com.squareup.okhttp.Call diagnosisGetAsync(
      Long accountId,
      List<Long> adgroupIdList,
      TimeRange timeRange,
      List<String> fields,
      final ApiCallback<DiagnosisGetResponse> callback)
      throws ApiException {

    ProgressResponseBody.ProgressListener progressListener = null;
    ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

    if (callback != null) {
      progressListener =
          new ProgressResponseBody.ProgressListener() {
            @Override
            public void update(long bytesRead, long contentLength, boolean done) {
              callback.onDownloadProgress(bytesRead, contentLength, done);
            }
          };

      progressRequestListener =
          new ProgressRequestBody.ProgressRequestListener() {
            @Override
            public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
              callback.onUploadProgress(bytesWritten, contentLength, done);
            }
          };
    }

    com.squareup.okhttp.Call call =
        diagnosisGetValidateBeforeCall(
            accountId, adgroupIdList, timeRange, fields, progressListener, progressRequestListener);
    Type localVarReturnType = new TypeToken<DiagnosisGetResponse>() {}.getType();
    apiClient.executeAsync(call, localVarReturnType, callback);
    return call;
  }
}
