/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.tencent.ads.ApiCallback;
import com.tencent.ads.ApiClient;
import com.tencent.ads.ApiException;
import com.tencent.ads.ApiResponse;
import com.tencent.ads.Configuration;
import com.tencent.ads.Pair;
import com.tencent.ads.ProgressRequestBody;
import com.tencent.ads.ProgressResponseBody;
import com.tencent.ads.model.OauthTokenResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class OauthApi {
    private ApiClient apiClient;

    public OauthApi() {
        this(Configuration.getDefaultApiClient());
    }

    public OauthApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call oauthAuthorizeCall(Long clientId, String redirectUri, String state, String scope, String accountType, Long accountDisplayNumber, List<String> fields, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/oauth/authorize";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (clientId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("client_id", clientId));
        }
        if (redirectUri != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("redirect_uri", redirectUri));
        }
        if (state != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("state", state));
        }
        if (scope != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("scope", scope));
        }
        if (accountType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("account_type", accountType));
        }
        if (accountDisplayNumber != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("account_display_number", accountDisplayNumber));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "fields", fields));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call oauthAuthorizeValidateBeforeCall(Long clientId, String redirectUri, String state, String scope, String accountType, Long accountDisplayNumber, List<String> fields, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clientId == null) {
            throw new ApiException("Missing the required parameter 'clientId' when calling oauthAuthorize(Async)");
        }
        if (redirectUri == null) {
            throw new ApiException("Missing the required parameter 'redirectUri' when calling oauthAuthorize(Async)");
        }
        Call call = this.oauthAuthorizeCall(clientId, redirectUri, state, scope, accountType, accountDisplayNumber, fields, progressListener, progressRequestListener);
        return call;
    }

    public String oauthAuthorize(Long clientId, String redirectUri, String state, String scope, String accountType, Long accountDisplayNumber, List<String> fields) throws ApiException {
        ApiResponse<String> resp = this.oauthAuthorizeWithHttpInfo(clientId, redirectUri, state, scope, accountType, accountDisplayNumber, fields);
        return resp.getData();
    }

    public ApiResponse<String> oauthAuthorizeWithHttpInfo(Long clientId, String redirectUri, String state, String scope, String accountType, Long accountDisplayNumber, List<String> fields) throws ApiException {
        Call call = this.oauthAuthorizeValidateBeforeCall(clientId, redirectUri, state, scope, accountType, accountDisplayNumber, fields, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call oauthAuthorizeAsync(Long clientId, String redirectUri, String state, String scope, String accountType, Long accountDisplayNumber, List<String> fields, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.oauthAuthorizeValidateBeforeCall(clientId, redirectUri, state, scope, accountType, accountDisplayNumber, fields, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call oauthTokenCall(Long clientId, String clientSecret, String grantType, String authorizationCode, String refreshToken, String redirectUri, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/oauth/token";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (clientId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("client_id", clientId));
        }
        if (clientSecret != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("client_secret", clientSecret));
        }
        if (grantType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("grant_type", grantType));
        }
        if (authorizationCode != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("authorization_code", authorizationCode));
        }
        if (refreshToken != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("refresh_token", refreshToken));
        }
        if (redirectUri != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("redirect_uri", redirectUri));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call oauthTokenValidateBeforeCall(Long clientId, String clientSecret, String grantType, String authorizationCode, String refreshToken, String redirectUri, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clientId == null) {
            throw new ApiException("Missing the required parameter 'clientId' when calling oauthToken(Async)");
        }
        if (clientSecret == null) {
            throw new ApiException("Missing the required parameter 'clientSecret' when calling oauthToken(Async)");
        }
        if (grantType == null) {
            throw new ApiException("Missing the required parameter 'grantType' when calling oauthToken(Async)");
        }
        Call call = this.oauthTokenCall(clientId, clientSecret, grantType, authorizationCode, refreshToken, redirectUri, progressListener, progressRequestListener);
        return call;
    }

    public OauthTokenResponse oauthToken(Long clientId, String clientSecret, String grantType, String authorizationCode, String refreshToken, String redirectUri) throws ApiException {
        ApiResponse<OauthTokenResponse> resp = this.oauthTokenWithHttpInfo(clientId, clientSecret, grantType, authorizationCode, refreshToken, redirectUri);
        return resp.getData();
    }

    public ApiResponse<OauthTokenResponse> oauthTokenWithHttpInfo(Long clientId, String clientSecret, String grantType, String authorizationCode, String refreshToken, String redirectUri) throws ApiException {
        Call call = this.oauthTokenValidateBeforeCall(clientId, clientSecret, grantType, authorizationCode, refreshToken, redirectUri, null, null);
        Type localVarReturnType = new TypeToken<OauthTokenResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call oauthTokenAsync(Long clientId, String clientSecret, String grantType, String authorizationCode, String refreshToken, String redirectUri, final ApiCallback<OauthTokenResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.oauthTokenValidateBeforeCall(clientId, clientSecret, grantType, authorizationCode, refreshToken, redirectUri, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OauthTokenResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

