/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.tencent.ads.ApiCallback;
import com.tencent.ads.ApiClient;
import com.tencent.ads.ApiException;
import com.tencent.ads.ApiResponse;
import com.tencent.ads.Configuration;
import com.tencent.ads.Pair;
import com.tencent.ads.ProgressRequestBody;
import com.tencent.ads.ProgressResponseBody;
import com.tencent.ads.model.XijingComplexTemplateGetResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class XijingComplexTemplateApi {
    private ApiClient apiClient;

    public XijingComplexTemplateApi() {
        this(Configuration.getDefaultApiClient());
    }

    public XijingComplexTemplateApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call xijingComplexTemplateGetCall(Long accountId, String pageTemplateId, List<String> fields, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/xijing_complex_template/get";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (accountId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("account_id", accountId));
        }
        if (pageTemplateId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page_template_id", pageTemplateId));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "fields", fields));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call xijingComplexTemplateGetValidateBeforeCall(Long accountId, String pageTemplateId, List<String> fields, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling xijingComplexTemplateGet(Async)");
        }
        if (pageTemplateId == null) {
            throw new ApiException("Missing the required parameter 'pageTemplateId' when calling xijingComplexTemplateGet(Async)");
        }
        Call call = this.xijingComplexTemplateGetCall(accountId, pageTemplateId, fields, progressListener, progressRequestListener);
        return call;
    }

    public XijingComplexTemplateGetResponse xijingComplexTemplateGet(Long accountId, String pageTemplateId, List<String> fields) throws ApiException {
        ApiResponse<XijingComplexTemplateGetResponse> resp = this.xijingComplexTemplateGetWithHttpInfo(accountId, pageTemplateId, fields);
        return resp.getData();
    }

    public ApiResponse<XijingComplexTemplateGetResponse> xijingComplexTemplateGetWithHttpInfo(Long accountId, String pageTemplateId, List<String> fields) throws ApiException {
        Call call = this.xijingComplexTemplateGetValidateBeforeCall(accountId, pageTemplateId, fields, null, null);
        Type localVarReturnType = new TypeToken<XijingComplexTemplateGetResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call xijingComplexTemplateGetAsync(Long accountId, String pageTemplateId, List<String> fields, final ApiCallback<XijingComplexTemplateGetResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.xijingComplexTemplateGetValidateBeforeCall(accountId, pageTemplateId, fields, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<XijingComplexTemplateGetResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

