/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.tencent.ads.ApiCallback;
import com.tencent.ads.ApiClient;
import com.tencent.ads.ApiException;
import com.tencent.ads.ApiResponse;
import com.tencent.ads.Configuration;
import com.tencent.ads.Pair;
import com.tencent.ads.ProgressRequestBody;
import com.tencent.ads.ProgressResponseBody;
import com.tencent.ads.model.XijingPageInteractiveAddResponse;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class XijingPageInteractiveApi {
    private ApiClient apiClient;

    public XijingPageInteractiveApi() {
        this(Configuration.getDefaultApiClient());
    }

    public XijingPageInteractiveApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call xijingPageInteractiveAddCall(Long accountId, Long isAutoSubmit, String pageType, String interactivePageType, String pageTitle, String pageName, String mobileAppId, File file, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/xijing_page_interactive/add";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (accountId != null) {
            localVarFormParams.put("account_id", accountId);
        }
        if (isAutoSubmit != null) {
            localVarFormParams.put("is_auto_submit", isAutoSubmit);
        }
        if (pageType != null) {
            localVarFormParams.put("page_type", pageType);
        }
        if (interactivePageType != null) {
            localVarFormParams.put("interactive_page_type", interactivePageType);
        }
        if (pageTitle != null) {
            localVarFormParams.put("page_title", pageTitle);
        }
        if (pageName != null) {
            localVarFormParams.put("page_name", pageName);
        }
        if (mobileAppId != null) {
            localVarFormParams.put("mobile_app_id", mobileAppId);
        }
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call xijingPageInteractiveAddValidateBeforeCall(Long accountId, Long isAutoSubmit, String pageType, String interactivePageType, String pageTitle, String pageName, String mobileAppId, File file, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling xijingPageInteractiveAdd(Async)");
        }
        if (isAutoSubmit == null) {
            throw new ApiException("Missing the required parameter 'isAutoSubmit' when calling xijingPageInteractiveAdd(Async)");
        }
        if (pageType == null) {
            throw new ApiException("Missing the required parameter 'pageType' when calling xijingPageInteractiveAdd(Async)");
        }
        if (interactivePageType == null) {
            throw new ApiException("Missing the required parameter 'interactivePageType' when calling xijingPageInteractiveAdd(Async)");
        }
        if (pageTitle == null) {
            throw new ApiException("Missing the required parameter 'pageTitle' when calling xijingPageInteractiveAdd(Async)");
        }
        if (pageName == null) {
            throw new ApiException("Missing the required parameter 'pageName' when calling xijingPageInteractiveAdd(Async)");
        }
        if (mobileAppId == null) {
            throw new ApiException("Missing the required parameter 'mobileAppId' when calling xijingPageInteractiveAdd(Async)");
        }
        Call call = this.xijingPageInteractiveAddCall(accountId, isAutoSubmit, pageType, interactivePageType, pageTitle, pageName, mobileAppId, file, progressListener, progressRequestListener);
        return call;
    }

    public XijingPageInteractiveAddResponse xijingPageInteractiveAdd(Long accountId, Long isAutoSubmit, String pageType, String interactivePageType, String pageTitle, String pageName, String mobileAppId, File file) throws ApiException {
        ApiResponse<XijingPageInteractiveAddResponse> resp = this.xijingPageInteractiveAddWithHttpInfo(accountId, isAutoSubmit, pageType, interactivePageType, pageTitle, pageName, mobileAppId, file);
        return resp.getData();
    }

    public ApiResponse<XijingPageInteractiveAddResponse> xijingPageInteractiveAddWithHttpInfo(Long accountId, Long isAutoSubmit, String pageType, String interactivePageType, String pageTitle, String pageName, String mobileAppId, File file) throws ApiException {
        Call call = this.xijingPageInteractiveAddValidateBeforeCall(accountId, isAutoSubmit, pageType, interactivePageType, pageTitle, pageName, mobileAppId, file, null, null);
        Type localVarReturnType = new TypeToken<XijingPageInteractiveAddResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call xijingPageInteractiveAddAsync(Long accountId, Long isAutoSubmit, String pageType, String interactivePageType, String pageTitle, String pageName, String mobileAppId, File file, final ApiCallback<XijingPageInteractiveAddResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.xijingPageInteractiveAddValidateBeforeCall(accountId, isAutoSubmit, pageType, interactivePageType, pageTitle, pageName, mobileAppId, file, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<XijingPageInteractiveAddResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

