/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.examples.BasicOperations.AudiencesManagement;

import com.tencent.ads.ApiContextConfig;
import com.tencent.ads.TencentAds;
import com.tencent.ads.exception.TencentAdsResponseException;
import com.tencent.ads.exception.TencentAdsSDKException;
import com.tencent.ads.model.CombineSpec;
import com.tencent.ads.model.CustomAudienceEstimationsGetRequest;
import com.tencent.ads.model.CustomAudienceEstimationsGetResponseData;
import com.tencent.ads.model.EstimationAudienceSpec;
import com.tencent.ads.model.IncludeSimpleRule;
import com.tencent.ads.model.SimpleRule;
import java.util.ArrayList;

public class GetCustomAudienceEstimations {
    public String ACCESS_TOKEN = "YOUR ACCESS TOKEN";
    public TencentAds tencentAds;
    public Long accountId = null;
    public CustomAudienceEstimationsGetRequest data = new CustomAudienceEstimationsGetRequest();
    public Long audienceId = null;
    public String type = "COMBINE";

    public void init() {
        this.tencentAds = TencentAds.getInstance();
        this.tencentAds.init(new ApiContextConfig().accessToken(this.ACCESS_TOKEN).isDebug(true));
        this.tencentAds.useSandbox();
        this.buildParams();
    }

    public void buildParams() {
        this.data.setAccountId(this.accountId);
        SimpleRule simpleRule = new SimpleRule();
        simpleRule.setAudienceId(this.audienceId);
        IncludeSimpleRule includeSimpleRule = new IncludeSimpleRule();
        includeSimpleRule.add(simpleRule);
        ArrayList<IncludeSimpleRule> include = new ArrayList<IncludeSimpleRule>();
        include.add(includeSimpleRule);
        CombineSpec combineSpec = new CombineSpec();
        combineSpec.setInclude(include);
        EstimationAudienceSpec audienceSpec = new EstimationAudienceSpec();
        audienceSpec.setCombineSpec(combineSpec);
        this.data.setAudienceSpec(audienceSpec);
        this.data.setType(this.type);
    }

    public CustomAudienceEstimationsGetResponseData getCustomAudienceEstimations() throws Exception {
        CustomAudienceEstimationsGetResponseData response = this.tencentAds.customAudienceEstimations().customAudienceEstimationsGet(this.data);
        return response;
    }

    public static void main(String[] args) {
        try {
            GetCustomAudienceEstimations getCustomAudienceEstimations = new GetCustomAudienceEstimations();
            getCustomAudienceEstimations.init();
            CustomAudienceEstimationsGetResponseData customAudienceEstimationsGetResponseData = getCustomAudienceEstimations.getCustomAudienceEstimations();
        }
        catch (TencentAdsResponseException e) {
            e.printStackTrace();
        }
        catch (TencentAdsSDKException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

