/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.examples.BasicOperations.Insights;

import com.tencent.ads.ApiContextConfig;
import com.tencent.ads.TencentAds;
import com.tencent.ads.exception.TencentAdsResponseException;
import com.tencent.ads.exception.TencentAdsSDKException;
import com.tencent.ads.model.DailyReportsGetResponseData;
import com.tencent.ads.model.FilteringStruct;
import com.tencent.ads.model.OrderByStruct;
import com.tencent.ads.model.ReportDateRange;
import java.util.Arrays;
import java.util.List;

public class GetDailyReports {
    public String ACCESS_TOKEN = "YOUR ACCESS TOKEN";
    public TencentAds tencentAds;
    public Long accountId = null;
    public String level = "REPORT_LEVEL_ADGROUP";
    public ReportDateRange dateRange = new ReportDateRange();
    public List<FilteringStruct> filtering = null;
    public List<String> groupBy = null;
    public List<OrderByStruct> orderBy = null;
    public Long page = null;
    public Long pageSize = null;
    public String timeLine = null;
    public List<String> fields = Arrays.asList("date", "view_count", "valid_click_count", "ctr", "cpc", "cost");
    public Boolean weixinOfficialAccountsUpgradeEnabled = null;

    public void init() {
        this.tencentAds = TencentAds.getInstance();
        this.tencentAds.init(new ApiContextConfig().accessToken(this.ACCESS_TOKEN).isDebug(true));
        this.tencentAds.useSandbox();
        this.buildParams();
    }

    public void buildParams() {
        String startDate = "REPORT START DATE";
        this.dateRange.setStartDate(startDate);
        String endDate = "REPORT END DATE";
        this.dateRange.setEndDate(endDate);
    }

    public DailyReportsGetResponseData getDailyReports() throws Exception {
        DailyReportsGetResponseData response = this.tencentAds.dailyReports().dailyReportsGet(this.accountId, this.level, this.dateRange, this.filtering, this.groupBy, this.orderBy, this.page, this.pageSize, this.timeLine, this.fields, this.weixinOfficialAccountsUpgradeEnabled);
        return response;
    }

    public static void main(String[] args) {
        try {
            GetDailyReports getDailyReports = new GetDailyReports();
            getDailyReports.init();
            DailyReportsGetResponseData dailyReportsGetResponseData = getDailyReports.getDailyReports();
        }
        catch (TencentAdsResponseException e) {
            e.printStackTrace();
        }
        catch (TencentAdsSDKException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

