/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.android.dx.instruction;

import com.tencent.tinker.android.dex.DexException;
import com.tencent.tinker.android.dx.instruction.InstructionCodec;
import com.tencent.tinker.android.dx.instruction.InstructionVisitor;
import com.tencent.tinker.android.dx.instruction.Opcodes;
import com.tencent.tinker.android.dx.instruction.ShortArrayCodeInput;
import com.tencent.tinker.android.dx.util.Hex;
import java.io.EOFException;

public final class InstructionReader {
    private final ShortArrayCodeInput codeIn;

    public InstructionReader(ShortArrayCodeInput in) {
        this.codeIn = in;
    }

    public void accept(InstructionVisitor iv) throws EOFException {
        this.codeIn.reset();
        block47: while (this.codeIn.hasMore()) {
            int currentAddress = this.codeIn.cursor();
            int opcodeUnit = this.codeIn.read();
            int opcodeForSwitch = Opcodes.extractOpcodeFromUnit(opcodeUnit);
            switch (opcodeForSwitch) {
                case -1: {
                    iv.visitZeroRegisterInsn(currentAddress, opcodeUnit, 0, 1, 0, 0L);
                    continue block47;
                }
                case 40: {
                    int opcode = InstructionCodec.byte0(opcodeUnit);
                    byte target = (byte)InstructionCodec.byte1(opcodeUnit);
                    iv.visitZeroRegisterInsn(currentAddress, opcode, 0, 1, currentAddress + target, 0L);
                    continue block47;
                }
                case 0: 
                case 14: {
                    int opcode = InstructionCodec.byte0(opcodeUnit);
                    int literal = InstructionCodec.byte1(opcodeUnit);
                    iv.visitZeroRegisterInsn(currentAddress, opcode, 0, 1, 0, literal);
                    continue block47;
                }
                case 18: {
                    int opcode = InstructionCodec.byte0(opcodeUnit);
                    int a = InstructionCodec.nibble2(opcodeUnit);
                    int literal = InstructionCodec.nibble3(opcodeUnit) << 28 >> 28;
                    iv.visitOneRegisterInsn(currentAddress, opcode, 0, 1, 0, literal, a);
                    continue block47;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 15: 
                case 16: 
                case 17: 
                case 29: 
                case 30: 
                case 39: {
                    int opcode = InstructionCodec.byte0(opcodeUnit);
                    int a = InstructionCodec.byte1(opcodeUnit);
                    iv.visitOneRegisterInsn(currentAddress, opcode, 0, 1, 0, 0L, a);
                    continue block47;
                }
                case 1: 
                case 4: 
                case 7: 
                case 33: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: 
                case 128: 
                case 129: 
                case 130: 
                case 131: 
                case 132: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 142: 
                case 143: 
                case 176: 
                case 177: 
                case 178: 
                case 179: 
                case 180: 
                case 181: 
                case 182: 
                case 183: 
                case 184: 
                case 185: 
                case 186: 
                case 187: 
                case 188: 
                case 189: 
                case 190: 
                case 191: 
                case 192: 
                case 193: 
                case 194: 
                case 195: 
                case 196: 
                case 197: 
                case 198: 
                case 199: 
                case 200: 
                case 201: 
                case 202: 
                case 203: 
                case 204: 
                case 205: 
                case 206: 
                case 207: {
                    int opcode = InstructionCodec.byte0(opcodeUnit);
                    int a = InstructionCodec.nibble2(opcodeUnit);
                    int b = InstructionCodec.nibble3(opcodeUnit);
                    iv.visitTwoRegisterInsn(currentAddress, opcode, 0, 1, 0, 0L, a, b);
                    continue block47;
                }
                case 41: {
                    int opcode = InstructionCodec.byte0(opcodeUnit);
                    int literal = InstructionCodec.byte1(opcodeUnit);
                    short target = (short)this.codeIn.read();
                    iv.visitZeroRegisterInsn(currentAddress, opcode, 0, 1, currentAddress + target, literal);
                    continue block47;
                }
                case 26: 
                case 28: 
                case 31: 
                case 34: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: {
                    int opcode = InstructionCodec.byte0(opcodeUnit);
                    int a = InstructionCodec.byte1(opcodeUnit);
                    int index = this.codeIn.read();
                    int indexType = InstructionCodec.getInstructionIndexType(opcode);
                    iv.visitOneRegisterInsn(currentAddress, opcode, index, indexType, 0, 0L, a);
                    continue block47;
                }
                case 21: 
                case 25: {
                    int opcode = InstructionCodec.byte0(opcodeUnit);
                    int a = InstructionCodec.byte1(opcodeUnit);
                    long literal = (short)this.codeIn.read();
                    iv.visitOneRegisterInsn(currentAddress, opcode, 0, 1, 0, literal <<= opcode == 21 ? 16 : 48, a);
                    continue block47;
                }
                case 19: 
                case 22: {
                    int opcode = InstructionCodec.byte0(opcodeUnit);
                    int a = InstructionCodec.byte1(opcodeUnit);
                    short literal = (short)this.codeIn.read();
                    iv.visitOneRegisterInsn(currentAddress, opcode, 0, 1, 0, literal, a);
                    continue block47;
                }
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: {
                    int opcode = InstructionCodec.byte0(opcodeUnit);
                    int a = InstructionCodec.byte1(opcodeUnit);
                    short target = (short)this.codeIn.read();
                    iv.visitOneRegisterInsn(currentAddress, opcode, 0, 1, currentAddress + target, 0L, a);
                    continue block47;
                }
                case 216: 
                case 217: 
                case 218: 
                case 219: 
                case 220: 
                case 221: 
                case 222: 
                case 223: 
                case 224: 
                case 225: 
                case 226: {
                    int opcode = InstructionCodec.byte0(opcodeUnit);
                    int a = InstructionCodec.byte1(opcodeUnit);
                    int bc = this.codeIn.read();
                    int b = InstructionCodec.byte0(bc);
                    byte literal = (byte)InstructionCodec.byte1(bc);
                    iv.visitTwoRegisterInsn(currentAddress, opcode, 0, 1, 0, literal, a, b);
                    continue block47;
                }
                case 32: 
                case 35: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: {
                    int opcode = InstructionCodec.byte0(opcodeUnit);
                    int a = InstructionCodec.nibble2(opcodeUnit);
                    int b = InstructionCodec.nibble3(opcodeUnit);
                    int index = this.codeIn.read();
                    int indexType = InstructionCodec.getInstructionIndexType(opcode);
                    iv.visitTwoRegisterInsn(currentAddress, opcode, index, indexType, 0, 0L, a, b);
                    continue block47;
                }
                case 208: 
                case 209: 
                case 210: 
                case 211: 
                case 212: 
                case 213: 
                case 214: 
                case 215: {
                    int opcode = InstructionCodec.byte0(opcodeUnit);
                    int a = InstructionCodec.nibble2(opcodeUnit);
                    int b = InstructionCodec.nibble3(opcodeUnit);
                    short literal = (short)this.codeIn.read();
                    iv.visitTwoRegisterInsn(currentAddress, opcode, 0, 1, 0, literal, a, b);
                    continue block47;
                }
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: {
                    int opcode = InstructionCodec.byte0(opcodeUnit);
                    int a = InstructionCodec.nibble2(opcodeUnit);
                    int b = InstructionCodec.nibble3(opcodeUnit);
                    short target = (short)this.codeIn.read();
                    iv.visitTwoRegisterInsn(currentAddress, opcode, 0, 1, currentAddress + target, 0L, a, b);
                    continue block47;
                }
                case 2: 
                case 5: 
                case 8: {
                    int opcode = InstructionCodec.byte0(opcodeUnit);
                    int a = InstructionCodec.byte1(opcodeUnit);
                    int b = this.codeIn.read();
                    iv.visitTwoRegisterInsn(currentAddress, opcode, 0, 1, 0, 0L, a, b);
                    continue block47;
                }
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 144: 
                case 145: 
                case 146: 
                case 147: 
                case 148: 
                case 149: 
                case 150: 
                case 151: 
                case 152: 
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 168: 
                case 169: 
                case 170: 
                case 171: 
                case 172: 
                case 173: 
                case 174: 
                case 175: {
                    int opcode = InstructionCodec.byte0(opcodeUnit);
                    int a = InstructionCodec.byte1(opcodeUnit);
                    int bc = this.codeIn.read();
                    int b = InstructionCodec.byte0(bc);
                    int c = InstructionCodec.byte1(bc);
                    iv.visitThreeRegisterInsn(currentAddress, opcode, 0, 1, 0, 0L, a, b, c);
                    continue block47;
                }
                case 42: {
                    int opcode = InstructionCodec.byte0(opcodeUnit);
                    int literal = InstructionCodec.byte1(opcodeUnit);
                    int target = this.codeIn.readInt();
                    iv.visitZeroRegisterInsn(currentAddress, opcode, 0, 1, currentAddress + target, literal);
                    continue block47;
                }
                case 27: {
                    int opcode = InstructionCodec.byte0(opcodeUnit);
                    int a = InstructionCodec.byte1(opcodeUnit);
                    int index = this.codeIn.readInt();
                    int indexType = InstructionCodec.getInstructionIndexType(opcode);
                    iv.visitOneRegisterInsn(currentAddress, opcode, index, indexType, 0, 0L, a);
                    continue block47;
                }
                case 20: 
                case 23: {
                    int opcode = InstructionCodec.byte0(opcodeUnit);
                    int a = InstructionCodec.byte1(opcodeUnit);
                    int literal = this.codeIn.readInt();
                    iv.visitOneRegisterInsn(currentAddress, opcode, 0, 1, 0, literal, a);
                    continue block47;
                }
                case 38: 
                case 43: 
                case 44: {
                    int opcode = InstructionCodec.byte0(opcodeUnit);
                    int a = InstructionCodec.byte1(opcodeUnit);
                    int target = currentAddress + this.codeIn.readInt();
                    switch (opcode) {
                        case 43: 
                        case 44: {
                            this.codeIn.setBaseAddress(target + 1, currentAddress);
                        }
                    }
                    iv.visitOneRegisterInsn(currentAddress, opcode, 0, 1, target, 0L, a);
                    continue block47;
                }
                case 3: 
                case 6: 
                case 9: {
                    int opcode = InstructionCodec.byte0(opcodeUnit);
                    int literal = InstructionCodec.byte1(opcodeUnit);
                    int a = this.codeIn.read();
                    int b = this.codeIn.read();
                    iv.visitTwoRegisterInsn(currentAddress, opcode, 0, 1, 0, literal, a, b);
                    continue block47;
                }
                case 36: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: {
                    int opcode = InstructionCodec.byte0(opcodeUnit);
                    int e = InstructionCodec.nibble2(opcodeUnit);
                    int registerCount = InstructionCodec.nibble3(opcodeUnit);
                    int index = this.codeIn.read();
                    int abcd = this.codeIn.read();
                    int a = InstructionCodec.nibble0(abcd);
                    int b = InstructionCodec.nibble1(abcd);
                    int c = InstructionCodec.nibble2(abcd);
                    int d = InstructionCodec.nibble3(abcd);
                    int indexType = InstructionCodec.getInstructionIndexType(opcode);
                    switch (registerCount) {
                        case 0: {
                            iv.visitZeroRegisterInsn(currentAddress, opcode, index, indexType, 0, 0L);
                            continue block47;
                        }
                        case 1: {
                            iv.visitOneRegisterInsn(currentAddress, opcode, index, indexType, 0, 0L, a);
                            continue block47;
                        }
                        case 2: {
                            iv.visitTwoRegisterInsn(currentAddress, opcode, index, indexType, 0, 0L, a, b);
                            continue block47;
                        }
                        case 3: {
                            iv.visitThreeRegisterInsn(currentAddress, opcode, index, indexType, 0, 0L, a, b, c);
                            continue block47;
                        }
                        case 4: {
                            iv.visitFourRegisterInsn(currentAddress, opcode, index, indexType, 0, 0L, a, b, c, d);
                            continue block47;
                        }
                        case 5: {
                            iv.visitFiveRegisterInsn(currentAddress, opcode, index, indexType, 0, 0L, a, b, c, d, e);
                            continue block47;
                        }
                    }
                    throw new DexException("bogus registerCount: " + Hex.uNibble(registerCount));
                }
                case 37: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: {
                    int opcode = InstructionCodec.byte0(opcodeUnit);
                    int registerCount = InstructionCodec.byte1(opcodeUnit);
                    int index = this.codeIn.read();
                    int a = this.codeIn.read();
                    int indexType = InstructionCodec.getInstructionIndexType(opcode);
                    iv.visitRegisterRangeInsn(currentAddress, opcode, index, indexType, 0, 0L, a, registerCount);
                    continue block47;
                }
                case 24: {
                    int opcode = InstructionCodec.byte0(opcodeUnit);
                    int a = InstructionCodec.byte1(opcodeUnit);
                    long literal = this.codeIn.readLong();
                    iv.visitOneRegisterInsn(currentAddress, opcode, 0, 1, 0, literal, a);
                    continue block47;
                }
                case 768: {
                    int i;
                    int elementWidth = this.codeIn.read();
                    int size = this.codeIn.readInt();
                    switch (elementWidth) {
                        case 1: {
                            byte[] array = new byte[size];
                            boolean even = true;
                            int value = 0;
                            for (i = 0; i < size; ++i) {
                                if (even) {
                                    value = this.codeIn.read();
                                }
                                array[i] = (byte)(value & 0xFF);
                                value >>= 8;
                                even = !even;
                            }
                            iv.visitFillArrayDataPayloadInsn(currentAddress, opcodeUnit, array, array.length, 1);
                            continue block47;
                        }
                        case 2: {
                            short[] array = new short[size];
                            for (int i2 = 0; i2 < size; ++i2) {
                                array[i2] = (short)this.codeIn.read();
                            }
                            iv.visitFillArrayDataPayloadInsn(currentAddress, opcodeUnit, array, array.length, 2);
                            continue block47;
                        }
                        case 4: {
                            int[] array = new int[size];
                            for (int i3 = 0; i3 < size; ++i3) {
                                array[i3] = this.codeIn.readInt();
                            }
                            iv.visitFillArrayDataPayloadInsn(currentAddress, opcodeUnit, array, array.length, 4);
                            continue block47;
                        }
                        case 8: {
                            long[] array = new long[size];
                            for (int i4 = 0; i4 < size; ++i4) {
                                array[i4] = this.codeIn.readLong();
                            }
                            iv.visitFillArrayDataPayloadInsn(currentAddress, opcodeUnit, array, array.length, 8);
                            continue block47;
                        }
                    }
                    throw new DexException("bogus element_width: " + Hex.u2(elementWidth));
                }
                case 256: {
                    int i;
                    int baseAddress = this.codeIn.baseAddressForCursor();
                    int size = this.codeIn.read();
                    int firstKey = this.codeIn.readInt();
                    int[] targets = new int[size];
                    for (i = 0; i < size; ++i) {
                        targets[i] = baseAddress + this.codeIn.readInt();
                    }
                    iv.visitPackedSwitchPayloadInsn(currentAddress, opcodeUnit, firstKey, targets);
                    continue block47;
                }
                case 512: {
                    int i;
                    int baseAddress = this.codeIn.baseAddressForCursor();
                    int size = this.codeIn.read();
                    int[] keys = new int[size];
                    int[] targets = new int[size];
                    for (i = 0; i < size; ++i) {
                        keys[i] = this.codeIn.readInt();
                    }
                    for (i = 0; i < size; ++i) {
                        targets[i] = baseAddress + this.codeIn.readInt();
                    }
                    iv.visitSparseSwitchPayloadInsn(currentAddress, opcodeUnit, keys, targets);
                    continue block47;
                }
            }
            throw new IllegalStateException("Unknown opcode: " + Hex.u4(opcodeForSwitch));
        }
    }
}

