/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.android.dx.instruction;

import com.tencent.tinker.android.dex.DexException;
import com.tencent.tinker.android.dx.instruction.InstructionCodec;
import com.tencent.tinker.android.dx.instruction.InstructionPromoter;
import com.tencent.tinker.android.dx.instruction.InstructionVisitor;
import com.tencent.tinker.android.dx.instruction.ShortArrayCodeOutput;
import com.tencent.tinker.android.dx.util.Hex;

public final class InstructionWriter
extends InstructionVisitor {
    private final ShortArrayCodeOutput codeOut;
    private final InstructionPromoter insnPromoter;
    private final boolean hasPromoter;

    public InstructionWriter(ShortArrayCodeOutput codeOut, InstructionPromoter ipmo) {
        super(null);
        this.codeOut = codeOut;
        this.insnPromoter = ipmo;
        this.hasPromoter = ipmo != null;
    }

    @Override
    public void visitZeroRegisterInsn(int currentAddress, int opcode, int index, int indexType, int target, long literal) {
        if (this.hasPromoter) {
            target = this.insnPromoter.getPromotedAddress(target);
        }
        switch (opcode) {
            case -1: 
            case 0: 
            case 14: {
                short opcodeUnit = (short)opcode;
                this.codeOut.write(opcodeUnit);
                break;
            }
            case 40: {
                if (this.hasPromoter) {
                    int relativeTarget = InstructionCodec.getTarget(target, this.codeOut.cursor());
                    if (relativeTarget != (byte)relativeTarget) {
                        if (relativeTarget != (short)relativeTarget) {
                            short opcodeUnit = 42;
                            this.codeOut.write(opcodeUnit, InstructionCodec.unit0(relativeTarget), InstructionCodec.unit1(relativeTarget));
                            break;
                        }
                        short shortRelativeTarget = (short)relativeTarget;
                        short opcodeUnit = 41;
                        this.codeOut.write(opcodeUnit, shortRelativeTarget);
                        break;
                    }
                    this.codeOut.write(InstructionCodec.codeUnit(opcode, relativeTarget &= 0xFF));
                    break;
                }
                int relativeTarget = InstructionCodec.getTargetByte(target, this.codeOut.cursor());
                this.codeOut.write(InstructionCodec.codeUnit(opcode, relativeTarget));
                break;
            }
            case 41: {
                if (this.hasPromoter) {
                    int relativeTarget = InstructionCodec.getTarget(target, this.codeOut.cursor());
                    if (relativeTarget != (short)relativeTarget) {
                        short opcodeUnit = 42;
                        this.codeOut.write(opcodeUnit, InstructionCodec.unit0(relativeTarget), InstructionCodec.unit1(relativeTarget));
                        break;
                    }
                    short shortRelativeTarget = (short)relativeTarget;
                    short opcodeUnit = (short)opcode;
                    this.codeOut.write(opcodeUnit, shortRelativeTarget);
                    break;
                }
                short relativeTarget = InstructionCodec.getTargetUnit(target, this.codeOut.cursor());
                short opcodeUnit = (short)opcode;
                this.codeOut.write(opcodeUnit, relativeTarget);
                break;
            }
            case 42: {
                int relativeTarget = InstructionCodec.getTarget(target, this.codeOut.cursor());
                short opcodeUnit = (short)opcode;
                this.codeOut.write(opcodeUnit, InstructionCodec.unit0(relativeTarget), InstructionCodec.unit1(relativeTarget));
                break;
            }
            case 36: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: {
                short indexUnit = (short)index;
                this.codeOut.write(InstructionCodec.codeUnit(opcode, InstructionCodec.makeByte(0, 0)), indexUnit, InstructionCodec.codeUnit(0, 0, 0, 0));
                break;
            }
            default: {
                throw new IllegalStateException("unexpected opcode: " + Hex.u2or4(opcode));
            }
        }
    }

    @Override
    public void visitOneRegisterInsn(int currentAddress, int opcode, int index, int indexType, int target, long literal, int a) {
        if (this.hasPromoter) {
            target = this.insnPromoter.getPromotedAddress(target);
        }
        switch (opcode) {
            case 18: {
                short opcodeUnit = (short)opcode;
                this.codeOut.write(InstructionCodec.codeUnit(opcodeUnit, InstructionCodec.makeByte(a, InstructionCodec.getLiteralNibble(literal))));
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 29: 
            case 30: 
            case 39: {
                this.codeOut.write(InstructionCodec.codeUnit(opcode, a));
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                short relativeTarget = InstructionCodec.getTargetUnit(target, this.codeOut.cursor());
                this.codeOut.write(InstructionCodec.codeUnit(opcode, a), relativeTarget);
                break;
            }
            case 19: 
            case 22: {
                this.codeOut.write(InstructionCodec.codeUnit(opcode, a), InstructionCodec.getLiteralUnit(literal));
                break;
            }
            case 21: 
            case 25: {
                int shift = opcode == 21 ? 16 : 48;
                short literalShifted = (short)(literal >> shift);
                this.codeOut.write(InstructionCodec.codeUnit(opcode, a), literalShifted);
                break;
            }
            case 26: {
                if (this.hasPromoter) {
                    if (index > 65535) {
                        this.codeOut.write(InstructionCodec.codeUnit(27, a), InstructionCodec.unit0(index), InstructionCodec.unit1(index));
                        break;
                    }
                    short indexUnit = (short)index;
                    this.codeOut.write(InstructionCodec.codeUnit(opcode, a), indexUnit);
                    break;
                }
                if (index > 65535) {
                    throw new DexException("string index out of bound: " + Hex.u4(index) + ", perhaps you need to enable force jumbo mode.");
                }
                short indexUnit = (short)index;
                this.codeOut.write(InstructionCodec.codeUnit(opcode, a), indexUnit);
                break;
            }
            case 28: 
            case 31: 
            case 34: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: {
                short indexUnit = (short)index;
                this.codeOut.write(InstructionCodec.codeUnit(opcode, a), indexUnit);
                break;
            }
            case 20: 
            case 23: {
                int literalInt = InstructionCodec.getLiteralInt(literal);
                this.codeOut.write(InstructionCodec.codeUnit(opcode, a), InstructionCodec.unit0(literalInt), InstructionCodec.unit1(literalInt));
                break;
            }
            case 38: 
            case 43: 
            case 44: {
                switch (opcode) {
                    case 43: 
                    case 44: {
                        this.codeOut.setBaseAddress(target, this.codeOut.cursor());
                    }
                }
                int relativeTarget = InstructionCodec.getTarget(target, this.codeOut.cursor());
                this.codeOut.write(InstructionCodec.codeUnit(opcode, a), InstructionCodec.unit0(relativeTarget), InstructionCodec.unit1(relativeTarget));
                break;
            }
            case 27: {
                this.codeOut.write(InstructionCodec.codeUnit(opcode, a), InstructionCodec.unit0(index), InstructionCodec.unit1(index));
                break;
            }
            case 24: {
                this.codeOut.write(InstructionCodec.codeUnit(opcode, a), InstructionCodec.unit0(literal), InstructionCodec.unit1(literal), InstructionCodec.unit2(literal), InstructionCodec.unit3(literal));
                break;
            }
            case 36: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: {
                short indexUnit = (short)index;
                this.codeOut.write(InstructionCodec.codeUnit(opcode, InstructionCodec.makeByte(0, 1)), indexUnit, InstructionCodec.codeUnit(a, 0, 0, 0));
                break;
            }
            default: {
                throw new IllegalStateException("unexpected opcode: " + Hex.u2or4(opcode));
            }
        }
    }

    @Override
    public void visitTwoRegisterInsn(int currentAddress, int opcode, int index, int indexType, int target, long literal, int a, int b) {
        if (this.hasPromoter) {
            target = this.insnPromoter.getPromotedAddress(target);
        }
        switch (opcode) {
            case 1: 
            case 4: 
            case 7: 
            case 33: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: {
                short opcodeUnit = (short)opcode;
                this.codeOut.write(InstructionCodec.codeUnit(opcodeUnit, InstructionCodec.makeByte(a, b)));
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                this.codeOut.write(InstructionCodec.codeUnit(opcode, a), InstructionCodec.getBUnit(b));
                break;
            }
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 225: 
            case 226: {
                this.codeOut.write(InstructionCodec.codeUnit(opcode, a), InstructionCodec.codeUnit(b, InstructionCodec.getLiteralByte(literal)));
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                short relativeTarget = InstructionCodec.getTargetUnit(target, this.codeOut.cursor());
                this.codeOut.write(InstructionCodec.codeUnit(opcode, InstructionCodec.makeByte(a, b)), relativeTarget);
                break;
            }
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: {
                this.codeOut.write(InstructionCodec.codeUnit(opcode, InstructionCodec.makeByte(a, b)), InstructionCodec.getLiteralUnit(literal));
                break;
            }
            case 32: 
            case 35: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                short indexUnit = (short)index;
                this.codeOut.write(InstructionCodec.codeUnit(opcode, InstructionCodec.makeByte(a, b)), indexUnit);
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                short opcodeUnit = (short)opcode;
                this.codeOut.write(opcodeUnit, InstructionCodec.getAUnit(a), InstructionCodec.getBUnit(b));
                break;
            }
            case 36: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: {
                short indexUnit = (short)index;
                this.codeOut.write(InstructionCodec.codeUnit(opcode, InstructionCodec.makeByte(0, 2)), indexUnit, InstructionCodec.codeUnit(a, b, 0, 0));
                break;
            }
            default: {
                throw new IllegalStateException("unexpected opcode: " + Hex.u2or4(opcode));
            }
        }
    }

    @Override
    public void visitThreeRegisterInsn(int currentAddress, int opcode, int index, int indexType, int target, long literal, int a, int b, int c) {
        switch (opcode) {
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: {
                this.codeOut.write(InstructionCodec.codeUnit(opcode, a), InstructionCodec.codeUnit(b, c));
                break;
            }
            case 36: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: {
                short indexUnit = (short)index;
                this.codeOut.write(InstructionCodec.codeUnit(opcode, InstructionCodec.makeByte(0, 3)), indexUnit, InstructionCodec.codeUnit(a, b, c, 0));
                break;
            }
            default: {
                throw new IllegalStateException("unexpected opcode: " + Hex.u2or4(opcode));
            }
        }
    }

    @Override
    public void visitFourRegisterInsn(int currentAddress, int opcode, int index, int indexType, int target, long literal, int a, int b, int c, int d) {
        switch (opcode) {
            case 36: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: {
                short indexUnit = (short)index;
                this.codeOut.write(InstructionCodec.codeUnit(opcode, InstructionCodec.makeByte(0, 4)), indexUnit, InstructionCodec.codeUnit(a, b, c, d));
                break;
            }
            default: {
                throw new IllegalStateException("unexpected opcode: " + Hex.u2or4(opcode));
            }
        }
    }

    @Override
    public void visitFiveRegisterInsn(int currentAddress, int opcode, int index, int indexType, int target, long literal, int a, int b, int c, int d, int e) {
        switch (opcode) {
            case 36: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: {
                short indexUnit = (short)index;
                this.codeOut.write(InstructionCodec.codeUnit(opcode, InstructionCodec.makeByte(e, 5)), indexUnit, InstructionCodec.codeUnit(a, b, c, d));
                break;
            }
            default: {
                throw new IllegalStateException("unexpected opcode: " + Hex.u2or4(opcode));
            }
        }
    }

    @Override
    public void visitRegisterRangeInsn(int currentAddress, int opcode, int index, int indexType, int target, long literal, int a, int registerCount) {
        switch (opcode) {
            case 37: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: {
                short indexUnit = (short)index;
                this.codeOut.write(InstructionCodec.codeUnit(opcode, registerCount), indexUnit, InstructionCodec.getAUnit(a));
                break;
            }
            default: {
                throw new IllegalStateException("unexpected opcode: " + Hex.u2or4(opcode));
            }
        }
    }

    @Override
    public void visitSparseSwitchPayloadInsn(int currentAddress, int opcode, int[] keys, int[] targets) {
        int baseAddress = this.codeOut.baseAddressForCursor();
        short opcodeUnit = (short)opcode;
        this.codeOut.write(opcodeUnit);
        this.codeOut.write(InstructionCodec.asUnsignedUnit(targets.length));
        for (int key : keys) {
            this.codeOut.writeInt(key);
        }
        if (this.hasPromoter) {
            for (int target : targets) {
                target = this.insnPromoter.getPromotedAddress(target);
                this.codeOut.writeInt(target - baseAddress);
            }
        } else {
            for (int target : targets) {
                this.codeOut.writeInt(target - baseAddress);
            }
        }
    }

    @Override
    public void visitPackedSwitchPayloadInsn(int currentAddress, int opcode, int firstKey, int[] targets) {
        int baseAddress = this.codeOut.baseAddressForCursor();
        short opcodeUnit = (short)opcode;
        this.codeOut.write(opcodeUnit);
        this.codeOut.write(InstructionCodec.asUnsignedUnit(targets.length));
        this.codeOut.writeInt(firstKey);
        if (this.hasPromoter) {
            for (int target : targets) {
                target = this.insnPromoter.getPromotedAddress(target);
                this.codeOut.writeInt(target - baseAddress);
            }
        } else {
            for (int target : targets) {
                this.codeOut.writeInt(target - baseAddress);
            }
        }
    }

    @Override
    public void visitFillArrayDataPayloadInsn(int currentAddress, int opcode, Object data, int size, int elementWidth) {
        short opcodeUnit = (short)opcode;
        this.codeOut.write(opcodeUnit);
        short elementWidthUnit = (short)elementWidth;
        this.codeOut.write(elementWidthUnit);
        this.codeOut.writeInt(size);
        switch (elementWidth) {
            case 1: {
                this.codeOut.write((byte[])data);
                break;
            }
            case 2: {
                this.codeOut.write((short[])data);
                break;
            }
            case 4: {
                this.codeOut.write((int[])data);
                break;
            }
            case 8: {
                this.codeOut.write((long[])data);
                break;
            }
            default: {
                throw new DexException("bogus element_width: " + Hex.u2(elementWidth));
            }
        }
    }
}

