/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader.shareutil;

import com.tencent.tinker.loader.TinkerRuntimeException;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Pattern;

public class ShareResPatchInfo {
    public String arscBaseCrc = null;
    public String resArscMd5 = null;
    public ArrayList<String> addRes = new ArrayList();
    public ArrayList<String> deleteRes = new ArrayList();
    public ArrayList<String> modRes = new ArrayList();
    public HashMap<String, File> storeRes = new HashMap();
    public ArrayList<String> largeModRes = new ArrayList();
    public HashMap<String, LargeModeInfo> largeModMap = new HashMap();
    public HashSet<Pattern> patterns = new HashSet();

    public static void parseAllResPatchInfo(String meta, ShareResPatchInfo info) {
        if (meta == null || meta.length() == 0) {
            return;
        }
        String[] lines = meta.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            int size;
            String[] kv;
            String line = lines[i];
            if (line == null || line.length() <= 0) continue;
            if (line.startsWith("resources_out.zip")) {
                kv = line.split(",", 3);
                info.arscBaseCrc = kv[1];
                info.resArscMd5 = kv[2];
                continue;
            }
            if (line.startsWith("pattern:")) {
                kv = line.split(":", 2);
                for (size = Integer.parseInt(kv[1]); size > 0; --size) {
                    info.patterns.add(ShareResPatchInfo.convertToPatternString(lines[i + 1]));
                    ++i;
                }
                continue;
            }
            if (line.startsWith("add:")) {
                kv = line.split(":", 2);
                for (size = Integer.parseInt(kv[1]); size > 0; --size) {
                    info.addRes.add(lines[i + 1]);
                    ++i;
                }
                continue;
            }
            if (line.startsWith("modify:")) {
                kv = line.split(":", 2);
                for (size = Integer.parseInt(kv[1]); size > 0; --size) {
                    info.modRes.add(lines[i + 1]);
                    ++i;
                }
                continue;
            }
            if (line.startsWith("large modify:")) {
                kv = line.split(":", 2);
                for (size = Integer.parseInt(kv[1]); size > 0; --size) {
                    String nextLine = lines[i + 1];
                    String[] data = nextLine.split(",", 3);
                    String name = data[0];
                    LargeModeInfo largeModeInfo = new LargeModeInfo();
                    largeModeInfo.md5 = data[1];
                    largeModeInfo.crc = Long.parseLong(data[2]);
                    info.largeModRes.add(name);
                    info.largeModMap.put(name, largeModeInfo);
                    ++i;
                }
                continue;
            }
            if (line.startsWith("delete:")) {
                kv = line.split(":", 2);
                for (size = Integer.parseInt(kv[1]); size > 0; --size) {
                    info.deleteRes.add(lines[i + 1]);
                    ++i;
                }
                continue;
            }
            if (!line.startsWith("store:")) continue;
            kv = line.split(":", 2);
            for (size = Integer.parseInt(kv[1]); size > 0; --size) {
                info.storeRes.put(lines[i + 1], null);
                ++i;
            }
        }
    }

    public static boolean checkFileInPattern(HashSet<Pattern> patterns, String key) {
        if (!patterns.isEmpty()) {
            for (Pattern p : patterns) {
                if (!p.matcher(key).matches()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean checkResPatchInfo(ShareResPatchInfo info) {
        if (info == null) {
            return false;
        }
        String md5 = info.resArscMd5;
        return md5 != null && md5.length() == 32;
    }

    private static Pattern convertToPatternString(String input) {
        if (input.contains(".")) {
            input = input.replaceAll("\\.", "\\\\.");
        }
        if (input.contains("?")) {
            input = input.replaceAll("\\?", "\\.");
        }
        if (input.contains("*")) {
            input = input.replace("*", ".*");
        }
        Pattern pattern = Pattern.compile(input);
        return pattern;
    }

    public static void parseResPatchInfoFirstLine(String meta, ShareResPatchInfo info) {
        if (meta == null || meta.length() == 0) {
            return;
        }
        String[] lines = meta.split("\n");
        String firstLine = lines[0];
        if (firstLine == null || firstLine.length() <= 0) {
            throw new TinkerRuntimeException("res meta Corrupted:" + meta);
        }
        String[] kv = firstLine.split(",", 3);
        info.arscBaseCrc = kv[1];
        info.resArscMd5 = kv[2];
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("resArscMd5:" + this.resArscMd5 + "\n");
        sb.append("arscBaseCrc:" + this.arscBaseCrc + "\n");
        for (Pattern pattern : this.patterns) {
            sb.append("pattern:" + pattern + "\n");
        }
        for (String add : this.addRes) {
            sb.append("addedSet:" + add + "\n");
        }
        for (String mod : this.modRes) {
            sb.append("modifiedSet:" + mod + "\n");
        }
        for (String largeMod : this.largeModRes) {
            sb.append("largeModifiedSet:" + largeMod + "\n");
        }
        for (String del : this.deleteRes) {
            sb.append("deletedSet:" + del + "\n");
        }
        for (String store : this.storeRes.keySet()) {
            sb.append("storeSet:" + store + "\n");
        }
        return sb.toString();
    }

    public static class LargeModeInfo {
        public String md5 = null;
        public long crc;
        public File file = null;
    }
}

