/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cdb.v20170320.models;

import com.tencentcloudapi.common.AbstractModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class ParamRecord  extends AbstractModel{

    /**
    * 实例ID
    */
    @SerializedName("InstanceId")
    @Expose
    private String InstanceId;

    /**
    * 参数名称
    */
    @SerializedName("ParamName")
    @Expose
    private String ParamName;

    /**
    * 参数修改前的值
    */
    @SerializedName("OldValue")
    @Expose
    private String OldValue;

    /**
    * 参数修改后的值
    */
    @SerializedName("NewValue")
    @Expose
    private String NewValue;

    /**
    * 参数是否修改成功
    */
    @SerializedName("IsSucess")
    @Expose
    private Boolean IsSucess;

    /**
    * 修改时间
    */
    @SerializedName("ModifyTime")
    @Expose
    private String ModifyTime;

    /**
     * 获取实例ID
     * @return InstanceId 实例ID
     */
    public String getInstanceId() {
        return this.InstanceId;
    }

    /**
     * 设置实例ID
     * @param InstanceId 实例ID
     */
    public void setInstanceId(String InstanceId) {
        this.InstanceId = InstanceId;
    }

    /**
     * 获取参数名称
     * @return ParamName 参数名称
     */
    public String getParamName() {
        return this.ParamName;
    }

    /**
     * 设置参数名称
     * @param ParamName 参数名称
     */
    public void setParamName(String ParamName) {
        this.ParamName = ParamName;
    }

    /**
     * 获取参数修改前的值
     * @return OldValue 参数修改前的值
     */
    public String getOldValue() {
        return this.OldValue;
    }

    /**
     * 设置参数修改前的值
     * @param OldValue 参数修改前的值
     */
    public void setOldValue(String OldValue) {
        this.OldValue = OldValue;
    }

    /**
     * 获取参数修改后的值
     * @return NewValue 参数修改后的值
     */
    public String getNewValue() {
        return this.NewValue;
    }

    /**
     * 设置参数修改后的值
     * @param NewValue 参数修改后的值
     */
    public void setNewValue(String NewValue) {
        this.NewValue = NewValue;
    }

    /**
     * 获取参数是否修改成功
     * @return IsSucess 参数是否修改成功
     */
    public Boolean getIsSucess() {
        return this.IsSucess;
    }

    /**
     * 设置参数是否修改成功
     * @param IsSucess 参数是否修改成功
     */
    public void setIsSucess(Boolean IsSucess) {
        this.IsSucess = IsSucess;
    }

    /**
     * 获取修改时间
     * @return ModifyTime 修改时间
     */
    public String getModifyTime() {
        return this.ModifyTime;
    }

    /**
     * 设置修改时间
     * @param ModifyTime 修改时间
     */
    public void setModifyTime(String ModifyTime) {
        this.ModifyTime = ModifyTime;
    }

    /**
     * 内部实现，用户禁止调用
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "InstanceId", this.InstanceId);
        this.setParamSimple(map, prefix + "ParamName", this.ParamName);
        this.setParamSimple(map, prefix + "OldValue", this.OldValue);
        this.setParamSimple(map, prefix + "NewValue", this.NewValue);
        this.setParamSimple(map, prefix + "IsSucess", this.IsSucess);
        this.setParamSimple(map, prefix + "ModifyTime", this.ModifyTime);

    }
}

