/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cdn.v20180606.models;

import com.tencentcloudapi.common.AbstractModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class MapInfo  extends AbstractModel{

    /**
    * 对象 Id
    */
    @SerializedName("Id")
    @Expose
    private Integer Id;

    /**
    * 对象名称
    */
    @SerializedName("Name")
    @Expose
    private String Name;

    /**
     * 获取对象 Id
     * @return Id 对象 Id
     */
    public Integer getId() {
        return this.Id;
    }

    /**
     * 设置对象 Id
     * @param Id 对象 Id
     */
    public void setId(Integer Id) {
        this.Id = Id;
    }

    /**
     * 获取对象名称
     * @return Name 对象名称
     */
    public String getName() {
        return this.Name;
    }

    /**
     * 设置对象名称
     * @param Name 对象名称
     */
    public void setName(String Name) {
        this.Name = Name;
    }

    /**
     * 内部实现，用户禁止调用
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Id", this.Id);
        this.setParamSimple(map, prefix + "Name", this.Name);

    }
}

