/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cms.v20190321.models;

import com.tencentcloudapi.common.AbstractModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeModerationOverviewRequest  extends AbstractModel{

    /**
    * 日期，如2019-01-01， 查询该日期的概览数据
    */
    @SerializedName("Date")
    @Expose
    private String Date;

    /**
    * 服务类型数组，可以动态配置，Text:文本，Image:图片，Audio:音频，Video:视频, 使用"ALL"表示所有类型, 不区分大小写，如 ["Text", "Image"]查询文本和图片服务的数据，["all"]查询所有服务的数据。
    */
    @SerializedName("ServiceTypes")
    @Expose
    private String [] ServiceTypes;

    /**
    * 渠道号数组，1:直播 2:点播 3:IM 4:GME，统计指定渠道组合的汇总数据，如[1,2]表示获取直播和点播两个渠道的汇总数据，不填[]为所有渠道汇总数据
    */
    @SerializedName("Channels")
    @Expose
    private Long [] Channels;

    /**
     * 获取日期，如2019-01-01， 查询该日期的概览数据
     * @return Date 日期，如2019-01-01， 查询该日期的概览数据
     */
    public String getDate() {
        return this.Date;
    }

    /**
     * 设置日期，如2019-01-01， 查询该日期的概览数据
     * @param Date 日期，如2019-01-01， 查询该日期的概览数据
     */
    public void setDate(String Date) {
        this.Date = Date;
    }

    /**
     * 获取服务类型数组，可以动态配置，Text:文本，Image:图片，Audio:音频，Video:视频, 使用"ALL"表示所有类型, 不区分大小写，如 ["Text", "Image"]查询文本和图片服务的数据，["all"]查询所有服务的数据。
     * @return ServiceTypes 服务类型数组，可以动态配置，Text:文本，Image:图片，Audio:音频，Video:视频, 使用"ALL"表示所有类型, 不区分大小写，如 ["Text", "Image"]查询文本和图片服务的数据，["all"]查询所有服务的数据。
     */
    public String [] getServiceTypes() {
        return this.ServiceTypes;
    }

    /**
     * 设置服务类型数组，可以动态配置，Text:文本，Image:图片，Audio:音频，Video:视频, 使用"ALL"表示所有类型, 不区分大小写，如 ["Text", "Image"]查询文本和图片服务的数据，["all"]查询所有服务的数据。
     * @param ServiceTypes 服务类型数组，可以动态配置，Text:文本，Image:图片，Audio:音频，Video:视频, 使用"ALL"表示所有类型, 不区分大小写，如 ["Text", "Image"]查询文本和图片服务的数据，["all"]查询所有服务的数据。
     */
    public void setServiceTypes(String [] ServiceTypes) {
        this.ServiceTypes = ServiceTypes;
    }

    /**
     * 获取渠道号数组，1:直播 2:点播 3:IM 4:GME，统计指定渠道组合的汇总数据，如[1,2]表示获取直播和点播两个渠道的汇总数据，不填[]为所有渠道汇总数据
     * @return Channels 渠道号数组，1:直播 2:点播 3:IM 4:GME，统计指定渠道组合的汇总数据，如[1,2]表示获取直播和点播两个渠道的汇总数据，不填[]为所有渠道汇总数据
     */
    public Long [] getChannels() {
        return this.Channels;
    }

    /**
     * 设置渠道号数组，1:直播 2:点播 3:IM 4:GME，统计指定渠道组合的汇总数据，如[1,2]表示获取直播和点播两个渠道的汇总数据，不填[]为所有渠道汇总数据
     * @param Channels 渠道号数组，1:直播 2:点播 3:IM 4:GME，统计指定渠道组合的汇总数据，如[1,2]表示获取直播和点播两个渠道的汇总数据，不填[]为所有渠道汇总数据
     */
    public void setChannels(Long [] Channels) {
        this.Channels = Channels;
    }

    /**
     * 内部实现，用户禁止调用
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Date", this.Date);
        this.setParamArraySimple(map, prefix + "ServiceTypes.", this.ServiceTypes);
        this.setParamArraySimple(map, prefix + "Channels.", this.Channels);

    }
}

