/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.iai.v20180301.models;

import com.tencentcloudapi.common.AbstractModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class GetPersonListResponse  extends AbstractModel{

    /**
    * 返回的人员信息
    */
    @SerializedName("PersonInfos")
    @Expose
    private PersonInfo [] PersonInfos;

    /**
    * 该人员库的人员数量
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("PersonNum")
    @Expose
    private Integer PersonNum;

    /**
    * 该人员库的人脸数量
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("FaceNum")
    @Expose
    private Integer FaceNum;

    /**
    * 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * 获取返回的人员信息
     * @return PersonInfos 返回的人员信息
     */
    public PersonInfo [] getPersonInfos() {
        return this.PersonInfos;
    }

    /**
     * 设置返回的人员信息
     * @param PersonInfos 返回的人员信息
     */
    public void setPersonInfos(PersonInfo [] PersonInfos) {
        this.PersonInfos = PersonInfos;
    }

    /**
     * 获取该人员库的人员数量
注意：此字段可能返回 null，表示取不到有效值。
     * @return PersonNum 该人员库的人员数量
注意：此字段可能返回 null，表示取不到有效值。
     */
    public Integer getPersonNum() {
        return this.PersonNum;
    }

    /**
     * 设置该人员库的人员数量
注意：此字段可能返回 null，表示取不到有效值。
     * @param PersonNum 该人员库的人员数量
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setPersonNum(Integer PersonNum) {
        this.PersonNum = PersonNum;
    }

    /**
     * 获取该人员库的人脸数量
注意：此字段可能返回 null，表示取不到有效值。
     * @return FaceNum 该人员库的人脸数量
注意：此字段可能返回 null，表示取不到有效值。
     */
    public Integer getFaceNum() {
        return this.FaceNum;
    }

    /**
     * 设置该人员库的人脸数量
注意：此字段可能返回 null，表示取不到有效值。
     * @param FaceNum 该人员库的人脸数量
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setFaceNum(Integer FaceNum) {
        this.FaceNum = FaceNum;
    }

    /**
     * 获取唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     * @return RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * 设置唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     * @param RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    /**
     * 内部实现，用户禁止调用
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "PersonInfos.", this.PersonInfos);
        this.setParamSimple(map, prefix + "PersonNum", this.PersonNum);
        this.setParamSimple(map, prefix + "FaceNum", this.FaceNum);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

