/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.scf.v20180416.models;

import com.tencentcloudapi.common.AbstractModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class Tag  extends AbstractModel{

    /**
    * 标签的key
    */
    @SerializedName("Key")
    @Expose
    private String Key;

    /**
    * 标签的value
    */
    @SerializedName("Value")
    @Expose
    private String Value;

    /**
     * 获取标签的key
     * @return Key 标签的key
     */
    public String getKey() {
        return this.Key;
    }

    /**
     * 设置标签的key
     * @param Key 标签的key
     */
    public void setKey(String Key) {
        this.Key = Key;
    }

    /**
     * 获取标签的value
     * @return Value 标签的value
     */
    public String getValue() {
        return this.Value;
    }

    /**
     * 设置标签的value
     * @param Value 标签的value
     */
    public void setValue(String Value) {
        this.Value = Value;
    }

    /**
     * 内部实现，用户禁止调用
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Key", this.Key);
        this.setParamSimple(map, prefix + "Value", this.Value);

    }
}

