/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.tke.v20180525.models;

import com.tencentcloudapi.common.AbstractModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeClusterSecurityRequest  extends AbstractModel{

    /**
    * 集群 ID，请填写 查询集群列表 接口中返回的 clusterId 字段
    */
    @SerializedName("ClusterId")
    @Expose
    private String ClusterId;

    /**
     * 获取集群 ID，请填写 查询集群列表 接口中返回的 clusterId 字段
     * @return ClusterId 集群 ID，请填写 查询集群列表 接口中返回的 clusterId 字段
     */
    public String getClusterId() {
        return this.ClusterId;
    }

    /**
     * 设置集群 ID，请填写 查询集群列表 接口中返回的 clusterId 字段
     * @param ClusterId 集群 ID，请填写 查询集群列表 接口中返回的 clusterId 字段
     */
    public void setClusterId(String ClusterId) {
        this.ClusterId = ClusterId;
    }

    /**
     * 内部实现，用户禁止调用
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "ClusterId", this.ClusterId);

    }
}

