/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.tcb.v20180608.models;

import com.tencentcloudapi.common.AbstractModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeQuotaDataResponse extends AbstractModel{

    /**
    * 指标名
    */
    @SerializedName("MetricName")
    @Expose
    private String MetricName;

    /**
    * 指标的值
    */
    @SerializedName("Value")
    @Expose
    private Long Value;

    /**
    * 指标的附加值信息
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("SubValue")
    @Expose
    private String SubValue;

    /**
    * 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get 指标名 
     * @return MetricName 指标名
     */
    public String getMetricName() {
        return this.MetricName;
    }

    /**
     * Set 指标名
     * @param MetricName 指标名
     */
    public void setMetricName(String MetricName) {
        this.MetricName = MetricName;
    }

    /**
     * Get 指标的值 
     * @return Value 指标的值
     */
    public Long getValue() {
        return this.Value;
    }

    /**
     * Set 指标的值
     * @param Value 指标的值
     */
    public void setValue(Long Value) {
        this.Value = Value;
    }

    /**
     * Get 指标的附加值信息
注意：此字段可能返回 null，表示取不到有效值。 
     * @return SubValue 指标的附加值信息
注意：此字段可能返回 null，表示取不到有效值。
     */
    public String getSubValue() {
        return this.SubValue;
    }

    /**
     * Set 指标的附加值信息
注意：此字段可能返回 null，表示取不到有效值。
     * @param SubValue 指标的附加值信息
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setSubValue(String SubValue) {
        this.SubValue = SubValue;
    }

    /**
     * Get 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。 
     * @return RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     * @param RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "MetricName", this.MetricName);
        this.setParamSimple(map, prefix + "Value", this.Value);
        this.setParamSimple(map, prefix + "SubValue", this.SubValue);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

