/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.gse.v20191112.models;

import com.tencentcloudapi.common.AbstractModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class GameProperty extends AbstractModel{

    /**
    * 属性名称，最大长度不超过32个ASCII字符
    */
    @SerializedName("Key")
    @Expose
    private String Key;

    /**
    * 属性值，最大长度不超过96个ASCII字符
    */
    @SerializedName("Value")
    @Expose
    private String Value;

    /**
     * Get 属性名称，最大长度不超过32个ASCII字符 
     * @return Key 属性名称，最大长度不超过32个ASCII字符
     */
    public String getKey() {
        return this.Key;
    }

    /**
     * Set 属性名称，最大长度不超过32个ASCII字符
     * @param Key 属性名称，最大长度不超过32个ASCII字符
     */
    public void setKey(String Key) {
        this.Key = Key;
    }

    /**
     * Get 属性值，最大长度不超过96个ASCII字符 
     * @return Value 属性值，最大长度不超过96个ASCII字符
     */
    public String getValue() {
        return this.Value;
    }

    /**
     * Set 属性值，最大长度不超过96个ASCII字符
     * @param Value 属性值，最大长度不超过96个ASCII字符
     */
    public void setValue(String Value) {
        this.Value = Value;
    }

    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Key", this.Key);
        this.setParamSimple(map, prefix + "Value", this.Value);

    }
}

