/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.ims.v20200713.models;

import com.tencentcloudapi.common.AbstractModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class TrendCount extends AbstractModel{

    /**
    * 总调用量
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("TotalCount")
    @Expose
    private Long TotalCount;

    /**
    * 总调用时长
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("TotalHour")
    @Expose
    private Long TotalHour;

    /**
    * 通过量
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("PassCount")
    @Expose
    private Long PassCount;

    /**
    * 通过时长
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("PassHour")
    @Expose
    private Long PassHour;

    /**
    * 违规量
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("EvilCount")
    @Expose
    private Long EvilCount;

    /**
    * 违规时长
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("EvilHour")
    @Expose
    private Long EvilHour;

    /**
    * 疑似违规量
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("SuspectCount")
    @Expose
    private Long SuspectCount;

    /**
    * 疑似违规时长
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("SuspectHour")
    @Expose
    private Long SuspectHour;

    /**
    * 日期
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("Date")
    @Expose
    private String Date;

    /**
     * Get 总调用量
注意：此字段可能返回 null，表示取不到有效值。 
     * @return TotalCount 总调用量
注意：此字段可能返回 null，表示取不到有效值。
     */
    public Long getTotalCount() {
        return this.TotalCount;
    }

    /**
     * Set 总调用量
注意：此字段可能返回 null，表示取不到有效值。
     * @param TotalCount 总调用量
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setTotalCount(Long TotalCount) {
        this.TotalCount = TotalCount;
    }

    /**
     * Get 总调用时长
注意：此字段可能返回 null，表示取不到有效值。 
     * @return TotalHour 总调用时长
注意：此字段可能返回 null，表示取不到有效值。
     */
    public Long getTotalHour() {
        return this.TotalHour;
    }

    /**
     * Set 总调用时长
注意：此字段可能返回 null，表示取不到有效值。
     * @param TotalHour 总调用时长
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setTotalHour(Long TotalHour) {
        this.TotalHour = TotalHour;
    }

    /**
     * Get 通过量
注意：此字段可能返回 null，表示取不到有效值。 
     * @return PassCount 通过量
注意：此字段可能返回 null，表示取不到有效值。
     */
    public Long getPassCount() {
        return this.PassCount;
    }

    /**
     * Set 通过量
注意：此字段可能返回 null，表示取不到有效值。
     * @param PassCount 通过量
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setPassCount(Long PassCount) {
        this.PassCount = PassCount;
    }

    /**
     * Get 通过时长
注意：此字段可能返回 null，表示取不到有效值。 
     * @return PassHour 通过时长
注意：此字段可能返回 null，表示取不到有效值。
     */
    public Long getPassHour() {
        return this.PassHour;
    }

    /**
     * Set 通过时长
注意：此字段可能返回 null，表示取不到有效值。
     * @param PassHour 通过时长
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setPassHour(Long PassHour) {
        this.PassHour = PassHour;
    }

    /**
     * Get 违规量
注意：此字段可能返回 null，表示取不到有效值。 
     * @return EvilCount 违规量
注意：此字段可能返回 null，表示取不到有效值。
     */
    public Long getEvilCount() {
        return this.EvilCount;
    }

    /**
     * Set 违规量
注意：此字段可能返回 null，表示取不到有效值。
     * @param EvilCount 违规量
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setEvilCount(Long EvilCount) {
        this.EvilCount = EvilCount;
    }

    /**
     * Get 违规时长
注意：此字段可能返回 null，表示取不到有效值。 
     * @return EvilHour 违规时长
注意：此字段可能返回 null，表示取不到有效值。
     */
    public Long getEvilHour() {
        return this.EvilHour;
    }

    /**
     * Set 违规时长
注意：此字段可能返回 null，表示取不到有效值。
     * @param EvilHour 违规时长
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setEvilHour(Long EvilHour) {
        this.EvilHour = EvilHour;
    }

    /**
     * Get 疑似违规量
注意：此字段可能返回 null，表示取不到有效值。 
     * @return SuspectCount 疑似违规量
注意：此字段可能返回 null，表示取不到有效值。
     */
    public Long getSuspectCount() {
        return this.SuspectCount;
    }

    /**
     * Set 疑似违规量
注意：此字段可能返回 null，表示取不到有效值。
     * @param SuspectCount 疑似违规量
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setSuspectCount(Long SuspectCount) {
        this.SuspectCount = SuspectCount;
    }

    /**
     * Get 疑似违规时长
注意：此字段可能返回 null，表示取不到有效值。 
     * @return SuspectHour 疑似违规时长
注意：此字段可能返回 null，表示取不到有效值。
     */
    public Long getSuspectHour() {
        return this.SuspectHour;
    }

    /**
     * Set 疑似违规时长
注意：此字段可能返回 null，表示取不到有效值。
     * @param SuspectHour 疑似违规时长
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setSuspectHour(Long SuspectHour) {
        this.SuspectHour = SuspectHour;
    }

    /**
     * Get 日期
注意：此字段可能返回 null，表示取不到有效值。 
     * @return Date 日期
注意：此字段可能返回 null，表示取不到有效值。
     */
    public String getDate() {
        return this.Date;
    }

    /**
     * Set 日期
注意：此字段可能返回 null，表示取不到有效值。
     * @param Date 日期
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setDate(String Date) {
        this.Date = Date;
    }

    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "TotalCount", this.TotalCount);
        this.setParamSimple(map, prefix + "TotalHour", this.TotalHour);
        this.setParamSimple(map, prefix + "PassCount", this.PassCount);
        this.setParamSimple(map, prefix + "PassHour", this.PassHour);
        this.setParamSimple(map, prefix + "EvilCount", this.EvilCount);
        this.setParamSimple(map, prefix + "EvilHour", this.EvilHour);
        this.setParamSimple(map, prefix + "SuspectCount", this.SuspectCount);
        this.setParamSimple(map, prefix + "SuspectHour", this.SuspectHour);
        this.setParamSimple(map, prefix + "Date", this.Date);

    }
}

