/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeScanMalwareScheduleResponse extends AbstractModel{

    /**
    * 扫描进度
    */
    @SerializedName("Schedule")
    @Expose
    private Long Schedule;

    /**
    * 风险文件数,当进度满了以后才有该值
    */
    @SerializedName("RiskFileNumber")
    @Expose
    private Long RiskFileNumber;

    /**
    * 是否正在扫描中
    */
    @SerializedName("IsSchedule")
    @Expose
    private Boolean IsSchedule;

    /**
    * 0 从未扫描过、 1 扫描中、 2扫描完成、 3停止中、 4停止完成
    */
    @SerializedName("ScanStatus")
    @Expose
    private Long ScanStatus;

    /**
    * 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get 扫描进度 
     * @return Schedule 扫描进度
     */
    public Long getSchedule() {
        return this.Schedule;
    }

    /**
     * Set 扫描进度
     * @param Schedule 扫描进度
     */
    public void setSchedule(Long Schedule) {
        this.Schedule = Schedule;
    }

    /**
     * Get 风险文件数,当进度满了以后才有该值 
     * @return RiskFileNumber 风险文件数,当进度满了以后才有该值
     */
    public Long getRiskFileNumber() {
        return this.RiskFileNumber;
    }

    /**
     * Set 风险文件数,当进度满了以后才有该值
     * @param RiskFileNumber 风险文件数,当进度满了以后才有该值
     */
    public void setRiskFileNumber(Long RiskFileNumber) {
        this.RiskFileNumber = RiskFileNumber;
    }

    /**
     * Get 是否正在扫描中 
     * @return IsSchedule 是否正在扫描中
     */
    public Boolean getIsSchedule() {
        return this.IsSchedule;
    }

    /**
     * Set 是否正在扫描中
     * @param IsSchedule 是否正在扫描中
     */
    public void setIsSchedule(Boolean IsSchedule) {
        this.IsSchedule = IsSchedule;
    }

    /**
     * Get 0 从未扫描过、 1 扫描中、 2扫描完成、 3停止中、 4停止完成 
     * @return ScanStatus 0 从未扫描过、 1 扫描中、 2扫描完成、 3停止中、 4停止完成
     */
    public Long getScanStatus() {
        return this.ScanStatus;
    }

    /**
     * Set 0 从未扫描过、 1 扫描中、 2扫描完成、 3停止中、 4停止完成
     * @param ScanStatus 0 从未扫描过、 1 扫描中、 2扫描完成、 3停止中、 4停止完成
     */
    public void setScanStatus(Long ScanStatus) {
        this.ScanStatus = ScanStatus;
    }

    /**
     * Get 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。 
     * @return RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     * @param RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeScanMalwareScheduleResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeScanMalwareScheduleResponse(DescribeScanMalwareScheduleResponse source) {
        if (source.Schedule != null) {
            this.Schedule = new Long(source.Schedule);
        }
        if (source.RiskFileNumber != null) {
            this.RiskFileNumber = new Long(source.RiskFileNumber);
        }
        if (source.IsSchedule != null) {
            this.IsSchedule = new Boolean(source.IsSchedule);
        }
        if (source.ScanStatus != null) {
            this.ScanStatus = new Long(source.ScanStatus);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Schedule", this.Schedule);
        this.setParamSimple(map, prefix + "RiskFileNumber", this.RiskFileNumber);
        this.setParamSimple(map, prefix + "IsSchedule", this.IsSchedule);
        this.setParamSimple(map, prefix + "ScanStatus", this.ScanStatus);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

