/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class ModifyMalwareTimingScanSettingsRequest extends AbstractModel{

    /**
    * 检测模式 0 全盘检测  1快速检测
    */
    @SerializedName("CheckPattern")
    @Expose
    private Long CheckPattern;

    /**
    * 检测周期 开始时间，如：02:00:00
    */
    @SerializedName("StartTime")
    @Expose
    private String StartTime;

    /**
    * 检测周期 超时结束时间，如：04:00:00
    */
    @SerializedName("EndTime")
    @Expose
    private String EndTime;

    /**
    * 是否全部服务器 1 全部 2 自选
    */
    @SerializedName("IsGlobal")
    @Expose
    private Long IsGlobal;

    /**
    * 定时检测开关 0 关闭 1开启
    */
    @SerializedName("EnableScan")
    @Expose
    private Long EnableScan;

    /**
    * 监控模式 0 标准 1深度
    */
    @SerializedName("MonitoringPattern")
    @Expose
    private Long MonitoringPattern;

    /**
    * 扫描周期 默认每天 1
    */
    @SerializedName("Cycle")
    @Expose
    private Long Cycle;

    /**
    * 实时监控 0 关闭 1开启
    */
    @SerializedName("RealTimeMonitoring")
    @Expose
    private Long RealTimeMonitoring;

    /**
    * 自选服务器时必须 主机quuid的string数组
    */
    @SerializedName("QuuidList")
    @Expose
    private String [] QuuidList;

    /**
     * Get 检测模式 0 全盘检测  1快速检测 
     * @return CheckPattern 检测模式 0 全盘检测  1快速检测
     */
    public Long getCheckPattern() {
        return this.CheckPattern;
    }

    /**
     * Set 检测模式 0 全盘检测  1快速检测
     * @param CheckPattern 检测模式 0 全盘检测  1快速检测
     */
    public void setCheckPattern(Long CheckPattern) {
        this.CheckPattern = CheckPattern;
    }

    /**
     * Get 检测周期 开始时间，如：02:00:00 
     * @return StartTime 检测周期 开始时间，如：02:00:00
     */
    public String getStartTime() {
        return this.StartTime;
    }

    /**
     * Set 检测周期 开始时间，如：02:00:00
     * @param StartTime 检测周期 开始时间，如：02:00:00
     */
    public void setStartTime(String StartTime) {
        this.StartTime = StartTime;
    }

    /**
     * Get 检测周期 超时结束时间，如：04:00:00 
     * @return EndTime 检测周期 超时结束时间，如：04:00:00
     */
    public String getEndTime() {
        return this.EndTime;
    }

    /**
     * Set 检测周期 超时结束时间，如：04:00:00
     * @param EndTime 检测周期 超时结束时间，如：04:00:00
     */
    public void setEndTime(String EndTime) {
        this.EndTime = EndTime;
    }

    /**
     * Get 是否全部服务器 1 全部 2 自选 
     * @return IsGlobal 是否全部服务器 1 全部 2 自选
     */
    public Long getIsGlobal() {
        return this.IsGlobal;
    }

    /**
     * Set 是否全部服务器 1 全部 2 自选
     * @param IsGlobal 是否全部服务器 1 全部 2 自选
     */
    public void setIsGlobal(Long IsGlobal) {
        this.IsGlobal = IsGlobal;
    }

    /**
     * Get 定时检测开关 0 关闭 1开启 
     * @return EnableScan 定时检测开关 0 关闭 1开启
     */
    public Long getEnableScan() {
        return this.EnableScan;
    }

    /**
     * Set 定时检测开关 0 关闭 1开启
     * @param EnableScan 定时检测开关 0 关闭 1开启
     */
    public void setEnableScan(Long EnableScan) {
        this.EnableScan = EnableScan;
    }

    /**
     * Get 监控模式 0 标准 1深度 
     * @return MonitoringPattern 监控模式 0 标准 1深度
     */
    public Long getMonitoringPattern() {
        return this.MonitoringPattern;
    }

    /**
     * Set 监控模式 0 标准 1深度
     * @param MonitoringPattern 监控模式 0 标准 1深度
     */
    public void setMonitoringPattern(Long MonitoringPattern) {
        this.MonitoringPattern = MonitoringPattern;
    }

    /**
     * Get 扫描周期 默认每天 1 
     * @return Cycle 扫描周期 默认每天 1
     */
    public Long getCycle() {
        return this.Cycle;
    }

    /**
     * Set 扫描周期 默认每天 1
     * @param Cycle 扫描周期 默认每天 1
     */
    public void setCycle(Long Cycle) {
        this.Cycle = Cycle;
    }

    /**
     * Get 实时监控 0 关闭 1开启 
     * @return RealTimeMonitoring 实时监控 0 关闭 1开启
     */
    public Long getRealTimeMonitoring() {
        return this.RealTimeMonitoring;
    }

    /**
     * Set 实时监控 0 关闭 1开启
     * @param RealTimeMonitoring 实时监控 0 关闭 1开启
     */
    public void setRealTimeMonitoring(Long RealTimeMonitoring) {
        this.RealTimeMonitoring = RealTimeMonitoring;
    }

    /**
     * Get 自选服务器时必须 主机quuid的string数组 
     * @return QuuidList 自选服务器时必须 主机quuid的string数组
     */
    public String [] getQuuidList() {
        return this.QuuidList;
    }

    /**
     * Set 自选服务器时必须 主机quuid的string数组
     * @param QuuidList 自选服务器时必须 主机quuid的string数组
     */
    public void setQuuidList(String [] QuuidList) {
        this.QuuidList = QuuidList;
    }

    public ModifyMalwareTimingScanSettingsRequest() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public ModifyMalwareTimingScanSettingsRequest(ModifyMalwareTimingScanSettingsRequest source) {
        if (source.CheckPattern != null) {
            this.CheckPattern = new Long(source.CheckPattern);
        }
        if (source.StartTime != null) {
            this.StartTime = new String(source.StartTime);
        }
        if (source.EndTime != null) {
            this.EndTime = new String(source.EndTime);
        }
        if (source.IsGlobal != null) {
            this.IsGlobal = new Long(source.IsGlobal);
        }
        if (source.EnableScan != null) {
            this.EnableScan = new Long(source.EnableScan);
        }
        if (source.MonitoringPattern != null) {
            this.MonitoringPattern = new Long(source.MonitoringPattern);
        }
        if (source.Cycle != null) {
            this.Cycle = new Long(source.Cycle);
        }
        if (source.RealTimeMonitoring != null) {
            this.RealTimeMonitoring = new Long(source.RealTimeMonitoring);
        }
        if (source.QuuidList != null) {
            this.QuuidList = new String[source.QuuidList.length];
            for (int i = 0; i < source.QuuidList.length; i++) {
                this.QuuidList[i] = new String(source.QuuidList[i]);
            }
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "CheckPattern", this.CheckPattern);
        this.setParamSimple(map, prefix + "StartTime", this.StartTime);
        this.setParamSimple(map, prefix + "EndTime", this.EndTime);
        this.setParamSimple(map, prefix + "IsGlobal", this.IsGlobal);
        this.setParamSimple(map, prefix + "EnableScan", this.EnableScan);
        this.setParamSimple(map, prefix + "MonitoringPattern", this.MonitoringPattern);
        this.setParamSimple(map, prefix + "Cycle", this.Cycle);
        this.setParamSimple(map, prefix + "RealTimeMonitoring", this.RealTimeMonitoring);
        this.setParamArraySimple(map, prefix + "QuuidList.", this.QuuidList);

    }
}

