/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.mongodb.v20190725.models;

import com.tencentcloudapi.common.AbstractModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class CreateBackupDownloadTaskRequest extends AbstractModel{

    /**
    * 实例ID，格式如：cmgo-p8vnipr5。与云数据库控制台页面中显示的实例ID相同
    */
    @SerializedName("InstanceId")
    @Expose
    private String InstanceId;

    /**
    * 要下载的备份文件名，可通过DescribeDBBackups接口获取
    */
    @SerializedName("BackupName")
    @Expose
    private String BackupName;

    /**
    * 下载备份的分片列表
    */
    @SerializedName("BackupSets")
    @Expose
    private ReplicaSetInfo [] BackupSets;

    /**
     * Get 实例ID，格式如：cmgo-p8vnipr5。与云数据库控制台页面中显示的实例ID相同 
     * @return InstanceId 实例ID，格式如：cmgo-p8vnipr5。与云数据库控制台页面中显示的实例ID相同
     */
    public String getInstanceId() {
        return this.InstanceId;
    }

    /**
     * Set 实例ID，格式如：cmgo-p8vnipr5。与云数据库控制台页面中显示的实例ID相同
     * @param InstanceId 实例ID，格式如：cmgo-p8vnipr5。与云数据库控制台页面中显示的实例ID相同
     */
    public void setInstanceId(String InstanceId) {
        this.InstanceId = InstanceId;
    }

    /**
     * Get 要下载的备份文件名，可通过DescribeDBBackups接口获取 
     * @return BackupName 要下载的备份文件名，可通过DescribeDBBackups接口获取
     */
    public String getBackupName() {
        return this.BackupName;
    }

    /**
     * Set 要下载的备份文件名，可通过DescribeDBBackups接口获取
     * @param BackupName 要下载的备份文件名，可通过DescribeDBBackups接口获取
     */
    public void setBackupName(String BackupName) {
        this.BackupName = BackupName;
    }

    /**
     * Get 下载备份的分片列表 
     * @return BackupSets 下载备份的分片列表
     */
    public ReplicaSetInfo [] getBackupSets() {
        return this.BackupSets;
    }

    /**
     * Set 下载备份的分片列表
     * @param BackupSets 下载备份的分片列表
     */
    public void setBackupSets(ReplicaSetInfo [] BackupSets) {
        this.BackupSets = BackupSets;
    }

    public CreateBackupDownloadTaskRequest() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public CreateBackupDownloadTaskRequest(CreateBackupDownloadTaskRequest source) {
        if (source.InstanceId != null) {
            this.InstanceId = new String(source.InstanceId);
        }
        if (source.BackupName != null) {
            this.BackupName = new String(source.BackupName);
        }
        if (source.BackupSets != null) {
            this.BackupSets = new ReplicaSetInfo[source.BackupSets.length];
            for (int i = 0; i < source.BackupSets.length; i++) {
                this.BackupSets[i] = new ReplicaSetInfo(source.BackupSets[i]);
            }
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "InstanceId", this.InstanceId);
        this.setParamSimple(map, prefix + "BackupName", this.BackupName);
        this.setParamArrayObj(map, prefix + "BackupSets.", this.BackupSets);

    }
}

