/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.ckafka.v20190819.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeRegionRequest extends AbstractModel {

    /**
    * 偏移量
    */
    @SerializedName("Offset")
    @Expose
    private Long Offset;

    /**
    * 返回最大结果数
    */
    @SerializedName("Limit")
    @Expose
    private Long Limit;

    /**
    * 业务字段，可忽略
    */
    @SerializedName("Business")
    @Expose
    private String Business;

    /**
    * cdc专有集群业务字段，可忽略
    */
    @SerializedName("CdcId")
    @Expose
    private String CdcId;

    /**
     * Get 偏移量 
     * @return Offset 偏移量
     */
    public Long getOffset() {
        return this.Offset;
    }

    /**
     * Set 偏移量
     * @param Offset 偏移量
     */
    public void setOffset(Long Offset) {
        this.Offset = Offset;
    }

    /**
     * Get 返回最大结果数 
     * @return Limit 返回最大结果数
     */
    public Long getLimit() {
        return this.Limit;
    }

    /**
     * Set 返回最大结果数
     * @param Limit 返回最大结果数
     */
    public void setLimit(Long Limit) {
        this.Limit = Limit;
    }

    /**
     * Get 业务字段，可忽略 
     * @return Business 业务字段，可忽略
     */
    public String getBusiness() {
        return this.Business;
    }

    /**
     * Set 业务字段，可忽略
     * @param Business 业务字段，可忽略
     */
    public void setBusiness(String Business) {
        this.Business = Business;
    }

    /**
     * Get cdc专有集群业务字段，可忽略 
     * @return CdcId cdc专有集群业务字段，可忽略
     */
    public String getCdcId() {
        return this.CdcId;
    }

    /**
     * Set cdc专有集群业务字段，可忽略
     * @param CdcId cdc专有集群业务字段，可忽略
     */
    public void setCdcId(String CdcId) {
        this.CdcId = CdcId;
    }

    public DescribeRegionRequest() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeRegionRequest(DescribeRegionRequest source) {
        if (source.Offset != null) {
            this.Offset = new Long(source.Offset);
        }
        if (source.Limit != null) {
            this.Limit = new Long(source.Limit);
        }
        if (source.Business != null) {
            this.Business = new String(source.Business);
        }
        if (source.CdcId != null) {
            this.CdcId = new String(source.CdcId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Offset", this.Offset);
        this.setParamSimple(map, prefix + "Limit", this.Limit);
        this.setParamSimple(map, prefix + "Business", this.Business);
        this.setParamSimple(map, prefix + "CdcId", this.CdcId);

    }
}

