/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class MalWareList extends AbstractModel {

    /**
    * 服务器ip
    */
    @SerializedName("HostIp")
    @Expose
    private String HostIp;

    /**
    * 唯一UUID
    */
    @SerializedName("Uuid")
    @Expose
    private String Uuid;

    /**
    * 路径
    */
    @SerializedName("FilePath")
    @Expose
    private String FilePath;

    /**
    * 描述
    */
    @SerializedName("VirusName")
    @Expose
    private String VirusName;

    /**
    * 状态；4-:待处理，5-已信任，6-已隔离，8-文件已删除, 14:已处理
    */
    @SerializedName("Status")
    @Expose
    private Long Status;

    /**
    * 唯一ID
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("Id")
    @Expose
    private Long Id;

    /**
    * 主机别名
    */
    @SerializedName("Alias")
    @Expose
    private String Alias;

    /**
    * 特性标签，已废弃字段，不会再返回标签，详情中才会返回标签信息
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("Tags")
    @Expose
    private String [] Tags;

    /**
    * 首次运行时间
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("FileCreateTime")
    @Expose
    private String FileCreateTime;

    /**
    * 最近运行时间
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("FileModifierTime")
    @Expose
    private String FileModifierTime;

    /**
    * 创建时间
    */
    @SerializedName("CreateTime")
    @Expose
    private String CreateTime;

    /**
    * 最近扫描时间
    */
    @SerializedName("LatestScanTime")
    @Expose
    private String LatestScanTime;

    /**
    * 风险等级 0未知、1低、2中、3高、4严重
    */
    @SerializedName("Level")
    @Expose
    private Long Level;

    /**
    * '木马检测平台用,分割 1云查杀引擎、2TAV、3binaryAi、4异常行为、5威胁情报
    */
    @SerializedName("CheckPlatform")
    @Expose
    private String CheckPlatform;

    /**
    * 木马进程是否存在 0:不存在，1:存在
    */
    @SerializedName("ProcessExists")
    @Expose
    private Long ProcessExists;

    /**
    * 木马文件是否存在 0:不存在，1:存在
    */
    @SerializedName("FileExists")
    @Expose
    private Long FileExists;

    /**
    * cvm quuid
    */
    @SerializedName("Quuid")
    @Expose
    private String Quuid;

    /**
    * 木马样本md5
    */
    @SerializedName("MD5")
    @Expose
    private String MD5;

    /**
    * 附加信息
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("MachineExtraInfo")
    @Expose
    private MachineExtraInfo MachineExtraInfo;

    /**
     * Get 服务器ip 
     * @return HostIp 服务器ip
     */
    public String getHostIp() {
        return this.HostIp;
    }

    /**
     * Set 服务器ip
     * @param HostIp 服务器ip
     */
    public void setHostIp(String HostIp) {
        this.HostIp = HostIp;
    }

    /**
     * Get 唯一UUID 
     * @return Uuid 唯一UUID
     */
    public String getUuid() {
        return this.Uuid;
    }

    /**
     * Set 唯一UUID
     * @param Uuid 唯一UUID
     */
    public void setUuid(String Uuid) {
        this.Uuid = Uuid;
    }

    /**
     * Get 路径 
     * @return FilePath 路径
     */
    public String getFilePath() {
        return this.FilePath;
    }

    /**
     * Set 路径
     * @param FilePath 路径
     */
    public void setFilePath(String FilePath) {
        this.FilePath = FilePath;
    }

    /**
     * Get 描述 
     * @return VirusName 描述
     */
    public String getVirusName() {
        return this.VirusName;
    }

    /**
     * Set 描述
     * @param VirusName 描述
     */
    public void setVirusName(String VirusName) {
        this.VirusName = VirusName;
    }

    /**
     * Get 状态；4-:待处理，5-已信任，6-已隔离，8-文件已删除, 14:已处理 
     * @return Status 状态；4-:待处理，5-已信任，6-已隔离，8-文件已删除, 14:已处理
     */
    public Long getStatus() {
        return this.Status;
    }

    /**
     * Set 状态；4-:待处理，5-已信任，6-已隔离，8-文件已删除, 14:已处理
     * @param Status 状态；4-:待处理，5-已信任，6-已隔离，8-文件已删除, 14:已处理
     */
    public void setStatus(Long Status) {
        this.Status = Status;
    }

    /**
     * Get 唯一ID
注意：此字段可能返回 null，表示取不到有效值。 
     * @return Id 唯一ID
注意：此字段可能返回 null，表示取不到有效值。
     */
    public Long getId() {
        return this.Id;
    }

    /**
     * Set 唯一ID
注意：此字段可能返回 null，表示取不到有效值。
     * @param Id 唯一ID
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setId(Long Id) {
        this.Id = Id;
    }

    /**
     * Get 主机别名 
     * @return Alias 主机别名
     */
    public String getAlias() {
        return this.Alias;
    }

    /**
     * Set 主机别名
     * @param Alias 主机别名
     */
    public void setAlias(String Alias) {
        this.Alias = Alias;
    }

    /**
     * Get 特性标签，已废弃字段，不会再返回标签，详情中才会返回标签信息
注意：此字段可能返回 null，表示取不到有效值。 
     * @return Tags 特性标签，已废弃字段，不会再返回标签，详情中才会返回标签信息
注意：此字段可能返回 null，表示取不到有效值。
     */
    public String [] getTags() {
        return this.Tags;
    }

    /**
     * Set 特性标签，已废弃字段，不会再返回标签，详情中才会返回标签信息
注意：此字段可能返回 null，表示取不到有效值。
     * @param Tags 特性标签，已废弃字段，不会再返回标签，详情中才会返回标签信息
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setTags(String [] Tags) {
        this.Tags = Tags;
    }

    /**
     * Get 首次运行时间
注意：此字段可能返回 null，表示取不到有效值。 
     * @return FileCreateTime 首次运行时间
注意：此字段可能返回 null，表示取不到有效值。
     */
    public String getFileCreateTime() {
        return this.FileCreateTime;
    }

    /**
     * Set 首次运行时间
注意：此字段可能返回 null，表示取不到有效值。
     * @param FileCreateTime 首次运行时间
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setFileCreateTime(String FileCreateTime) {
        this.FileCreateTime = FileCreateTime;
    }

    /**
     * Get 最近运行时间
注意：此字段可能返回 null，表示取不到有效值。 
     * @return FileModifierTime 最近运行时间
注意：此字段可能返回 null，表示取不到有效值。
     */
    public String getFileModifierTime() {
        return this.FileModifierTime;
    }

    /**
     * Set 最近运行时间
注意：此字段可能返回 null，表示取不到有效值。
     * @param FileModifierTime 最近运行时间
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setFileModifierTime(String FileModifierTime) {
        this.FileModifierTime = FileModifierTime;
    }

    /**
     * Get 创建时间 
     * @return CreateTime 创建时间
     */
    public String getCreateTime() {
        return this.CreateTime;
    }

    /**
     * Set 创建时间
     * @param CreateTime 创建时间
     */
    public void setCreateTime(String CreateTime) {
        this.CreateTime = CreateTime;
    }

    /**
     * Get 最近扫描时间 
     * @return LatestScanTime 最近扫描时间
     */
    public String getLatestScanTime() {
        return this.LatestScanTime;
    }

    /**
     * Set 最近扫描时间
     * @param LatestScanTime 最近扫描时间
     */
    public void setLatestScanTime(String LatestScanTime) {
        this.LatestScanTime = LatestScanTime;
    }

    /**
     * Get 风险等级 0未知、1低、2中、3高、4严重 
     * @return Level 风险等级 0未知、1低、2中、3高、4严重
     */
    public Long getLevel() {
        return this.Level;
    }

    /**
     * Set 风险等级 0未知、1低、2中、3高、4严重
     * @param Level 风险等级 0未知、1低、2中、3高、4严重
     */
    public void setLevel(Long Level) {
        this.Level = Level;
    }

    /**
     * Get '木马检测平台用,分割 1云查杀引擎、2TAV、3binaryAi、4异常行为、5威胁情报 
     * @return CheckPlatform '木马检测平台用,分割 1云查杀引擎、2TAV、3binaryAi、4异常行为、5威胁情报
     */
    public String getCheckPlatform() {
        return this.CheckPlatform;
    }

    /**
     * Set '木马检测平台用,分割 1云查杀引擎、2TAV、3binaryAi、4异常行为、5威胁情报
     * @param CheckPlatform '木马检测平台用,分割 1云查杀引擎、2TAV、3binaryAi、4异常行为、5威胁情报
     */
    public void setCheckPlatform(String CheckPlatform) {
        this.CheckPlatform = CheckPlatform;
    }

    /**
     * Get 木马进程是否存在 0:不存在，1:存在 
     * @return ProcessExists 木马进程是否存在 0:不存在，1:存在
     */
    public Long getProcessExists() {
        return this.ProcessExists;
    }

    /**
     * Set 木马进程是否存在 0:不存在，1:存在
     * @param ProcessExists 木马进程是否存在 0:不存在，1:存在
     */
    public void setProcessExists(Long ProcessExists) {
        this.ProcessExists = ProcessExists;
    }

    /**
     * Get 木马文件是否存在 0:不存在，1:存在 
     * @return FileExists 木马文件是否存在 0:不存在，1:存在
     */
    public Long getFileExists() {
        return this.FileExists;
    }

    /**
     * Set 木马文件是否存在 0:不存在，1:存在
     * @param FileExists 木马文件是否存在 0:不存在，1:存在
     */
    public void setFileExists(Long FileExists) {
        this.FileExists = FileExists;
    }

    /**
     * Get cvm quuid 
     * @return Quuid cvm quuid
     */
    public String getQuuid() {
        return this.Quuid;
    }

    /**
     * Set cvm quuid
     * @param Quuid cvm quuid
     */
    public void setQuuid(String Quuid) {
        this.Quuid = Quuid;
    }

    /**
     * Get 木马样本md5 
     * @return MD5 木马样本md5
     */
    public String getMD5() {
        return this.MD5;
    }

    /**
     * Set 木马样本md5
     * @param MD5 木马样本md5
     */
    public void setMD5(String MD5) {
        this.MD5 = MD5;
    }

    /**
     * Get 附加信息
注意：此字段可能返回 null，表示取不到有效值。 
     * @return MachineExtraInfo 附加信息
注意：此字段可能返回 null，表示取不到有效值。
     */
    public MachineExtraInfo getMachineExtraInfo() {
        return this.MachineExtraInfo;
    }

    /**
     * Set 附加信息
注意：此字段可能返回 null，表示取不到有效值。
     * @param MachineExtraInfo 附加信息
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setMachineExtraInfo(MachineExtraInfo MachineExtraInfo) {
        this.MachineExtraInfo = MachineExtraInfo;
    }

    public MalWareList() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public MalWareList(MalWareList source) {
        if (source.HostIp != null) {
            this.HostIp = new String(source.HostIp);
        }
        if (source.Uuid != null) {
            this.Uuid = new String(source.Uuid);
        }
        if (source.FilePath != null) {
            this.FilePath = new String(source.FilePath);
        }
        if (source.VirusName != null) {
            this.VirusName = new String(source.VirusName);
        }
        if (source.Status != null) {
            this.Status = new Long(source.Status);
        }
        if (source.Id != null) {
            this.Id = new Long(source.Id);
        }
        if (source.Alias != null) {
            this.Alias = new String(source.Alias);
        }
        if (source.Tags != null) {
            this.Tags = new String[source.Tags.length];
            for (int i = 0; i < source.Tags.length; i++) {
                this.Tags[i] = new String(source.Tags[i]);
            }
        }
        if (source.FileCreateTime != null) {
            this.FileCreateTime = new String(source.FileCreateTime);
        }
        if (source.FileModifierTime != null) {
            this.FileModifierTime = new String(source.FileModifierTime);
        }
        if (source.CreateTime != null) {
            this.CreateTime = new String(source.CreateTime);
        }
        if (source.LatestScanTime != null) {
            this.LatestScanTime = new String(source.LatestScanTime);
        }
        if (source.Level != null) {
            this.Level = new Long(source.Level);
        }
        if (source.CheckPlatform != null) {
            this.CheckPlatform = new String(source.CheckPlatform);
        }
        if (source.ProcessExists != null) {
            this.ProcessExists = new Long(source.ProcessExists);
        }
        if (source.FileExists != null) {
            this.FileExists = new Long(source.FileExists);
        }
        if (source.Quuid != null) {
            this.Quuid = new String(source.Quuid);
        }
        if (source.MD5 != null) {
            this.MD5 = new String(source.MD5);
        }
        if (source.MachineExtraInfo != null) {
            this.MachineExtraInfo = new MachineExtraInfo(source.MachineExtraInfo);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "HostIp", this.HostIp);
        this.setParamSimple(map, prefix + "Uuid", this.Uuid);
        this.setParamSimple(map, prefix + "FilePath", this.FilePath);
        this.setParamSimple(map, prefix + "VirusName", this.VirusName);
        this.setParamSimple(map, prefix + "Status", this.Status);
        this.setParamSimple(map, prefix + "Id", this.Id);
        this.setParamSimple(map, prefix + "Alias", this.Alias);
        this.setParamArraySimple(map, prefix + "Tags.", this.Tags);
        this.setParamSimple(map, prefix + "FileCreateTime", this.FileCreateTime);
        this.setParamSimple(map, prefix + "FileModifierTime", this.FileModifierTime);
        this.setParamSimple(map, prefix + "CreateTime", this.CreateTime);
        this.setParamSimple(map, prefix + "LatestScanTime", this.LatestScanTime);
        this.setParamSimple(map, prefix + "Level", this.Level);
        this.setParamSimple(map, prefix + "CheckPlatform", this.CheckPlatform);
        this.setParamSimple(map, prefix + "ProcessExists", this.ProcessExists);
        this.setParamSimple(map, prefix + "FileExists", this.FileExists);
        this.setParamSimple(map, prefix + "Quuid", this.Quuid);
        this.setParamSimple(map, prefix + "MD5", this.MD5);
        this.setParamObj(map, prefix + "MachineExtraInfo.", this.MachineExtraInfo);

    }
}

