/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.dsgc.v20190723.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class GetTrialVersionResponse extends AbstractModel {

    /**
    * 体验版本名称。
    */
    @SerializedName("TrialVersion")
    @Expose
    private String TrialVersion;

    /**
    * 版本体验结束时间戳。
    */
    @SerializedName("TrialEndAt")
    @Expose
    private Long TrialEndAt;

    /**
    * 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get 体验版本名称。 
     * @return TrialVersion 体验版本名称。
     */
    public String getTrialVersion() {
        return this.TrialVersion;
    }

    /**
     * Set 体验版本名称。
     * @param TrialVersion 体验版本名称。
     */
    public void setTrialVersion(String TrialVersion) {
        this.TrialVersion = TrialVersion;
    }

    /**
     * Get 版本体验结束时间戳。 
     * @return TrialEndAt 版本体验结束时间戳。
     */
    public Long getTrialEndAt() {
        return this.TrialEndAt;
    }

    /**
     * Set 版本体验结束时间戳。
     * @param TrialEndAt 版本体验结束时间戳。
     */
    public void setTrialEndAt(Long TrialEndAt) {
        this.TrialEndAt = TrialEndAt;
    }

    /**
     * Get 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。 
     * @return RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     * @param RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public GetTrialVersionResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public GetTrialVersionResponse(GetTrialVersionResponse source) {
        if (source.TrialVersion != null) {
            this.TrialVersion = new String(source.TrialVersion);
        }
        if (source.TrialEndAt != null) {
            this.TrialEndAt = new Long(source.TrialEndAt);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "TrialVersion", this.TrialVersion);
        this.setParamSimple(map, prefix + "TrialEndAt", this.TrialEndAt);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

