/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.ess.v20201111.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class FailedCreateStaffData extends AbstractModel {

    /**
    * 员工名
    */
    @SerializedName("DisplayName")
    @Expose
    private String DisplayName;

    /**
    * 员工手机号
    */
    @SerializedName("Mobile")
    @Expose
    private String Mobile;

    /**
    * 传入的企微账号id
    */
    @SerializedName("WeworkOpenId")
    @Expose
    private String WeworkOpenId;

    /**
    * 失败原因
    */
    @SerializedName("Reason")
    @Expose
    private String Reason;

    /**
     * Get 员工名 
     * @return DisplayName 员工名
     */
    public String getDisplayName() {
        return this.DisplayName;
    }

    /**
     * Set 员工名
     * @param DisplayName 员工名
     */
    public void setDisplayName(String DisplayName) {
        this.DisplayName = DisplayName;
    }

    /**
     * Get 员工手机号 
     * @return Mobile 员工手机号
     */
    public String getMobile() {
        return this.Mobile;
    }

    /**
     * Set 员工手机号
     * @param Mobile 员工手机号
     */
    public void setMobile(String Mobile) {
        this.Mobile = Mobile;
    }

    /**
     * Get 传入的企微账号id 
     * @return WeworkOpenId 传入的企微账号id
     */
    public String getWeworkOpenId() {
        return this.WeworkOpenId;
    }

    /**
     * Set 传入的企微账号id
     * @param WeworkOpenId 传入的企微账号id
     */
    public void setWeworkOpenId(String WeworkOpenId) {
        this.WeworkOpenId = WeworkOpenId;
    }

    /**
     * Get 失败原因 
     * @return Reason 失败原因
     */
    public String getReason() {
        return this.Reason;
    }

    /**
     * Set 失败原因
     * @param Reason 失败原因
     */
    public void setReason(String Reason) {
        this.Reason = Reason;
    }

    public FailedCreateStaffData() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public FailedCreateStaffData(FailedCreateStaffData source) {
        if (source.DisplayName != null) {
            this.DisplayName = new String(source.DisplayName);
        }
        if (source.Mobile != null) {
            this.Mobile = new String(source.Mobile);
        }
        if (source.WeworkOpenId != null) {
            this.WeworkOpenId = new String(source.WeworkOpenId);
        }
        if (source.Reason != null) {
            this.Reason = new String(source.Reason);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "DisplayName", this.DisplayName);
        this.setParamSimple(map, prefix + "Mobile", this.Mobile);
        this.setParamSimple(map, prefix + "WeworkOpenId", this.WeworkOpenId);
        this.setParamSimple(map, prefix + "Reason", this.Reason);

    }
}

