/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.essbasic.v20210526.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class ChannelVerifyPdfResponse extends AbstractModel {

    /**
    * 验签结果代码，代码的含义如下：

<ul><li>**1**：文件未被篡改，全部签名在腾讯电子签完成。</li>
<li>**2**：文件未被篡改，部分签名在腾讯电子签完成。</li>
<li>**3**：文件被篡改。</li>
<li>**4**：异常：文件内没有签名域。(如果合同还没有签署也会返回此代码)</li>
<li>**5**：异常：文件签名格式错误。</li></ul>
    */
    @SerializedName("VerifyResult")
    @Expose
    private Long VerifyResult;

    /**
    * 验签结果详情，所有签署区(包括签名区, 印章区, 日期签署区,骑缝章等)的签署验签结果
    */
    @SerializedName("PdfVerifyResults")
    @Expose
    private PdfVerifyResult [] PdfVerifyResults;

    /**
    * 验签序列号, 为11为数组组成的字符串
    */
    @SerializedName("VerifySerialNo")
    @Expose
    private String VerifySerialNo;

    /**
    * 合同文件MD5哈希值
    */
    @SerializedName("PdfResourceMd5")
    @Expose
    private String PdfResourceMd5;

    /**
    * 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get 验签结果代码，代码的含义如下：

<ul><li>**1**：文件未被篡改，全部签名在腾讯电子签完成。</li>
<li>**2**：文件未被篡改，部分签名在腾讯电子签完成。</li>
<li>**3**：文件被篡改。</li>
<li>**4**：异常：文件内没有签名域。(如果合同还没有签署也会返回此代码)</li>
<li>**5**：异常：文件签名格式错误。</li></ul> 
     * @return VerifyResult 验签结果代码，代码的含义如下：

<ul><li>**1**：文件未被篡改，全部签名在腾讯电子签完成。</li>
<li>**2**：文件未被篡改，部分签名在腾讯电子签完成。</li>
<li>**3**：文件被篡改。</li>
<li>**4**：异常：文件内没有签名域。(如果合同还没有签署也会返回此代码)</li>
<li>**5**：异常：文件签名格式错误。</li></ul>
     */
    public Long getVerifyResult() {
        return this.VerifyResult;
    }

    /**
     * Set 验签结果代码，代码的含义如下：

<ul><li>**1**：文件未被篡改，全部签名在腾讯电子签完成。</li>
<li>**2**：文件未被篡改，部分签名在腾讯电子签完成。</li>
<li>**3**：文件被篡改。</li>
<li>**4**：异常：文件内没有签名域。(如果合同还没有签署也会返回此代码)</li>
<li>**5**：异常：文件签名格式错误。</li></ul>
     * @param VerifyResult 验签结果代码，代码的含义如下：

<ul><li>**1**：文件未被篡改，全部签名在腾讯电子签完成。</li>
<li>**2**：文件未被篡改，部分签名在腾讯电子签完成。</li>
<li>**3**：文件被篡改。</li>
<li>**4**：异常：文件内没有签名域。(如果合同还没有签署也会返回此代码)</li>
<li>**5**：异常：文件签名格式错误。</li></ul>
     */
    public void setVerifyResult(Long VerifyResult) {
        this.VerifyResult = VerifyResult;
    }

    /**
     * Get 验签结果详情，所有签署区(包括签名区, 印章区, 日期签署区,骑缝章等)的签署验签结果 
     * @return PdfVerifyResults 验签结果详情，所有签署区(包括签名区, 印章区, 日期签署区,骑缝章等)的签署验签结果
     */
    public PdfVerifyResult [] getPdfVerifyResults() {
        return this.PdfVerifyResults;
    }

    /**
     * Set 验签结果详情，所有签署区(包括签名区, 印章区, 日期签署区,骑缝章等)的签署验签结果
     * @param PdfVerifyResults 验签结果详情，所有签署区(包括签名区, 印章区, 日期签署区,骑缝章等)的签署验签结果
     */
    public void setPdfVerifyResults(PdfVerifyResult [] PdfVerifyResults) {
        this.PdfVerifyResults = PdfVerifyResults;
    }

    /**
     * Get 验签序列号, 为11为数组组成的字符串 
     * @return VerifySerialNo 验签序列号, 为11为数组组成的字符串
     */
    public String getVerifySerialNo() {
        return this.VerifySerialNo;
    }

    /**
     * Set 验签序列号, 为11为数组组成的字符串
     * @param VerifySerialNo 验签序列号, 为11为数组组成的字符串
     */
    public void setVerifySerialNo(String VerifySerialNo) {
        this.VerifySerialNo = VerifySerialNo;
    }

    /**
     * Get 合同文件MD5哈希值 
     * @return PdfResourceMd5 合同文件MD5哈希值
     */
    public String getPdfResourceMd5() {
        return this.PdfResourceMd5;
    }

    /**
     * Set 合同文件MD5哈希值
     * @param PdfResourceMd5 合同文件MD5哈希值
     */
    public void setPdfResourceMd5(String PdfResourceMd5) {
        this.PdfResourceMd5 = PdfResourceMd5;
    }

    /**
     * Get 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。 
     * @return RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     * @param RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public ChannelVerifyPdfResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public ChannelVerifyPdfResponse(ChannelVerifyPdfResponse source) {
        if (source.VerifyResult != null) {
            this.VerifyResult = new Long(source.VerifyResult);
        }
        if (source.PdfVerifyResults != null) {
            this.PdfVerifyResults = new PdfVerifyResult[source.PdfVerifyResults.length];
            for (int i = 0; i < source.PdfVerifyResults.length; i++) {
                this.PdfVerifyResults[i] = new PdfVerifyResult(source.PdfVerifyResults[i]);
            }
        }
        if (source.VerifySerialNo != null) {
            this.VerifySerialNo = new String(source.VerifySerialNo);
        }
        if (source.PdfResourceMd5 != null) {
            this.PdfResourceMd5 = new String(source.PdfResourceMd5);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "VerifyResult", this.VerifyResult);
        this.setParamArrayObj(map, prefix + "PdfVerifyResults.", this.PdfVerifyResults);
        this.setParamSimple(map, prefix + "VerifySerialNo", this.VerifySerialNo);
        this.setParamSimple(map, prefix + "PdfResourceMd5", this.PdfResourceMd5);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

