/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.ioa.v20220601.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeDevicesPageRsp extends AbstractModel {

    /**
    * 数据分页信息
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("Paging")
    @Expose
    private Paging Paging;

    /**
    * 业务响应数据
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("Items")
    @Expose
    private DeviceDetail [] Items;

    /**
     * Get 数据分页信息
注意：此字段可能返回 null，表示取不到有效值。 
     * @return Paging 数据分页信息
注意：此字段可能返回 null，表示取不到有效值。
     */
    public Paging getPaging() {
        return this.Paging;
    }

    /**
     * Set 数据分页信息
注意：此字段可能返回 null，表示取不到有效值。
     * @param Paging 数据分页信息
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setPaging(Paging Paging) {
        this.Paging = Paging;
    }

    /**
     * Get 业务响应数据
注意：此字段可能返回 null，表示取不到有效值。 
     * @return Items 业务响应数据
注意：此字段可能返回 null，表示取不到有效值。
     */
    public DeviceDetail [] getItems() {
        return this.Items;
    }

    /**
     * Set 业务响应数据
注意：此字段可能返回 null，表示取不到有效值。
     * @param Items 业务响应数据
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setItems(DeviceDetail [] Items) {
        this.Items = Items;
    }

    public DescribeDevicesPageRsp() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeDevicesPageRsp(DescribeDevicesPageRsp source) {
        if (source.Paging != null) {
            this.Paging = new Paging(source.Paging);
        }
        if (source.Items != null) {
            this.Items = new DeviceDetail[source.Items.length];
            for (int i = 0; i < source.Items.length; i++) {
                this.Items[i] = new DeviceDetail(source.Items[i]);
            }
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamObj(map, prefix + "Paging.", this.Paging);
        this.setParamArrayObj(map, prefix + "Items.", this.Items);

    }
}

