/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.tdid.v20210519.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class VerifyCredentialRequest extends AbstractModel {

    /**
    * 参数集合
    */
    @SerializedName("FunctionArg")
    @Expose
    private VerifyFunctionArg FunctionArg;

    /**
     * Get 参数集合 
     * @return FunctionArg 参数集合
     */
    public VerifyFunctionArg getFunctionArg() {
        return this.FunctionArg;
    }

    /**
     * Set 参数集合
     * @param FunctionArg 参数集合
     */
    public void setFunctionArg(VerifyFunctionArg FunctionArg) {
        this.FunctionArg = FunctionArg;
    }

    public VerifyCredentialRequest() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public VerifyCredentialRequest(VerifyCredentialRequest source) {
        if (source.FunctionArg != null) {
            this.FunctionArg = new VerifyFunctionArg(source.FunctionArg);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamObj(map, prefix + "FunctionArg.", this.FunctionArg);

    }
}

