/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.redis.v20180412.models;

import com.tencentcloudapi.common.AbstractModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class UpgradeInstanceVersionRequest extends AbstractModel{

    /**
    * 目标实例类型，同CreateInstances接口的Type，即实例要变更的目标类型
    */
    @SerializedName("TargetInstanceType")
    @Expose
    private String TargetInstanceType;

    /**
    * 切换模式：1-维护时间窗切换，2-立即切换
    */
    @SerializedName("SwitchOption")
    @Expose
    private Long SwitchOption;

    /**
    * 实例ID
    */
    @SerializedName("InstanceId")
    @Expose
    private String InstanceId;

    /**
     * Get 目标实例类型，同CreateInstances接口的Type，即实例要变更的目标类型 
     * @return TargetInstanceType 目标实例类型，同CreateInstances接口的Type，即实例要变更的目标类型
     */
    public String getTargetInstanceType() {
        return this.TargetInstanceType;
    }

    /**
     * Set 目标实例类型，同CreateInstances接口的Type，即实例要变更的目标类型
     * @param TargetInstanceType 目标实例类型，同CreateInstances接口的Type，即实例要变更的目标类型
     */
    public void setTargetInstanceType(String TargetInstanceType) {
        this.TargetInstanceType = TargetInstanceType;
    }

    /**
     * Get 切换模式：1-维护时间窗切换，2-立即切换 
     * @return SwitchOption 切换模式：1-维护时间窗切换，2-立即切换
     */
    public Long getSwitchOption() {
        return this.SwitchOption;
    }

    /**
     * Set 切换模式：1-维护时间窗切换，2-立即切换
     * @param SwitchOption 切换模式：1-维护时间窗切换，2-立即切换
     */
    public void setSwitchOption(Long SwitchOption) {
        this.SwitchOption = SwitchOption;
    }

    /**
     * Get 实例ID 
     * @return InstanceId 实例ID
     */
    public String getInstanceId() {
        return this.InstanceId;
    }

    /**
     * Set 实例ID
     * @param InstanceId 实例ID
     */
    public void setInstanceId(String InstanceId) {
        this.InstanceId = InstanceId;
    }

    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "TargetInstanceType", this.TargetInstanceType);
        this.setParamSimple(map, prefix + "SwitchOption", this.SwitchOption);
        this.setParamSimple(map, prefix + "InstanceId", this.InstanceId);

    }
}

