/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloudapi.common;

import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

class Log
implements Interceptor {
    private boolean debug;
    private Logger logger = null;

    public Log(String name) {
        this(name, false);
    }

    public Log(String name, boolean isDebug) {
        this.logger = Logger.getLogger((String)name);
        if (isDebug) {
            File file = new File("log4j.properties");
            if (!file.exists()) {
                this.debug = false;
                BasicConfigurator.configure();
                this.logger.warn((Object)"The configuration file of log4j does not exist, please refer to tencentcloud-sdk-java/log4j.properties for configuration.");
            } else {
                this.debug = isDebug;
                PropertyConfigurator.configure((String)"log4j.properties");
            }
        }
    }

    public void info(String str) {
        if (this.debug) {
            this.logger.info((Object)str);
        }
    }

    public void info(String str, Throwable t) {
        if (this.debug) {
            this.logger.info((Object)str, t);
        }
    }

    public void debug(String str) {
        if (this.debug) {
            this.logger.debug((Object)str);
        }
    }

    public void debug(String str, Throwable t) {
        if (this.debug) {
            this.logger.debug((Object)str, t);
        }
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        String req = "send request, request url: " + request.urlString() + ". request headers information: " + request.headers().toString();
        req = req.replaceAll("\n", ";");
        this.debug(req);
        Response response = chain.proceed(request);
        String resp = "recieve response, response url: " + response.request().urlString() + ", response headers: " + response.headers().toString() + ",response body information: " + response.body().toString();
        resp = resp.replaceAll("\n", ";");
        this.debug(resp);
        return response;
    }
}

