/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.yunjing.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class WeeklyReportMalware extends AbstractModel{

    /**
    * 主机IP。
    */
    @SerializedName("MachineIp")
    @Expose
    private String MachineIp;

    /**
    * 木马文件路径。
    */
    @SerializedName("FilePath")
    @Expose
    private String FilePath;

    /**
    * 木马文件MD5值。
    */
    @SerializedName("Md5")
    @Expose
    private String Md5;

    /**
    * 木马发现时间。
    */
    @SerializedName("FindTime")
    @Expose
    private String FindTime;

    /**
    * 当前木马状态。
<li>UN_OPERATED：未处理</li>
<li>SEGREGATED：已隔离</li>
<li>TRUSTED：已信任</li>
<li>SEPARATING：隔离中</li>
<li>RECOVERING：恢复中</li>
    */
    @SerializedName("Status")
    @Expose
    private String Status;

    /**
     * Get 主机IP。 
     * @return MachineIp 主机IP。
     */
    public String getMachineIp() {
        return this.MachineIp;
    }

    /**
     * Set 主机IP。
     * @param MachineIp 主机IP。
     */
    public void setMachineIp(String MachineIp) {
        this.MachineIp = MachineIp;
    }

    /**
     * Get 木马文件路径。 
     * @return FilePath 木马文件路径。
     */
    public String getFilePath() {
        return this.FilePath;
    }

    /**
     * Set 木马文件路径。
     * @param FilePath 木马文件路径。
     */
    public void setFilePath(String FilePath) {
        this.FilePath = FilePath;
    }

    /**
     * Get 木马文件MD5值。 
     * @return Md5 木马文件MD5值。
     */
    public String getMd5() {
        return this.Md5;
    }

    /**
     * Set 木马文件MD5值。
     * @param Md5 木马文件MD5值。
     */
    public void setMd5(String Md5) {
        this.Md5 = Md5;
    }

    /**
     * Get 木马发现时间。 
     * @return FindTime 木马发现时间。
     */
    public String getFindTime() {
        return this.FindTime;
    }

    /**
     * Set 木马发现时间。
     * @param FindTime 木马发现时间。
     */
    public void setFindTime(String FindTime) {
        this.FindTime = FindTime;
    }

    /**
     * Get 当前木马状态。
<li>UN_OPERATED：未处理</li>
<li>SEGREGATED：已隔离</li>
<li>TRUSTED：已信任</li>
<li>SEPARATING：隔离中</li>
<li>RECOVERING：恢复中</li> 
     * @return Status 当前木马状态。
<li>UN_OPERATED：未处理</li>
<li>SEGREGATED：已隔离</li>
<li>TRUSTED：已信任</li>
<li>SEPARATING：隔离中</li>
<li>RECOVERING：恢复中</li>
     */
    public String getStatus() {
        return this.Status;
    }

    /**
     * Set 当前木马状态。
<li>UN_OPERATED：未处理</li>
<li>SEGREGATED：已隔离</li>
<li>TRUSTED：已信任</li>
<li>SEPARATING：隔离中</li>
<li>RECOVERING：恢复中</li>
     * @param Status 当前木马状态。
<li>UN_OPERATED：未处理</li>
<li>SEGREGATED：已隔离</li>
<li>TRUSTED：已信任</li>
<li>SEPARATING：隔离中</li>
<li>RECOVERING：恢复中</li>
     */
    public void setStatus(String Status) {
        this.Status = Status;
    }

    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "MachineIp", this.MachineIp);
        this.setParamSimple(map, prefix + "FilePath", this.FilePath);
        this.setParamSimple(map, prefix + "Md5", this.Md5);
        this.setParamSimple(map, prefix + "FindTime", this.FindTime);
        this.setParamSimple(map, prefix + "Status", this.Status);

    }
}

