/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.args;

import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgsMessages;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentValueValidator;
import java.io.Serializable;
import java.util.regex.Pattern;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class RegularExpressionArgumentValueValidator
extends ArgumentValueValidator
implements Serializable {
    private static final long serialVersionUID = -6676584334684453380L;

    @Override
    public void validateArgumentValue(Argument argument, String valueString) throws ArgumentException {
        try {
            Pattern.compile(valueString);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new ArgumentException(ArgsMessages.ERR_REGEX_VALIDATOR_VALUE_NOT_REGEX.get(valueString, argument.getIdentifierString()));
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("RegularExpressionArgumentValueValidator()");
    }
}

