/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.protocol.LDAPResponse;
import com.unboundid.ldap.sdk.AbstractConnectionPool;
import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.ConnectionClosedResponse;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DisconnectType;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.InternalSDKHelper;
import com.unboundid.ldap.sdk.LDAPBindException;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.LDAPConnectionPoolHealthCheckResult;
import com.unboundid.ldap.sdk.LDAPConnectionPoolHealthCheckThread;
import com.unboundid.ldap.sdk.LDAPConnectionPoolStatistics;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.OperationType;
import com.unboundid.ldap.sdk.ParallelPoolCloser;
import com.unboundid.ldap.sdk.ParallelPoolConnector;
import com.unboundid.ldap.sdk.PostConnectProcessor;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.ServerSet;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import com.unboundid.ldap.sdk.SingleServerSet;
import com.unboundid.ldap.sdk.UnsolicitedNotificationHandler;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.util.Debug;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class LDAPConnectionPool
extends AbstractConnectionPool {
    private static final long DEFAULT_HEALTH_CHECK_INTERVAL = 60000L;
    static final String ATTACHMENT_NAME_MAX_CONNECTION_AGE = LDAPConnectionPool.class.getName() + ".maxConnectionAge";
    private final AtomicInteger failedReplaceCount;
    private final AtomicReference<Set<OperationType>> retryOperationTypes;
    private volatile boolean closed;
    private boolean createIfNecessary;
    private volatile boolean checkConnectionAgeOnRelease;
    private volatile boolean trySynchronousReadDuringHealthCheck;
    private volatile BindRequest bindRequest;
    private final int numConnections;
    private volatile int minConnectionGoal;
    private LDAPConnectionPoolHealthCheck healthCheck;
    private final LDAPConnectionPoolHealthCheckThread healthCheckThread;
    private final LDAPConnectionPoolStatistics poolStatistics;
    private final LinkedBlockingQueue<LDAPConnection> availableConnections;
    private volatile long healthCheckInterval;
    private volatile long lastExpiredDisconnectTime;
    private volatile long maxConnectionAge;
    private volatile Long maxDefunctReplacementConnectionAge;
    private long maxWaitTime;
    private volatile long minDisconnectInterval;
    private volatile ObjectPair<Long, Schema> pooledSchema;
    private final PostConnectProcessor postConnectProcessor;
    private volatile ServerSet serverSet;
    private String connectionPoolName;

    public LDAPConnectionPool(LDAPConnection connection, int numConnections) throws LDAPException {
        this(connection, 1, numConnections, null);
    }

    public LDAPConnectionPool(LDAPConnection connection, int initialConnections, int maxConnections) throws LDAPException {
        this(connection, initialConnections, maxConnections, null);
    }

    public LDAPConnectionPool(LDAPConnection connection, int initialConnections, int maxConnections, PostConnectProcessor postConnectProcessor) throws LDAPException {
        this(connection, initialConnections, maxConnections, postConnectProcessor, true);
    }

    public LDAPConnectionPool(LDAPConnection connection, int initialConnections, int maxConnections, PostConnectProcessor postConnectProcessor, boolean throwOnConnectFailure) throws LDAPException {
        this(connection, initialConnections, maxConnections, 1, postConnectProcessor, throwOnConnectFailure);
    }

    public LDAPConnectionPool(LDAPConnection connection, int initialConnections, int maxConnections, int initialConnectThreads, PostConnectProcessor postConnectProcessor, boolean throwOnConnectFailure) throws LDAPException {
        this(connection, initialConnections, maxConnections, initialConnectThreads, postConnectProcessor, throwOnConnectFailure, null);
    }

    public LDAPConnectionPool(LDAPConnection connection, int initialConnections, int maxConnections, int initialConnectThreads, PostConnectProcessor postConnectProcessor, boolean throwOnConnectFailure, LDAPConnectionPoolHealthCheck healthCheck) throws LDAPException {
        ArrayList<LDAPConnection> connList;
        Validator.ensureNotNull(connection);
        Validator.ensureTrue(initialConnections >= 1, "LDAPConnectionPool.initialConnections must be at least 1.");
        Validator.ensureTrue(maxConnections >= initialConnections, "LDAPConnectionPool.initialConnections must not be greater than maxConnections.");
        this.postConnectProcessor = null;
        this.trySynchronousReadDuringHealthCheck = true;
        this.healthCheckInterval = 60000L;
        this.poolStatistics = new LDAPConnectionPoolStatistics(this);
        this.pooledSchema = null;
        this.connectionPoolName = null;
        this.retryOperationTypes = new AtomicReference<Set<OperationType>>(Collections.unmodifiableSet(EnumSet.noneOf(OperationType.class)));
        this.numConnections = maxConnections;
        this.minConnectionGoal = 0;
        this.availableConnections = new LinkedBlockingQueue(this.numConnections);
        if (!connection.isConnected()) {
            throw new LDAPException(ResultCode.PARAM_ERROR, LDAPMessages.ERR_POOL_CONN_NOT_ESTABLISHED.get());
        }
        this.healthCheck = healthCheck == null ? new LDAPConnectionPoolHealthCheck() : healthCheck;
        this.bindRequest = connection.getLastBindRequest();
        this.serverSet = new SingleServerSet(connection.getConnectedAddress(), connection.getConnectedPort(), connection.getLastUsedSocketFactory(), connection.getConnectionOptions(), null, postConnectProcessor);
        LDAPConnectionOptions opts = connection.getConnectionOptions();
        if (opts.usePooledSchema()) {
            try {
                Schema schema = connection.getSchema();
                if (schema != null) {
                    connection.setCachedSchema(schema);
                    long currentTime = System.currentTimeMillis();
                    long timeout = opts.getPooledSchemaTimeoutMillis();
                    this.pooledSchema = timeout <= 0L || timeout + currentTime <= 0L ? new ObjectPair<Long, Schema>(Long.MAX_VALUE, schema) : new ObjectPair<Long, Schema>(timeout + currentTime, schema);
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        if (initialConnectThreads > 1) {
            connList = Collections.synchronizedList(new ArrayList(initialConnections));
            ParallelPoolConnector connector = new ParallelPoolConnector(this, connList, initialConnections, initialConnectThreads, throwOnConnectFailure);
            connector.establishConnections();
        } else {
            connList = new ArrayList(initialConnections);
            connection.setConnectionName(null);
            connection.setConnectionPool(this);
            connList.add(connection);
            for (int i = 1; i < initialConnections; ++i) {
                try {
                    connList.add(this.createConnection());
                    continue;
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    if (!throwOnConnectFailure) continue;
                    for (LDAPConnection c : connList) {
                        try {
                            c.setDisconnectInfo(DisconnectType.POOL_CREATION_FAILURE, null, le);
                            c.setClosed();
                        }
                        catch (Exception e) {
                            Debug.debugException(e);
                        }
                    }
                    throw le;
                }
            }
        }
        this.availableConnections.addAll(connList);
        this.failedReplaceCount = new AtomicInteger(maxConnections - this.availableConnections.size());
        this.createIfNecessary = true;
        this.checkConnectionAgeOnRelease = false;
        this.maxConnectionAge = 0L;
        this.maxDefunctReplacementConnectionAge = null;
        this.minDisconnectInterval = 0L;
        this.lastExpiredDisconnectTime = 0L;
        this.maxWaitTime = 0L;
        this.closed = false;
        this.healthCheckThread = new LDAPConnectionPoolHealthCheckThread(this);
        this.healthCheckThread.start();
    }

    public LDAPConnectionPool(ServerSet serverSet, BindRequest bindRequest, int numConnections) throws LDAPException {
        this(serverSet, bindRequest, 1, numConnections, null);
    }

    public LDAPConnectionPool(ServerSet serverSet, BindRequest bindRequest, int initialConnections, int maxConnections) throws LDAPException {
        this(serverSet, bindRequest, initialConnections, maxConnections, null);
    }

    public LDAPConnectionPool(ServerSet serverSet, BindRequest bindRequest, int initialConnections, int maxConnections, PostConnectProcessor postConnectProcessor) throws LDAPException {
        this(serverSet, bindRequest, initialConnections, maxConnections, postConnectProcessor, true);
    }

    public LDAPConnectionPool(ServerSet serverSet, BindRequest bindRequest, int initialConnections, int maxConnections, PostConnectProcessor postConnectProcessor, boolean throwOnConnectFailure) throws LDAPException {
        this(serverSet, bindRequest, initialConnections, maxConnections, 1, postConnectProcessor, throwOnConnectFailure);
    }

    public LDAPConnectionPool(ServerSet serverSet, BindRequest bindRequest, int initialConnections, int maxConnections, int initialConnectThreads, PostConnectProcessor postConnectProcessor, boolean throwOnConnectFailure) throws LDAPException {
        this(serverSet, bindRequest, initialConnections, maxConnections, initialConnectThreads, postConnectProcessor, throwOnConnectFailure, null);
    }

    public LDAPConnectionPool(ServerSet serverSet, BindRequest bindRequest, int initialConnections, int maxConnections, int initialConnectThreads, PostConnectProcessor postConnectProcessor, boolean throwOnConnectFailure, LDAPConnectionPoolHealthCheck healthCheck) throws LDAPException {
        ArrayList<LDAPConnection> connList;
        Validator.ensureNotNull(serverSet);
        Validator.ensureTrue(initialConnections >= 0, "LDAPConnectionPool.initialConnections must be greater than or equal to 0.");
        Validator.ensureTrue(maxConnections > 0, "LDAPConnectionPool.maxConnections must be greater than 0.");
        Validator.ensureTrue(maxConnections >= initialConnections, "LDAPConnectionPool.initialConnections must not be greater than maxConnections.");
        this.serverSet = serverSet;
        this.bindRequest = bindRequest;
        this.postConnectProcessor = postConnectProcessor;
        if (serverSet.includesAuthentication()) {
            Validator.ensureTrue(bindRequest != null, "LDAPConnectionPool.bindRequest must not be null if serverSet.includesAuthentication returns true");
        }
        if (serverSet.includesPostConnectProcessing()) {
            Validator.ensureTrue(postConnectProcessor == null, "LDAPConnectionPool.postConnectProcessor must be null if serverSet.includesPostConnectProcessing returns true.");
        }
        this.trySynchronousReadDuringHealthCheck = false;
        this.healthCheckInterval = 60000L;
        this.poolStatistics = new LDAPConnectionPoolStatistics(this);
        this.pooledSchema = null;
        this.connectionPoolName = null;
        this.retryOperationTypes = new AtomicReference<Set<OperationType>>(Collections.unmodifiableSet(EnumSet.noneOf(OperationType.class)));
        this.minConnectionGoal = 0;
        this.numConnections = maxConnections;
        this.availableConnections = new LinkedBlockingQueue(this.numConnections);
        this.healthCheck = healthCheck == null ? new LDAPConnectionPoolHealthCheck() : healthCheck;
        if (initialConnectThreads > 1) {
            connList = Collections.synchronizedList(new ArrayList(initialConnections));
            ParallelPoolConnector connector = new ParallelPoolConnector(this, connList, initialConnections, initialConnectThreads, throwOnConnectFailure);
            connector.establishConnections();
        } else {
            connList = new ArrayList(initialConnections);
            for (int i = 0; i < initialConnections; ++i) {
                try {
                    connList.add(this.createConnection());
                    continue;
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    if (!throwOnConnectFailure) continue;
                    for (LDAPConnection c : connList) {
                        try {
                            c.setDisconnectInfo(DisconnectType.POOL_CREATION_FAILURE, null, le);
                            c.setClosed();
                        }
                        catch (Exception e) {
                            Debug.debugException(e);
                        }
                    }
                    throw le;
                }
            }
        }
        this.availableConnections.addAll(connList);
        this.failedReplaceCount = new AtomicInteger(maxConnections - this.availableConnections.size());
        this.createIfNecessary = true;
        this.checkConnectionAgeOnRelease = false;
        this.maxConnectionAge = 0L;
        this.maxDefunctReplacementConnectionAge = null;
        this.minDisconnectInterval = 0L;
        this.lastExpiredDisconnectTime = 0L;
        this.maxWaitTime = 0L;
        this.closed = false;
        this.healthCheckThread = new LDAPConnectionPoolHealthCheckThread(this);
        this.healthCheckThread.start();
    }

    LDAPConnection createConnection() throws LDAPException {
        return this.createConnection(this.healthCheck);
    }

    private LDAPConnection createConnection(LDAPConnectionPoolHealthCheck healthCheck) throws LDAPException {
        LDAPConnection c;
        block33: {
            try {
                c = this.serverSet.getConnection(healthCheck);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                this.poolStatistics.incrementNumFailedConnectionAttempts();
                Debug.debugConnectionPool(Level.SEVERE, this, null, "Unable to create a new pooled connection", le);
                throw le;
            }
            c.setConnectionPool(this);
            LDAPConnectionOptions opts = c.getConnectionOptions();
            if (opts.autoReconnect()) {
                opts = opts.duplicate();
                opts.setAutoReconnect(false);
                c.setConnectionOptions(opts);
            }
            if (this.postConnectProcessor != null) {
                try {
                    this.postConnectProcessor.processPreAuthenticatedConnection(c);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    try {
                        this.poolStatistics.incrementNumFailedConnectionAttempts();
                        Debug.debugConnectionPool(Level.SEVERE, this, c, "Exception in pre-authentication post-connect processing", e);
                        c.setDisconnectInfo(DisconnectType.POOL_CREATION_FAILURE, null, e);
                        c.setClosed();
                    }
                    catch (Exception e2) {
                        Debug.debugException(e2);
                    }
                    if (e instanceof LDAPException) {
                        throw (LDAPException)e;
                    }
                    throw new LDAPException(ResultCode.CONNECT_ERROR, LDAPMessages.ERR_POOL_POST_CONNECT_ERROR.get(StaticUtils.getExceptionMessage(e)), e);
                }
            }
            if (this.bindRequest != null && !this.serverSet.includesAuthentication()) {
                BindResult bindResult;
                try {
                    bindResult = c.bind(this.bindRequest.duplicate());
                }
                catch (LDAPBindException lbe) {
                    Debug.debugException(lbe);
                    bindResult = lbe.getBindResult();
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    bindResult = new BindResult(le);
                }
                try {
                    if (healthCheck != null) {
                        healthCheck.ensureConnectionValidAfterAuthentication(c, bindResult);
                    }
                    if (bindResult.getResultCode() != ResultCode.SUCCESS) {
                        throw new LDAPBindException(bindResult);
                    }
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    try {
                        this.poolStatistics.incrementNumFailedConnectionAttempts();
                        if (bindResult.getResultCode() != ResultCode.SUCCESS) {
                            Debug.debugConnectionPool(Level.SEVERE, this, c, "Failed to authenticate a new pooled connection", le);
                        } else {
                            Debug.debugConnectionPool(Level.SEVERE, this, c, "A new pooled connection failed its post-authentication health check", le);
                        }
                        c.setDisconnectInfo(DisconnectType.BIND_FAILED, null, le);
                        c.setClosed();
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                    }
                    throw le;
                }
            }
            if (this.postConnectProcessor != null) {
                try {
                    this.postConnectProcessor.processPostAuthenticatedConnection(c);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    try {
                        this.poolStatistics.incrementNumFailedConnectionAttempts();
                        Debug.debugConnectionPool(Level.SEVERE, this, c, "Exception in post-authentication post-connect processing", e);
                        c.setDisconnectInfo(DisconnectType.POOL_CREATION_FAILURE, null, e);
                        c.setClosed();
                    }
                    catch (Exception e2) {
                        Debug.debugException(e2);
                    }
                    if (e instanceof LDAPException) {
                        throw (LDAPException)e;
                    }
                    throw new LDAPException(ResultCode.CONNECT_ERROR, LDAPMessages.ERR_POOL_POST_CONNECT_ERROR.get(StaticUtils.getExceptionMessage(e)), e);
                }
            }
            if (opts.usePooledSchema()) {
                long currentTime = System.currentTimeMillis();
                if (this.pooledSchema == null || currentTime > this.pooledSchema.getFirst()) {
                    try {
                        Schema schema = c.getSchema();
                        if (schema == null) break block33;
                        c.setCachedSchema(schema);
                        long timeout = opts.getPooledSchemaTimeoutMillis();
                        if (timeout <= 0L || currentTime + timeout <= 0L) {
                            this.pooledSchema = new ObjectPair<Long, Schema>(Long.MAX_VALUE, schema);
                            break block33;
                        }
                        this.pooledSchema = new ObjectPair<Long, Schema>(currentTime + timeout, schema);
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        if (this.pooledSchema != null) {
                            c.setCachedSchema(this.pooledSchema.getSecond());
                        }
                        break block33;
                    }
                }
                c.setCachedSchema(this.pooledSchema.getSecond());
            }
        }
        c.setConnectionPoolName(this.connectionPoolName);
        this.poolStatistics.incrementNumSuccessfulConnectionAttempts();
        Debug.debugConnectionPool(Level.INFO, this, c, "Successfully created a new pooled connection", null);
        return c;
    }

    @Override
    public void close() {
        this.close(true, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean unbind, int numThreads) {
        block9: {
            try {
                boolean healthCheckThreadAlreadySignaled = this.closed;
                this.closed = true;
                this.healthCheckThread.stopRunning(!healthCheckThreadAlreadySignaled);
                if (numThreads > 1) {
                    ArrayList<LDAPConnection> connList = new ArrayList<LDAPConnection>(this.availableConnections.size());
                    this.availableConnections.drainTo(connList);
                    if (!connList.isEmpty()) {
                        ParallelPoolCloser closer = new ParallelPoolCloser(connList, unbind, numThreads);
                        closer.closeConnections();
                    }
                    break block9;
                }
                while (true) {
                    LDAPConnection conn;
                    if ((conn = this.availableConnections.poll()) == null) {
                        return;
                    }
                    this.poolStatistics.incrementNumConnectionsClosedUnneeded();
                    Debug.debugConnectionPool(Level.INFO, this, conn, "Closed a connection as part of closing the connection pool", null);
                    conn.setDisconnectInfo(DisconnectType.POOL_CLOSED, null, null);
                    if (unbind) {
                        conn.terminate(null);
                        continue;
                    }
                    conn.setClosed();
                }
            }
            finally {
                Debug.debugConnectionPool(Level.INFO, this, null, "Closed the connection pool", null);
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public BindResult bindAndRevertAuthentication(String bindDN, String password, Control ... controls) throws LDAPException {
        return this.bindAndRevertAuthentication(new SimpleBindRequest(bindDN, password, controls));
    }

    public BindResult bindAndRevertAuthentication(BindRequest bindRequest) throws LDAPException {
        LDAPConnection conn = this.getConnection();
        try {
            BindResult result = conn.bind(bindRequest);
            this.releaseAndReAuthenticateConnection(conn);
            return result;
        }
        catch (Throwable t) {
            LDAPException le;
            Debug.debugException(t);
            if (t instanceof LDAPException) {
                boolean shouldThrow;
                block13: {
                    le = (LDAPException)t;
                    try {
                        this.healthCheck.ensureConnectionValidAfterException(conn, le);
                        this.releaseAndReAuthenticateConnection(conn);
                        shouldThrow = true;
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        if (!this.getOperationTypesToRetryDueToInvalidConnections().contains((Object)OperationType.BIND)) {
                            this.releaseDefunctConnection(conn);
                            shouldThrow = true;
                            break block13;
                        }
                        shouldThrow = false;
                    }
                }
                if (shouldThrow) {
                    throw le;
                }
            } else {
                this.releaseDefunctConnection(conn);
                StaticUtils.rethrowIfError(t);
                throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_POOL_OP_EXCEPTION.get(StaticUtils.getExceptionMessage(t)), t);
            }
            conn = this.replaceDefunctConnection(conn);
            try {
                BindResult result = conn.bind(bindRequest);
                this.releaseAndReAuthenticateConnection(conn);
                return result;
            }
            catch (Throwable t2) {
                Debug.debugException(t2);
                if (t2 instanceof LDAPException) {
                    le = (LDAPException)t2;
                    try {
                        this.healthCheck.ensureConnectionValidAfterException(conn, le);
                        this.releaseAndReAuthenticateConnection(conn);
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        this.releaseDefunctConnection(conn);
                    }
                    throw le;
                }
                this.releaseDefunctConnection(conn);
                StaticUtils.rethrowIfError(t2);
                throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_POOL_OP_EXCEPTION.get(StaticUtils.getExceptionMessage(t2)), t2);
            }
        }
    }

    @Override
    public LDAPConnection getConnection() throws LDAPException {
        if (this.closed) {
            this.poolStatistics.incrementNumFailedCheckouts();
            Debug.debugConnectionPool(Level.SEVERE, this, null, "Failed to get a connection to a closed connection pool", null);
            throw new LDAPException(ResultCode.CONNECT_ERROR, LDAPMessages.ERR_POOL_CLOSED.get());
        }
        LDAPConnection conn = this.availableConnections.poll();
        if (conn != null) {
            LDAPException connException = null;
            if (conn.isConnected()) {
                try {
                    this.healthCheck.ensureConnectionValidForCheckout(conn);
                    this.poolStatistics.incrementNumSuccessfulCheckoutsWithoutWaiting();
                    Debug.debugConnectionPool(Level.INFO, this, conn, "Checked out an immediately available pooled connection", null);
                    return conn;
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    connException = le;
                }
            }
            this.poolStatistics.incrementNumConnectionsClosedDefunct();
            Debug.debugConnectionPool(Level.WARNING, this, conn, "Closing a defunct connection encountered during checkout", connException);
            this.handleDefunctConnection(conn);
            for (int i = 0; i < this.numConnections && (conn = this.availableConnections.poll()) != null; ++i) {
                if (conn.isConnected()) {
                    try {
                        this.healthCheck.ensureConnectionValidForCheckout(conn);
                        this.poolStatistics.incrementNumSuccessfulCheckoutsWithoutWaiting();
                        Debug.debugConnectionPool(Level.INFO, this, conn, "Checked out an immediately available pooled connection", null);
                        return conn;
                    }
                    catch (LDAPException le) {
                        Debug.debugException(le);
                        this.poolStatistics.incrementNumConnectionsClosedDefunct();
                        Debug.debugConnectionPool(Level.WARNING, this, conn, "Closing a defunct connection encountered during checkout", le);
                        this.handleDefunctConnection(conn);
                        continue;
                    }
                }
                this.poolStatistics.incrementNumConnectionsClosedDefunct();
                Debug.debugConnectionPool(Level.WARNING, this, conn, "Closing a defunct connection encountered during checkout", null);
                this.handleDefunctConnection(conn);
            }
        }
        if (this.failedReplaceCount.get() > 0) {
            int newReplaceCount = this.failedReplaceCount.getAndDecrement();
            if (newReplaceCount > 0) {
                try {
                    conn = this.createConnection();
                    this.poolStatistics.incrementNumSuccessfulCheckoutsNewConnection();
                    Debug.debugConnectionPool(Level.INFO, this, conn, "Checked out a newly created connection", null);
                    return conn;
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    this.failedReplaceCount.incrementAndGet();
                    this.poolStatistics.incrementNumFailedCheckouts();
                    Debug.debugConnectionPool(Level.SEVERE, this, conn, "Unable to create a new connection for checkout", le);
                    throw le;
                }
            }
            this.failedReplaceCount.incrementAndGet();
        }
        if (this.maxWaitTime > 0L) {
            try {
                long startWaitTime = System.currentTimeMillis();
                conn = this.availableConnections.poll(this.maxWaitTime, TimeUnit.MILLISECONDS);
                long elapsedWaitTime = System.currentTimeMillis() - startWaitTime;
                if (conn != null) {
                    try {
                        this.healthCheck.ensureConnectionValidForCheckout(conn);
                        this.poolStatistics.incrementNumSuccessfulCheckoutsAfterWaiting();
                        Debug.debugConnectionPool(Level.INFO, this, conn, "Checked out an existing connection after waiting " + elapsedWaitTime + "ms for it to become available", null);
                        return conn;
                    }
                    catch (LDAPException le) {
                        Debug.debugException(le);
                        this.poolStatistics.incrementNumConnectionsClosedDefunct();
                        Debug.debugConnectionPool(Level.WARNING, this, conn, "Got a connection for checkout after waiting " + elapsedWaitTime + "ms for it to become available, but " + "the connection failed the checkout health check", le);
                        this.handleDefunctConnection(conn);
                    }
                }
            }
            catch (InterruptedException ie) {
                Debug.debugException(ie);
                Thread.currentThread().interrupt();
                throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_POOL_CHECKOUT_INTERRUPTED.get(), ie);
            }
        }
        if (this.createIfNecessary) {
            try {
                conn = this.createConnection();
                this.poolStatistics.incrementNumSuccessfulCheckoutsNewConnection();
                Debug.debugConnectionPool(Level.INFO, this, conn, "Checked out a newly created connection", null);
                return conn;
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                this.poolStatistics.incrementNumFailedCheckouts();
                Debug.debugConnectionPool(Level.SEVERE, this, null, "Unable to create a new connection for checkout", le);
                throw le;
            }
        }
        this.poolStatistics.incrementNumFailedCheckouts();
        Debug.debugConnectionPool(Level.SEVERE, this, null, "Unable to check out a connection because none are available", null);
        throw new LDAPException(ResultCode.CONNECT_ERROR, LDAPMessages.ERR_POOL_NO_CONNECTIONS.get());
    }

    public LDAPConnection getConnection(String host, int port) {
        if (this.closed) {
            this.poolStatistics.incrementNumFailedCheckouts();
            Debug.debugConnectionPool(Level.WARNING, this, null, "Failed to get a connection to a closed connection pool", null);
            return null;
        }
        HashSet<LDAPConnection> examinedConnections = new HashSet<LDAPConnection>(StaticUtils.computeMapCapacity(this.numConnections));
        while (true) {
            LDAPConnection conn;
            if ((conn = this.availableConnections.poll()) == null) {
                this.poolStatistics.incrementNumFailedCheckouts();
                Debug.debugConnectionPool(Level.SEVERE, this, null, "Failed to get an existing connection to " + host + ':' + port + " because no connections are immediately available", null);
                return null;
            }
            if (examinedConnections.contains(conn)) {
                if (!this.availableConnections.offer(conn)) {
                    this.discardConnection(conn);
                }
                this.poolStatistics.incrementNumFailedCheckouts();
                Debug.debugConnectionPool(Level.WARNING, this, null, "Failed to get an existing connection to " + host + ':' + port + " because none of the available connections are " + "established to that server", null);
                return null;
            }
            if (conn.getConnectedAddress().equals(host) && port == conn.getConnectedPort()) {
                try {
                    this.healthCheck.ensureConnectionValidForCheckout(conn);
                    this.poolStatistics.incrementNumSuccessfulCheckoutsWithoutWaiting();
                    Debug.debugConnectionPool(Level.INFO, this, conn, "Successfully checked out an existing connection to requested server " + host + ':' + port, null);
                    return conn;
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    this.poolStatistics.incrementNumConnectionsClosedDefunct();
                    Debug.debugConnectionPool(Level.WARNING, this, conn, "Closing an existing connection to requested server " + host + ':' + port + " because it failed the checkout health " + "check", le);
                    this.handleDefunctConnection(conn);
                }
                continue;
            }
            if (this.availableConnections.offer(conn)) {
                examinedConnections.add(conn);
                continue;
            }
            this.discardConnection(conn);
        }
    }

    @Override
    public void releaseConnection(LDAPConnection connection) {
        if (connection == null) {
            return;
        }
        connection.setConnectionPoolName(this.connectionPoolName);
        if (this.checkConnectionAgeOnRelease && this.connectionIsExpired(connection)) {
            try {
                LDAPConnection newConnection = this.createConnection();
                if (this.availableConnections.offer(newConnection)) {
                    connection.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_EXPIRED, null, null);
                    connection.terminate(null);
                    this.poolStatistics.incrementNumConnectionsClosedExpired();
                    Debug.debugConnectionPool(Level.WARNING, this, connection, "Closing a released connection because it is expired", null);
                    this.lastExpiredDisconnectTime = System.currentTimeMillis();
                } else {
                    newConnection.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_UNNEEDED, null, null);
                    newConnection.terminate(null);
                    this.poolStatistics.incrementNumConnectionsClosedUnneeded();
                    Debug.debugConnectionPool(Level.WARNING, this, connection, "Closing a released connection because the pool is already full", null);
                }
            }
            catch (LDAPException le) {
                Debug.debugException(le);
            }
            return;
        }
        try {
            this.healthCheck.ensureConnectionValidForRelease(connection);
        }
        catch (LDAPException le) {
            this.releaseDefunctConnection(connection);
            return;
        }
        if (!this.availableConnections.offer(connection)) {
            connection.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_UNNEEDED, null, null);
            this.poolStatistics.incrementNumConnectionsClosedUnneeded();
            Debug.debugConnectionPool(Level.WARNING, this, connection, "Closing a released connection because the pool is already full", null);
            connection.terminate(null);
            return;
        }
        this.poolStatistics.incrementNumReleasedValid();
        Debug.debugConnectionPool(Level.INFO, this, connection, "Released a connection back to the pool", null);
        if (this.closed) {
            this.close();
        }
    }

    public void discardConnection(LDAPConnection connection) {
        int newReplaceCount;
        if (connection == null) {
            return;
        }
        connection.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_UNNEEDED, null, null);
        connection.terminate(null);
        this.poolStatistics.incrementNumConnectionsClosedUnneeded();
        Debug.debugConnectionPool(Level.INFO, this, connection, "Discareded a connection that is no longer needed", null);
        if (this.availableConnections.remainingCapacity() > 0 && (newReplaceCount = this.failedReplaceCount.incrementAndGet()) > this.numConnections) {
            this.failedReplaceCount.set(this.numConnections);
        }
    }

    public void releaseAndReAuthenticateConnection(LDAPConnection connection) {
        if (connection == null) {
            return;
        }
        try {
            BindResult bindResult;
            try {
                bindResult = this.bindRequest == null ? connection.bind("", "") : connection.bind(this.bindRequest.duplicate());
            }
            catch (LDAPBindException lbe) {
                Debug.debugException(lbe);
                bindResult = lbe.getBindResult();
            }
            try {
                this.healthCheck.ensureConnectionValidAfterAuthentication(connection, bindResult);
                if (bindResult.getResultCode() != ResultCode.SUCCESS) {
                    throw new LDAPBindException(bindResult);
                }
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                try {
                    connection.setDisconnectInfo(DisconnectType.BIND_FAILED, null, le);
                    connection.setClosed();
                    this.releaseDefunctConnection(connection);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
                throw le;
            }
            this.releaseConnection(connection);
        }
        catch (Exception e) {
            Debug.debugException(e);
            this.releaseDefunctConnection(connection);
        }
    }

    @Override
    public void releaseDefunctConnection(LDAPConnection connection) {
        if (connection == null) {
            return;
        }
        connection.setConnectionPoolName(this.connectionPoolName);
        this.poolStatistics.incrementNumConnectionsClosedDefunct();
        Debug.debugConnectionPool(Level.WARNING, this, connection, "Releasing a defunct connection", null);
        this.handleDefunctConnection(connection);
    }

    private LDAPConnection handleDefunctConnection(LDAPConnection connection) {
        connection.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_DEFUNCT, null, null);
        connection.setClosed();
        if (this.closed) {
            return null;
        }
        if (this.createIfNecessary && this.availableConnections.remainingCapacity() <= 0) {
            return null;
        }
        try {
            LDAPConnection conn = this.createConnection();
            if (this.maxDefunctReplacementConnectionAge != null && conn.getAttachment(ATTACHMENT_NAME_MAX_CONNECTION_AGE) == null) {
                conn.setAttachment(ATTACHMENT_NAME_MAX_CONNECTION_AGE, this.maxDefunctReplacementConnectionAge);
            }
            if (!this.availableConnections.offer(conn)) {
                conn.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_UNNEEDED, null, null);
                conn.terminate(null);
                return null;
            }
            return conn;
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            int newReplaceCount = this.failedReplaceCount.incrementAndGet();
            if (newReplaceCount > this.numConnections) {
                this.failedReplaceCount.set(this.numConnections);
            }
            return null;
        }
    }

    @Override
    public LDAPConnection replaceDefunctConnection(LDAPConnection connection) throws LDAPException {
        this.poolStatistics.incrementNumConnectionsClosedDefunct();
        Debug.debugConnectionPool(Level.WARNING, this, connection, "Releasing a defunct connection that is to be replaced", null);
        connection.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_DEFUNCT, null, null);
        connection.setClosed();
        if (this.closed) {
            throw new LDAPException(ResultCode.CONNECT_ERROR, LDAPMessages.ERR_POOL_CLOSED.get());
        }
        try {
            return this.createConnection();
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.failedReplaceCount.incrementAndGet();
            throw le;
        }
    }

    @Override
    public Set<OperationType> getOperationTypesToRetryDueToInvalidConnections() {
        return this.retryOperationTypes.get();
    }

    @Override
    public void setRetryFailedOperationsDueToInvalidConnections(Set<OperationType> operationTypes) {
        if (operationTypes == null || operationTypes.isEmpty()) {
            this.retryOperationTypes.set(Collections.unmodifiableSet(EnumSet.noneOf(OperationType.class)));
        } else {
            EnumSet<OperationType> s = EnumSet.noneOf(OperationType.class);
            s.addAll(operationTypes);
            this.retryOperationTypes.set(Collections.unmodifiableSet(s));
        }
    }

    private boolean connectionIsExpired(LDAPConnection connection) {
        Object maxAgeObj = connection.getAttachment(ATTACHMENT_NAME_MAX_CONNECTION_AGE);
        long maxAge = maxAgeObj != null && maxAgeObj instanceof Long ? (Long)maxAgeObj : this.maxConnectionAge;
        if (maxAge <= 0L) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastExpiredDisconnectTime < this.minDisconnectInterval) {
            return false;
        }
        long connectionAge = currentTime - connection.getConnectTime();
        return connectionAge > maxAge;
    }

    public void setBindRequest(BindRequest bindRequest) {
        this.bindRequest = bindRequest;
    }

    public void setServerSet(ServerSet serverSet) {
        Validator.ensureNotNull(serverSet);
        this.serverSet = serverSet;
    }

    @Override
    public String getConnectionPoolName() {
        return this.connectionPoolName;
    }

    @Override
    public void setConnectionPoolName(String connectionPoolName) {
        this.connectionPoolName = connectionPoolName;
        for (LDAPConnection c : this.availableConnections) {
            c.setConnectionPoolName(connectionPoolName);
        }
    }

    public boolean getCreateIfNecessary() {
        return this.createIfNecessary;
    }

    public void setCreateIfNecessary(boolean createIfNecessary) {
        this.createIfNecessary = createIfNecessary;
    }

    public long getMaxWaitTimeMillis() {
        return this.maxWaitTime;
    }

    public void setMaxWaitTimeMillis(long maxWaitTime) {
        this.maxWaitTime = maxWaitTime > 0L ? maxWaitTime : 0L;
    }

    public long getMaxConnectionAgeMillis() {
        return this.maxConnectionAge;
    }

    public void setMaxConnectionAgeMillis(long maxConnectionAge) {
        this.maxConnectionAge = maxConnectionAge > 0L ? maxConnectionAge : 0L;
    }

    public Long getMaxDefunctReplacementConnectionAgeMillis() {
        return this.maxDefunctReplacementConnectionAge;
    }

    public void setMaxDefunctReplacementConnectionAgeMillis(Long maxDefunctReplacementConnectionAge) {
        this.maxDefunctReplacementConnectionAge = maxDefunctReplacementConnectionAge == null ? null : (maxDefunctReplacementConnectionAge > 0L ? maxDefunctReplacementConnectionAge : Long.valueOf(0L));
    }

    public boolean checkConnectionAgeOnRelease() {
        return this.checkConnectionAgeOnRelease;
    }

    public void setCheckConnectionAgeOnRelease(boolean checkConnectionAgeOnRelease) {
        this.checkConnectionAgeOnRelease = checkConnectionAgeOnRelease;
    }

    public long getMinDisconnectIntervalMillis() {
        return this.minDisconnectInterval;
    }

    public void setMinDisconnectIntervalMillis(long minDisconnectInterval) {
        this.minDisconnectInterval = minDisconnectInterval > 0L ? minDisconnectInterval : 0L;
    }

    @Override
    public LDAPConnectionPoolHealthCheck getHealthCheck() {
        return this.healthCheck;
    }

    public void setHealthCheck(LDAPConnectionPoolHealthCheck healthCheck) {
        Validator.ensureNotNull(healthCheck);
        this.healthCheck = healthCheck;
    }

    @Override
    public long getHealthCheckIntervalMillis() {
        return this.healthCheckInterval;
    }

    @Override
    public void setHealthCheckIntervalMillis(long healthCheckInterval) {
        Validator.ensureTrue(healthCheckInterval > 0L, "LDAPConnectionPool.healthCheckInterval must be greater than 0.");
        this.healthCheckInterval = healthCheckInterval;
        this.healthCheckThread.wakeUp();
    }

    public boolean trySynchronousReadDuringHealthCheck() {
        return this.trySynchronousReadDuringHealthCheck;
    }

    public void setTrySynchronousReadDuringHealthCheck(boolean trySynchronousReadDuringHealthCheck) {
        this.trySynchronousReadDuringHealthCheck = trySynchronousReadDuringHealthCheck;
    }

    @Override
    protected void doHealthCheck() {
        this.invokeHealthCheck(null, true);
    }

    public LDAPConnectionPoolHealthCheckResult invokeHealthCheck(LDAPConnectionPoolHealthCheck healthCheck, boolean checkForExpiration) {
        return this.invokeHealthCheck(healthCheck, checkForExpiration, checkForExpiration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LDAPConnectionPoolHealthCheckResult invokeHealthCheck(LDAPConnectionPoolHealthCheck healthCheck, boolean checkForExpiration, boolean checkMinConnectionGoal) {
        LDAPConnection conn;
        LDAPConnectionPoolHealthCheck hc = healthCheck == null ? this.healthCheck : healthCheck;
        HashSet<LDAPConnection> examinedConnections = new HashSet<LDAPConnection>(StaticUtils.computeMapCapacity(this.numConnections));
        int numExamined = 0;
        int numDefunct = 0;
        int numExpired = 0;
        for (int i = 0; i < this.numConnections && (conn = this.availableConnections.poll()) != null; ++i) {
            block44: {
                if (examinedConnections.contains(conn)) {
                    if (this.availableConnections.offer(conn)) break;
                    conn.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_UNNEEDED, null, null);
                    this.poolStatistics.incrementNumConnectionsClosedUnneeded();
                    Debug.debugConnectionPool(Level.INFO, this, conn, "Closing a connection that had just been health checked because the pool is now full", null);
                    conn.terminate(null);
                    break;
                }
                ++numExamined;
                if (!conn.isConnected()) {
                    ++numDefunct;
                    this.poolStatistics.incrementNumConnectionsClosedDefunct();
                    Debug.debugConnectionPool(Level.WARNING, this, conn, "Closing a connection that was identified as not established during health check processing", null);
                    conn = this.handleDefunctConnection(conn);
                    if (conn == null) continue;
                    examinedConnections.add(conn);
                    continue;
                }
                if (checkForExpiration && this.connectionIsExpired(conn)) {
                    ++numExpired;
                    try {
                        LDAPConnection newConnection = this.createConnection();
                        if (this.availableConnections.offer(newConnection)) {
                            examinedConnections.add(newConnection);
                            conn.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_EXPIRED, null, null);
                            conn.terminate(null);
                            this.poolStatistics.incrementNumConnectionsClosedExpired();
                            Debug.debugConnectionPool(Level.INFO, this, conn, "Closing a connection that was identified as expired during health check processing", null);
                            this.lastExpiredDisconnectTime = System.currentTimeMillis();
                            continue;
                        }
                        newConnection.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_UNNEEDED, null, null);
                        newConnection.terminate(null);
                        this.poolStatistics.incrementNumConnectionsClosedUnneeded();
                        Debug.debugConnectionPool(Level.INFO, this, newConnection, "Closing a newly created connection created to replace an expired connection because the pool is already full", null);
                    }
                    catch (LDAPException le) {
                        Debug.debugException(le);
                    }
                }
                if (this.trySynchronousReadDuringHealthCheck && conn.synchronousMode()) {
                    int previousTimeout = Integer.MIN_VALUE;
                    Socket s = null;
                    try {
                        LDAPResult r;
                        s = conn.getConnectionInternals(true).getSocket();
                        previousTimeout = s.getSoTimeout();
                        InternalSDKHelper.setSoTimeout(conn, 1);
                        LDAPResponse response = conn.readResponse(0);
                        if (response instanceof ConnectionClosedResponse) {
                            ++numDefunct;
                            conn.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_DEFUNCT, LDAPMessages.ERR_POOL_HEALTH_CHECK_CONN_CLOSED.get(), null);
                            this.poolStatistics.incrementNumConnectionsClosedDefunct();
                            Debug.debugConnectionPool(Level.WARNING, this, conn, "Closing existing connection discovered to be disconnected during health check processing", null);
                            conn = this.handleDefunctConnection(conn);
                            if (conn == null) continue;
                            examinedConnections.add(conn);
                            continue;
                        }
                        if (response instanceof ExtendedResult) {
                            UnsolicitedNotificationHandler h = conn.getConnectionOptions().getUnsolicitedNotificationHandler();
                            if (h != null) {
                                h.handleUnsolicitedNotification(conn, (ExtendedResult)response);
                            }
                        } else if (response instanceof LDAPResult && (r = (LDAPResult)response).getResultCode() == ResultCode.SERVER_DOWN) {
                            ++numDefunct;
                            conn.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_DEFUNCT, LDAPMessages.ERR_POOL_HEALTH_CHECK_CONN_CLOSED.get(), null);
                            this.poolStatistics.incrementNumConnectionsClosedDefunct();
                            Debug.debugConnectionPool(Level.WARNING, this, conn, "Closing existing connection discovered to be invalid with result " + r + " during health check " + "processing", null);
                            conn = this.handleDefunctConnection(conn);
                            if (conn == null) continue;
                            examinedConnections.add(conn);
                            continue;
                        }
                    }
                    catch (LDAPException le) {
                        if (le.getResultCode() == ResultCode.TIMEOUT) {
                            Debug.debugException(Level.FINEST, le);
                            break block44;
                        }
                        Debug.debugException(le);
                        ++numDefunct;
                        conn.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_DEFUNCT, LDAPMessages.ERR_POOL_HEALTH_CHECK_READ_FAILURE.get(StaticUtils.getExceptionMessage(le)), le);
                        this.poolStatistics.incrementNumConnectionsClosedDefunct();
                        Debug.debugConnectionPool(Level.WARNING, this, conn, "Closing existing connection discovered to be invalid during health check processing", le);
                        conn = this.handleDefunctConnection(conn);
                        if (conn == null) continue;
                        examinedConnections.add(conn);
                        continue;
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        ++numDefunct;
                        conn.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_DEFUNCT, LDAPMessages.ERR_POOL_HEALTH_CHECK_READ_FAILURE.get(StaticUtils.getExceptionMessage(e)), e);
                        this.poolStatistics.incrementNumConnectionsClosedDefunct();
                        Debug.debugConnectionPool(Level.SEVERE, this, conn, "Closing existing connection discovered to be invalid with an unexpected exception type during health check processing", e);
                        conn = this.handleDefunctConnection(conn);
                        if (conn == null) continue;
                        examinedConnections.add(conn);
                        continue;
                    }
                    finally {
                        block45: {
                            if (previousTimeout != Integer.MIN_VALUE) {
                                try {
                                    if (s == null) break block45;
                                    InternalSDKHelper.setSoTimeout(conn, previousTimeout);
                                }
                                catch (Exception e) {
                                    Debug.debugException(e);
                                    ++numDefunct;
                                    conn.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_DEFUNCT, null, e);
                                    this.poolStatistics.incrementNumConnectionsClosedDefunct();
                                    Debug.debugConnectionPool(Level.SEVERE, this, conn, "Closing existing connection during health check processing because an error occurred while attempting to set the SO_TIMEOUT", e);
                                    conn = this.handleDefunctConnection(conn);
                                    if (conn == null) continue;
                                    examinedConnections.add(conn);
                                    continue;
                                }
                            }
                        }
                    }
                }
            }
            try {
                hc.ensureConnectionValidForContinuedUse(conn);
                if (this.availableConnections.offer(conn)) {
                    examinedConnections.add(conn);
                    continue;
                }
                conn.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_UNNEEDED, null, null);
                this.poolStatistics.incrementNumConnectionsClosedUnneeded();
                Debug.debugConnectionPool(Level.INFO, this, conn, "Closing existing connection that passed health check processing because the pool is already full", null);
                conn.terminate(null);
                continue;
            }
            catch (Exception e) {
                Debug.debugException(e);
                ++numDefunct;
                this.poolStatistics.incrementNumConnectionsClosedDefunct();
                Debug.debugConnectionPool(Level.WARNING, this, conn, "Closing existing connection that failed health check processing", e);
                conn = this.handleDefunctConnection(conn);
                if (conn == null) continue;
                examinedConnections.add(conn);
            }
        }
        if (checkMinConnectionGoal) {
            try {
                int neededConnections = this.minConnectionGoal - this.availableConnections.size();
                for (int i = 0; i < neededConnections; ++i) {
                    LDAPConnection conn2 = this.createConnection(hc);
                    if (this.availableConnections.offer(conn2)) continue;
                    conn2.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_UNNEEDED, null, null);
                    this.poolStatistics.incrementNumConnectionsClosedUnneeded();
                    Debug.debugConnectionPool(Level.INFO, this, conn2, "Closing a new connection that was created during health check processing in achieve the minimum connection goal, but the pool had already become full after the connection was created", null);
                    conn2.terminate(null);
                    break;
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        return new LDAPConnectionPoolHealthCheckResult(numExamined, numExpired, numDefunct);
    }

    @Override
    public int getCurrentAvailableConnections() {
        return this.availableConnections.size();
    }

    @Override
    public int getMaximumAvailableConnections() {
        return this.numConnections;
    }

    public int getMinimumAvailableConnectionGoal() {
        return this.minConnectionGoal;
    }

    public void setMinimumAvailableConnectionGoal(int goal) {
        this.minConnectionGoal = goal > this.numConnections ? this.numConnections : (goal > 0 ? goal : 0);
    }

    @Override
    public LDAPConnectionPoolStatistics getConnectionPoolStatistics() {
        return this.poolStatistics;
    }

    public void shrinkPool(int connectionsToRetain) {
        while (this.availableConnections.size() > connectionsToRetain) {
            LDAPConnection conn;
            try {
                conn = this.getConnection();
            }
            catch (LDAPException le) {
                return;
            }
            if (this.availableConnections.size() >= connectionsToRetain) {
                this.discardConnection(conn);
                continue;
            }
            this.releaseConnection(conn);
            return;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("LDAPConnectionPool(");
        String name = this.connectionPoolName;
        if (name != null) {
            buffer.append("name='");
            buffer.append(name);
            buffer.append("', ");
        }
        buffer.append("serverSet=");
        this.serverSet.toString(buffer);
        buffer.append(", maxConnections=");
        buffer.append(this.numConnections);
        buffer.append(')');
    }
}

