/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.monitors;

import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ReplicationSummaryReplicationServer
implements Serializable {
    private static final long serialVersionUID = -3021672478708746554L;
    private final Date replicationServerLastConnected;
    private final Date replicationServerLastFailed;
    private final Long replicationServerFailedAttempts;
    private final Long replicationServerPort;
    private final String generationID;
    private final String replicationServerAddress;
    private final String replicationServerID;
    private final String replicationServerStatus;
    private final String stringRepresentation;

    public ReplicationSummaryReplicationServer(String value) {
        this.stringRepresentation = value;
        this.generationID = ReplicationSummaryReplicationServer.getElementValue(value, "generation-id");
        this.replicationServerID = ReplicationSummaryReplicationServer.getElementValue(value, "server-id");
        String hostPort = ReplicationSummaryReplicationServer.getElementValue(value, "server");
        if (hostPort == null) {
            this.replicationServerAddress = null;
            this.replicationServerPort = null;
        } else {
            Long p;
            String a;
            try {
                int colonPos = hostPort.indexOf(58);
                a = hostPort.substring(0, colonPos);
                p = Long.parseLong(hostPort.substring(colonPos + 1));
            }
            catch (Exception e) {
                Debug.debugException(e);
                a = null;
                p = null;
            }
            this.replicationServerAddress = a;
            this.replicationServerPort = p;
        }
        this.replicationServerStatus = ReplicationSummaryReplicationServer.getElementValue(value, "status");
        this.replicationServerLastConnected = ReplicationSummaryReplicationServer.getElementDateValue(value, "last-connected");
        this.replicationServerLastFailed = ReplicationSummaryReplicationServer.getElementDateValue(value, "last-failed");
        this.replicationServerFailedAttempts = ReplicationSummaryReplicationServer.getElementLongValue(value, "failed-attempts");
    }

    private static String getElementValue(String s, String n) {
        String nPlusEQ = n + "=\"";
        int pos = s.indexOf(nPlusEQ);
        if (pos < 0) {
            return null;
        }
        int closePos = s.indexOf(34, pos += nPlusEQ.length());
        if (closePos <= pos) {
            return null;
        }
        return s.substring(pos, closePos);
    }

    private static Date getElementDateValue(String s, String n) {
        String stringValue = ReplicationSummaryReplicationServer.getElementValue(s, n);
        if (stringValue == null) {
            return null;
        }
        try {
            SimpleDateFormat f = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
            return f.parse(stringValue);
        }
        catch (Exception e) {
            Debug.debugException(e);
            return null;
        }
    }

    private static Long getElementLongValue(String s, String n) {
        String stringValue = ReplicationSummaryReplicationServer.getElementValue(s, n);
        if (stringValue == null) {
            return null;
        }
        try {
            return Long.valueOf(stringValue);
        }
        catch (Exception e) {
            Debug.debugException(e);
            return null;
        }
    }

    public String getReplicationServerID() {
        return this.replicationServerID;
    }

    public String getReplicationServerAddress() {
        return this.replicationServerAddress;
    }

    public Long getReplicationServerPort() {
        return this.replicationServerPort;
    }

    public String getGenerationID() {
        return this.generationID;
    }

    public String getReplicationServerStatus() {
        return this.replicationServerStatus;
    }

    public Date getReplicationServerLastConnected() {
        return this.replicationServerLastConnected;
    }

    public Date getReplicationServerLastFailed() {
        return this.replicationServerLastFailed;
    }

    public Long getReplicationServerFailedAttempts() {
        return this.replicationServerFailedAttempts;
    }

    public String toString() {
        return this.stringRepresentation;
    }
}

