/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tasks;

import com.unboundid.ldap.sdk.unboundidds.tasks.CollectSupportDataSecurityLevel;
import com.unboundid.ldap.sdk.unboundidds.tasks.CollectSupportDataTask;
import com.unboundid.ldap.sdk.unboundidds.tasks.FailedDependencyAction;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskException;
import com.unboundid.util.Debug;
import com.unboundid.util.Mutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.DurationArgument;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class CollectSupportDataTaskProperties
implements Serializable {
    private static final long serialVersionUID = -3920803030511838640L;
    private Boolean alertOnError;
    private Boolean alertOnStart;
    private Boolean alertOnSuccess;
    private Boolean includeBinaryFiles;
    private Boolean includeExpensiveData;
    private Boolean includeExtensionSource;
    private Boolean includeReplicationStateDump;
    private Boolean useSequentialMode;
    private CollectSupportDataSecurityLevel securityLevel;
    private Date scheduledStartTime;
    private FailedDependencyAction failedDependencyAction;
    private Integer jstackCount;
    private Integer reportCount;
    private Integer reportIntervalSeconds;
    private Integer retainPreviousSupportDataArchiveCount;
    private final List<String> dependencyIDs;
    private final List<String> notifyOnCompletion;
    private final List<String> notifyOnError;
    private final List<String> notifyOnStart;
    private final List<String> notifyOnSuccess;
    private String comment;
    private String encryptionPassphraseFile;
    private String logDuration;
    private String outputPath;
    private String retainPreviousSupportDataArchiveAge;
    private String taskID;

    public CollectSupportDataTaskProperties() {
        this.alertOnError = null;
        this.alertOnStart = null;
        this.alertOnSuccess = null;
        this.includeBinaryFiles = null;
        this.includeExpensiveData = null;
        this.includeExtensionSource = null;
        this.includeReplicationStateDump = null;
        this.useSequentialMode = null;
        this.securityLevel = null;
        this.scheduledStartTime = null;
        this.failedDependencyAction = null;
        this.jstackCount = null;
        this.reportCount = null;
        this.reportIntervalSeconds = null;
        this.retainPreviousSupportDataArchiveCount = null;
        this.dependencyIDs = new ArrayList<String>(5);
        this.notifyOnCompletion = new ArrayList<String>(5);
        this.notifyOnError = new ArrayList<String>(5);
        this.notifyOnStart = new ArrayList<String>(5);
        this.notifyOnSuccess = new ArrayList<String>(5);
        this.comment = null;
        this.encryptionPassphraseFile = null;
        this.logDuration = null;
        this.outputPath = null;
        this.retainPreviousSupportDataArchiveAge = null;
        this.taskID = null;
    }

    public CollectSupportDataTaskProperties(CollectSupportDataTaskProperties properties) {
        this.alertOnError = properties.getAlertOnError();
        this.alertOnStart = properties.getAlertOnStart();
        this.alertOnSuccess = properties.getAlertOnSuccess();
        this.includeBinaryFiles = properties.getIncludeBinaryFiles();
        this.includeExpensiveData = properties.getIncludeExpensiveData();
        this.includeExtensionSource = properties.getIncludeExtensionSource();
        this.includeReplicationStateDump = properties.getIncludeReplicationStateDump();
        this.useSequentialMode = properties.getUseSequentialMode();
        this.securityLevel = properties.getSecurityLevel();
        this.scheduledStartTime = properties.getScheduledStartTime();
        this.failedDependencyAction = properties.getFailedDependencyAction();
        this.jstackCount = properties.getJStackCount();
        this.reportCount = properties.getReportCount();
        this.reportIntervalSeconds = properties.getReportIntervalSeconds();
        this.retainPreviousSupportDataArchiveCount = properties.getRetainPreviousSupportDataArchiveCount();
        this.dependencyIDs = new ArrayList<String>(properties.getDependencyIDs());
        this.notifyOnCompletion = new ArrayList<String>(properties.getNotifyOnCompletion());
        this.notifyOnError = new ArrayList<String>(properties.getNotifyOnError());
        this.notifyOnStart = new ArrayList<String>(properties.getNotifyOnStart());
        this.notifyOnSuccess = new ArrayList<String>(properties.getNotifyOnSuccess());
        this.comment = properties.getComment();
        this.encryptionPassphraseFile = properties.getEncryptionPassphraseFile();
        this.logDuration = properties.getLogDuration();
        this.outputPath = properties.getOutputPath();
        this.retainPreviousSupportDataArchiveAge = properties.getRetainPreviousSupportDataArchiveAge();
        this.taskID = properties.getTaskID();
    }

    public CollectSupportDataTaskProperties(CollectSupportDataTask task) {
        this.alertOnError = task.getAlertOnError();
        this.alertOnStart = task.getAlertOnStart();
        this.alertOnSuccess = task.getAlertOnSuccess();
        this.includeBinaryFiles = task.getIncludeBinaryFiles();
        this.includeExpensiveData = task.getIncludeExpensiveData();
        this.includeExtensionSource = task.getIncludeExtensionSource();
        this.includeReplicationStateDump = task.getIncludeReplicationStateDump();
        this.useSequentialMode = task.getUseSequentialMode();
        this.securityLevel = task.getSecurityLevel();
        this.scheduledStartTime = task.getScheduledStartTime();
        this.failedDependencyAction = task.getFailedDependencyAction();
        this.jstackCount = task.getJStackCount();
        this.reportCount = task.getReportCount();
        this.reportIntervalSeconds = task.getReportIntervalSeconds();
        this.retainPreviousSupportDataArchiveCount = task.getRetainPreviousSupportDataArchiveCount();
        this.dependencyIDs = new ArrayList<String>(task.getDependencyIDs());
        this.notifyOnCompletion = new ArrayList<String>(task.getNotifyOnCompletionAddresses());
        this.notifyOnError = new ArrayList<String>(task.getNotifyOnErrorAddresses());
        this.notifyOnStart = new ArrayList<String>(task.getNotifyOnStartAddresses());
        this.notifyOnSuccess = new ArrayList<String>(task.getNotifyOnSuccessAddresses());
        this.comment = task.getComment();
        this.encryptionPassphraseFile = task.getEncryptionPassphraseFile();
        this.logDuration = task.getLogDuration();
        this.outputPath = task.getOutputPath();
        this.retainPreviousSupportDataArchiveAge = task.getRetainPreviousSupportDataArchiveAge();
        this.taskID = task.getTaskID();
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    public String getEncryptionPassphraseFile() {
        return this.encryptionPassphraseFile;
    }

    public void setEncryptionPassphraseFile(String encryptionPassphraseFile) {
        this.encryptionPassphraseFile = encryptionPassphraseFile;
    }

    public Boolean getIncludeExpensiveData() {
        return this.includeExpensiveData;
    }

    public void setIncludeExpensiveData(Boolean includeExpensiveData) {
        this.includeExpensiveData = includeExpensiveData;
    }

    public Boolean getIncludeReplicationStateDump() {
        return this.includeReplicationStateDump;
    }

    public void setIncludeReplicationStateDump(Boolean includeReplicationStateDump) {
        this.includeReplicationStateDump = includeReplicationStateDump;
    }

    public Boolean getIncludeBinaryFiles() {
        return this.includeBinaryFiles;
    }

    public void setIncludeBinaryFiles(Boolean includeBinaryFiles) {
        this.includeBinaryFiles = includeBinaryFiles;
    }

    public Boolean getIncludeExtensionSource() {
        return this.includeExtensionSource;
    }

    public void setIncludeExtensionSource(Boolean includeExtensionSource) {
        this.includeExtensionSource = includeExtensionSource;
    }

    public Boolean getUseSequentialMode() {
        return this.useSequentialMode;
    }

    public void setUseSequentialMode(Boolean useSequentialMode) {
        this.useSequentialMode = useSequentialMode;
    }

    public CollectSupportDataSecurityLevel getSecurityLevel() {
        return this.securityLevel;
    }

    public void setSecurityLevel(CollectSupportDataSecurityLevel securityLevel) {
        this.securityLevel = securityLevel;
    }

    public Integer getReportCount() {
        return this.reportCount;
    }

    public void setReportCount(Integer reportCount) {
        this.reportCount = reportCount;
    }

    public Integer getReportIntervalSeconds() {
        return this.reportIntervalSeconds;
    }

    public void setReportIntervalSeconds(Integer reportIntervalSeconds) {
        this.reportIntervalSeconds = reportIntervalSeconds;
    }

    public Integer getJStackCount() {
        return this.jstackCount;
    }

    public void setJStackCount(Integer jstackCount) {
        this.jstackCount = jstackCount;
    }

    public String getLogDuration() {
        return this.logDuration;
    }

    public Long getLogDurationMillis() throws TaskException {
        if (this.logDuration == null) {
            return null;
        }
        try {
            return DurationArgument.parseDuration(this.logDuration, TimeUnit.MILLISECONDS);
        }
        catch (ArgumentException e) {
            Debug.debugException(e);
            throw new TaskException(e.getMessage(), e);
        }
    }

    public void setLogDuration(String logDuration) throws TaskException {
        if (logDuration == null) {
            this.logDuration = null;
        } else {
            try {
                DurationArgument.parseDuration(logDuration, TimeUnit.MILLISECONDS);
                this.logDuration = logDuration;
            }
            catch (ArgumentException e) {
                Debug.debugException(e);
                throw new TaskException(e.getMessage(), e);
            }
        }
    }

    public void setLogDurationMillis(Long logDurationMillis) {
        this.logDuration = logDurationMillis == null ? null : DurationArgument.nanosToDuration(TimeUnit.MILLISECONDS.toNanos(logDurationMillis));
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Integer getRetainPreviousSupportDataArchiveCount() {
        return this.retainPreviousSupportDataArchiveCount;
    }

    public void setRetainPreviousSupportDataArchiveCount(Integer retainPreviousSupportDataArchiveCount) {
        this.retainPreviousSupportDataArchiveCount = retainPreviousSupportDataArchiveCount;
    }

    public String getRetainPreviousSupportDataArchiveAge() {
        return this.retainPreviousSupportDataArchiveAge;
    }

    public Long getRetainPreviousSupportDataArchiveAgeMillis() throws TaskException {
        if (this.retainPreviousSupportDataArchiveAge == null) {
            return null;
        }
        try {
            return DurationArgument.parseDuration(this.retainPreviousSupportDataArchiveAge, TimeUnit.MILLISECONDS);
        }
        catch (ArgumentException e) {
            Debug.debugException(e);
            throw new TaskException(e.getMessage(), e);
        }
    }

    public void setRetainPreviousSupportDataArchiveAge(String retainPreviousSupportDataArchiveAge) throws TaskException {
        if (retainPreviousSupportDataArchiveAge == null) {
            this.retainPreviousSupportDataArchiveAge = null;
        } else {
            try {
                DurationArgument.parseDuration(retainPreviousSupportDataArchiveAge, TimeUnit.MILLISECONDS);
                this.retainPreviousSupportDataArchiveAge = retainPreviousSupportDataArchiveAge;
            }
            catch (ArgumentException e) {
                Debug.debugException(e);
                throw new TaskException(e.getMessage(), e);
            }
        }
    }

    public void setRetainPreviousSupportDataArchiveAgeMillis(Long retainPreviousSupportDataArchiveAgeMillis) {
        this.retainPreviousSupportDataArchiveAge = retainPreviousSupportDataArchiveAgeMillis == null ? null : DurationArgument.nanosToDuration(TimeUnit.MILLISECONDS.toNanos(retainPreviousSupportDataArchiveAgeMillis));
    }

    public String getTaskID() {
        return this.taskID;
    }

    public void setTaskID(String taskID) {
        this.taskID = taskID;
    }

    public Date getScheduledStartTime() {
        return this.scheduledStartTime;
    }

    public void setScheduledStartTime(Date scheduledStartTime) {
        this.scheduledStartTime = scheduledStartTime;
    }

    public List<String> getDependencyIDs() {
        return new ArrayList<String>(this.dependencyIDs);
    }

    public void setDependencyIDs(List<String> dependencyIDs) {
        this.dependencyIDs.clear();
        if (dependencyIDs != null) {
            this.dependencyIDs.addAll(dependencyIDs);
        }
    }

    public FailedDependencyAction getFailedDependencyAction() {
        return this.failedDependencyAction;
    }

    public void setFailedDependencyAction(FailedDependencyAction failedDependencyAction) {
        this.failedDependencyAction = failedDependencyAction;
    }

    public List<String> getNotifyOnStart() {
        return new ArrayList<String>(this.notifyOnStart);
    }

    public void setNotifyOnStart(List<String> notifyOnStart) {
        this.notifyOnStart.clear();
        if (notifyOnStart != null) {
            this.notifyOnStart.addAll(notifyOnStart);
        }
    }

    public List<String> getNotifyOnCompletion() {
        return new ArrayList<String>(this.notifyOnCompletion);
    }

    public void setNotifyOnCompletion(List<String> notifyOnCompletion) {
        this.notifyOnCompletion.clear();
        if (notifyOnCompletion != null) {
            this.notifyOnCompletion.addAll(notifyOnCompletion);
        }
    }

    public List<String> getNotifyOnSuccess() {
        return new ArrayList<String>(this.notifyOnSuccess);
    }

    public void setNotifyOnSuccess(List<String> notifyOnSuccess) {
        this.notifyOnSuccess.clear();
        if (notifyOnSuccess != null) {
            this.notifyOnSuccess.addAll(notifyOnSuccess);
        }
    }

    public List<String> getNotifyOnError() {
        return new ArrayList<String>(this.notifyOnError);
    }

    public void setNotifyOnError(List<String> notifyOnError) {
        this.notifyOnError.clear();
        if (notifyOnError != null) {
            this.notifyOnError.addAll(notifyOnError);
        }
    }

    public Boolean getAlertOnStart() {
        return this.alertOnStart;
    }

    public void setAlertOnStart(Boolean alertOnStart) {
        this.alertOnStart = alertOnStart;
    }

    public Boolean getAlertOnSuccess() {
        return this.alertOnSuccess;
    }

    public void setAlertOnSuccess(Boolean alertOnSuccess) {
        this.alertOnSuccess = alertOnSuccess;
    }

    public Boolean getAlertOnError() {
        return this.alertOnError;
    }

    public void setAlertOnError(Boolean alertOnError) {
        this.alertOnError = alertOnError;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("CollectSupportDataArchiveProperties(");
        CollectSupportDataTaskProperties.appendNameValuePair(buffer, "taskID", this.taskID);
        CollectSupportDataTaskProperties.appendNameValuePair(buffer, "outputPath", this.outputPath);
        CollectSupportDataTaskProperties.appendNameValuePair(buffer, "encryptionPassphraseFile", this.encryptionPassphraseFile);
        CollectSupportDataTaskProperties.appendNameValuePair(buffer, "includeExpensiveData", this.includeExpensiveData);
        CollectSupportDataTaskProperties.appendNameValuePair(buffer, "includeReplicationStateDump", this.includeReplicationStateDump);
        CollectSupportDataTaskProperties.appendNameValuePair(buffer, "includeBinaryFiles", this.includeBinaryFiles);
        CollectSupportDataTaskProperties.appendNameValuePair(buffer, "includeExtensionSource", this.includeExtensionSource);
        CollectSupportDataTaskProperties.appendNameValuePair(buffer, "securityLevel", (Object)this.securityLevel);
        CollectSupportDataTaskProperties.appendNameValuePair(buffer, "useSequentialMode", this.useSequentialMode);
        CollectSupportDataTaskProperties.appendNameValuePair(buffer, "reportCount", this.reportCount);
        CollectSupportDataTaskProperties.appendNameValuePair(buffer, "reportIntervalSeconds", this.reportIntervalSeconds);
        CollectSupportDataTaskProperties.appendNameValuePair(buffer, "jstackCount", this.jstackCount);
        CollectSupportDataTaskProperties.appendNameValuePair(buffer, "logDuration", this.logDuration);
        CollectSupportDataTaskProperties.appendNameValuePair(buffer, "comment", this.comment);
        CollectSupportDataTaskProperties.appendNameValuePair(buffer, "retainPreviousSupportDataArchiveCount", this.retainPreviousSupportDataArchiveCount);
        CollectSupportDataTaskProperties.appendNameValuePair(buffer, "retainPreviousSupportDataArchiveAge", this.retainPreviousSupportDataArchiveAge);
        CollectSupportDataTaskProperties.appendNameValuePair(buffer, "scheduledStartTime", this.scheduledStartTime);
        CollectSupportDataTaskProperties.appendNameValuePair(buffer, "dependencyIDs", this.dependencyIDs);
        CollectSupportDataTaskProperties.appendNameValuePair(buffer, "failedDependencyAction", (Object)this.failedDependencyAction);
        CollectSupportDataTaskProperties.appendNameValuePair(buffer, "notifyOnStart", this.notifyOnStart);
        CollectSupportDataTaskProperties.appendNameValuePair(buffer, "notifyOnCompletion", this.notifyOnCompletion);
        CollectSupportDataTaskProperties.appendNameValuePair(buffer, "notifyOnSuccess", this.notifyOnSuccess);
        CollectSupportDataTaskProperties.appendNameValuePair(buffer, "notifyOnError", this.notifyOnError);
        CollectSupportDataTaskProperties.appendNameValuePair(buffer, "alertOnStart", this.alertOnStart);
        CollectSupportDataTaskProperties.appendNameValuePair(buffer, "alertOnSuccess", this.alertOnSuccess);
        CollectSupportDataTaskProperties.appendNameValuePair(buffer, "alertOnError", this.alertOnError);
        buffer.append(')');
    }

    private static void appendNameValuePair(StringBuilder buffer, String name, Object value) {
        if (value == null) {
            return;
        }
        if (buffer.length() > 0 && buffer.charAt(buffer.length() - 1) != '(') {
            buffer.append(", ");
        }
        buffer.append(name);
        buffer.append("='");
        buffer.append(value);
        buffer.append('\'');
    }

    private static void appendNameValuePair(StringBuilder buffer, String name, List<String> values) {
        if (values == null || values.isEmpty()) {
            return;
        }
        if (buffer.length() > 0 && buffer.charAt(buffer.length() - 1) != '(') {
            buffer.append(", ");
        }
        buffer.append(name);
        buffer.append("={ ");
        Iterator<String> iterator = values.iterator();
        while (iterator.hasNext()) {
            buffer.append('\'');
            buffer.append(iterator.next());
            buffer.append('\'');
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append('}');
    }
}

