/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tools;

import com.unboundid.ldap.sdk.IntermediateResponse;
import com.unboundid.ldap.sdk.unboundidds.extensions.CollectSupportDataArchiveFragmentIntermediateResponse;
import com.unboundid.ldap.sdk.unboundidds.extensions.CollectSupportDataIntermediateResponseListener;
import com.unboundid.ldap.sdk.unboundidds.extensions.CollectSupportDataOutputIntermediateResponse;
import com.unboundid.ldap.sdk.unboundidds.extensions.CollectSupportDataOutputStream;
import com.unboundid.ldap.sdk.unboundidds.tools.CollectSupportData;
import com.unboundid.ldap.sdk.unboundidds.tools.ToolMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicReference;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
final class CollectSupportDataIRListener
implements CollectSupportDataIntermediateResponseListener,
Closeable {
    private static final int WRAP_COLUMN = StaticUtils.TERMINAL_WIDTH_COLUMNS - 1;
    private final AtomicReference<File> outputFileReference;
    private final AtomicReference<IOException> firstIOExceptionReference;
    private final AtomicReference<OutputStream> outputStreamReference;
    private final CollectSupportData collectSupportData;
    private final File outputPath;
    private long totalArchiveBytesWritten;

    CollectSupportDataIRListener(CollectSupportData collectSupportData, File outputPath) {
        this.collectSupportData = collectSupportData;
        this.outputPath = outputPath;
        this.outputFileReference = new AtomicReference();
        this.firstIOExceptionReference = new AtomicReference();
        this.outputStreamReference = new AtomicReference();
        this.totalArchiveBytesWritten = 0L;
    }

    @Override
    public synchronized void handleOutputIntermediateResponse(CollectSupportDataOutputIntermediateResponse response) {
        if (response.getOutputStream() == CollectSupportDataOutputStream.STANDARD_OUTPUT) {
            this.collectSupportData.wrapOut(0, WRAP_COLUMN, response.getOutputMessage());
        } else {
            this.collectSupportData.wrapErr(0, WRAP_COLUMN, response.getOutputMessage());
        }
    }

    @Override
    public synchronized void handleArchiveFragmentIntermediateResponse(CollectSupportDataArchiveFragmentIntermediateResponse response) {
        block8: {
            OutputStream outputStream;
            File outputFile = this.outputFileReference.get();
            if (outputFile == null) {
                outputFile = this.outputPath == null ? new File(response.getArchiveFileName()).getAbsoluteFile() : (this.outputPath.exists() ? (this.outputPath.isDirectory() ? new File(this.outputPath, response.getArchiveFileName()).getAbsoluteFile() : this.outputPath.getAbsoluteFile()) : this.outputPath.getAbsoluteFile());
                this.outputFileReference.set(outputFile);
            }
            if ((outputStream = this.outputStreamReference.get()) == null) {
                try {
                    outputStream = new FileOutputStream(outputFile);
                    this.outputStreamReference.set(outputStream);
                    this.collectSupportData.out(new Object[0]);
                }
                catch (IOException e) {
                    String message;
                    IOException ioe;
                    Debug.debugException(e);
                    if (this.firstIOExceptionReference.get() == null && this.firstIOExceptionReference.compareAndSet(null, ioe = new IOException(message = ToolMessages.ERR_CSD_LISTENER_CANNOT_CREATE_OUTPUT_FILE.get(outputFile.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e))) {
                        this.collectSupportData.wrapErr(0, WRAP_COLUMN, message);
                    }
                    return;
                }
            }
            try {
                if (this.firstIOExceptionReference.get() == null) {
                    outputStream.write(response.getFragmentData());
                    outputStream.flush();
                    this.totalArchiveBytesWritten += (long)response.getFragmentData().length;
                    this.collectSupportData.wrapOut(0, WRAP_COLUMN, ToolMessages.INFO_CSD_LISTENER_WROTE_FRAGMENT.get(this.totalArchiveBytesWritten, response.getTotalArchiveSizeBytes(), outputFile.getName()));
                }
            }
            catch (IOException e) {
                String message;
                IOException ioe;
                Debug.debugException(e);
                if (this.firstIOExceptionReference.get() != null || !this.firstIOExceptionReference.compareAndSet(null, ioe = new IOException(message = ToolMessages.ERR_CSD_LISTENER_WRITE_ERROR.get(outputFile.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e))) break block8;
                this.collectSupportData.wrapErr(0, WRAP_COLUMN, message);
            }
        }
    }

    @Override
    public synchronized void handleOtherIntermediateResponse(IntermediateResponse response) {
        this.collectSupportData.err(new Object[0]);
        this.collectSupportData.wrapErr(0, WRAP_COLUMN, ToolMessages.WARN_CSD_LISTENER_UNEXPECTED_IR.get(response.getOID()));
    }

    @Override
    public synchronized void close() throws IOException {
        IOException firstIOException;
        block4: {
            OutputStream outputStream = this.outputStreamReference.getAndSet(null);
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    String message;
                    IOException ioe;
                    Debug.debugException(e);
                    if (this.firstIOExceptionReference.get() != null || !this.firstIOExceptionReference.compareAndSet(null, ioe = new IOException(message = ToolMessages.ERR_CSD_LISTENER_CLOSE_ERROR.get(this.outputFileReference.get().getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e))) break block4;
                    this.collectSupportData.wrapErr(0, WRAP_COLUMN, message);
                }
            }
        }
        if ((firstIOException = this.firstIOExceptionReference.get()) != null) {
            throw firstIOException;
        }
    }

    AtomicReference<OutputStream> getOutputStreamReference() {
        return this.outputStreamReference;
    }

    AtomicReference<IOException> getFirstIOExceptionReference() {
        return this.firstIOExceptionReference;
    }
}

